/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.AMQStoreException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.server.binding.Binding;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.store.DurableConfigurationStore;

public class DurableConfigurationStoreHelper {
    public static void updateQueue(DurableConfigurationStore store, AMQQueue queue) throws AMQStoreException {
        LinkedHashMap<String, Object> attributesMap = new LinkedHashMap<String, Object>();
        attributesMap.put("name", queue.getName());
        attributesMap.put("owner", AMQShortString.toString((AMQShortString)queue.getOwner()));
        attributesMap.put("exclusive", queue.isExclusive());
        if (queue.getAlternateExchange() != null) {
            attributesMap.put("alternateExchange", queue.getAlternateExchange().getId());
        } else {
            attributesMap.remove("alternateExchange");
        }
        if (attributesMap.containsKey("arguments")) {
            Map currentArgs = (Map)attributesMap.get("arguments");
            currentArgs.putAll(queue.getArguments());
        } else {
            attributesMap.put("arguments", queue.getArguments());
        }
        store.update(queue.getId(), Queue.class.getName(), attributesMap);
    }

    public static void createQueue(DurableConfigurationStore store, AMQQueue queue, FieldTable arguments) throws AMQStoreException {
        HashMap<String, Object> attributesMap = new HashMap<String, Object>();
        attributesMap.put("name", queue.getName());
        attributesMap.put("owner", AMQShortString.toString((AMQShortString)queue.getOwner()));
        attributesMap.put("exclusive", queue.isExclusive());
        if (queue.getAlternateExchange() != null) {
            attributesMap.put("alternateExchange", queue.getAlternateExchange().getId());
        }
        if (arguments != null) {
            attributesMap.put("arguments", FieldTable.convertToMap((FieldTable)arguments));
        }
        store.create(queue.getId(), Queue.class.getName(), attributesMap);
    }

    public static void removeQueue(DurableConfigurationStore store, AMQQueue queue) throws AMQStoreException {
        store.remove(queue.getId(), Queue.class.getName());
    }

    public static void createExchange(DurableConfigurationStore store, Exchange exchange) throws AMQStoreException {
        HashMap<String, Object> attributesMap = new HashMap<String, Object>();
        attributesMap.put("name", exchange.getName());
        attributesMap.put("type", AMQShortString.toString((AMQShortString)exchange.getTypeShortString()));
        attributesMap.put("lifetimePolicy", exchange.isAutoDelete() ? LifetimePolicy.AUTO_DELETE.name() : LifetimePolicy.PERMANENT.name());
        store.create(exchange.getId(), org.apache.qpid.server.model.Exchange.class.getName(), attributesMap);
    }

    public static void removeExchange(DurableConfigurationStore store, Exchange exchange) throws AMQStoreException {
        store.remove(exchange.getId(), org.apache.qpid.server.model.Exchange.class.getName());
    }

    public static void createBinding(DurableConfigurationStore store, Binding binding) throws AMQStoreException {
        HashMap<String, Object> attributesMap = new HashMap<String, Object>();
        attributesMap.put("name", binding.getBindingKey());
        attributesMap.put("exchange", binding.getExchange().getId());
        attributesMap.put("queue", binding.getQueue().getId());
        Map<String, Object> arguments = binding.getArguments();
        if (arguments != null) {
            attributesMap.put("arguments", arguments);
        }
        store.create(binding.getId(), org.apache.qpid.server.model.Binding.class.getName(), attributesMap);
    }

    public static void removeBinding(DurableConfigurationStore store, Binding binding) throws AMQStoreException {
        store.remove(binding.getId(), org.apache.qpid.server.model.Binding.class.getName());
    }
}

