/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store;

import org.apache.qpid.server.plugin.MessageMetaDataType;
import org.apache.qpid.server.plugin.QpidServiceLoader;

public class MessageMetaDataTypeRegistry {
    private static MessageMetaDataType[] values;

    public static MessageMetaDataType fromOrdinal(int ordinal) {
        return values[ordinal];
    }

    static {
        int maxOrdinal = -1;
        Iterable<MessageMetaDataType> messageMetaDataTypes = new QpidServiceLoader<MessageMetaDataType>().atLeastOneInstanceOf(MessageMetaDataType.class);
        for (MessageMetaDataType type : messageMetaDataTypes) {
            if (type.ordinal() <= maxOrdinal) continue;
            maxOrdinal = type.ordinal();
        }
        values = new MessageMetaDataType[maxOrdinal + 1];
        for (MessageMetaDataType type : new QpidServiceLoader<MessageMetaDataType>().instancesOf(MessageMetaDataType.class)) {
            if (values[type.ordinal()] != null) {
                throw new IllegalStateException("Multiple MessageDataType (" + values[type.ordinal()].getClass().getName() + ", " + type.getClass().getName() + ") defined for the same ordinal value: " + type.ordinal());
            }
            MessageMetaDataTypeRegistry.values[type.ordinal()] = type;
        }
    }
}

