/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store;

import org.apache.qpid.server.logging.LogSubject;
import org.apache.qpid.server.logging.actors.CurrentActor;
import org.apache.qpid.server.logging.messages.ConfigStoreMessages;
import org.apache.qpid.server.logging.messages.MessageStoreMessages;
import org.apache.qpid.server.logging.messages.TransactionLogMessages;
import org.apache.qpid.server.store.Event;
import org.apache.qpid.server.store.EventListener;
import org.apache.qpid.server.store.MessageStore;

public class OperationalLoggingListener
implements EventListener {
    protected final LogSubject _logSubject;
    private MessageStore _store;

    private OperationalLoggingListener(MessageStore store, LogSubject logSubject) {
        this._logSubject = logSubject;
        store.addEventListener(this, Event.BEFORE_INIT, Event.AFTER_INIT, Event.BEFORE_ACTIVATE, Event.AFTER_ACTIVATE, Event.AFTER_CLOSE, Event.PERSISTENT_MESSAGE_SIZE_OVERFULL, Event.PERSISTENT_MESSAGE_SIZE_UNDERFULL);
        this._store = store;
    }

    public void event(Event event) {
        switch (event) {
            case BEFORE_INIT: {
                CurrentActor.get().message(this._logSubject, ConfigStoreMessages.CREATED());
                break;
            }
            case AFTER_INIT: {
                CurrentActor.get().message(this._logSubject, MessageStoreMessages.CREATED());
                CurrentActor.get().message(this._logSubject, TransactionLogMessages.CREATED());
                String storeLocation = this._store.getStoreLocation();
                if (storeLocation == null) break;
                CurrentActor.get().message(this._logSubject, MessageStoreMessages.STORE_LOCATION(storeLocation));
                break;
            }
            case BEFORE_ACTIVATE: {
                CurrentActor.get().message(this._logSubject, MessageStoreMessages.RECOVERY_START());
                break;
            }
            case AFTER_ACTIVATE: {
                CurrentActor.get().message(this._logSubject, MessageStoreMessages.RECOVERY_COMPLETE());
                break;
            }
            case AFTER_CLOSE: {
                CurrentActor.get().message(this._logSubject, MessageStoreMessages.CLOSED());
                break;
            }
            case PERSISTENT_MESSAGE_SIZE_OVERFULL: {
                CurrentActor.get().message(this._logSubject, MessageStoreMessages.OVERFULL());
                break;
            }
            case PERSISTENT_MESSAGE_SIZE_UNDERFULL: {
                CurrentActor.get().message(this._logSubject, MessageStoreMessages.UNDERFULL());
            }
        }
    }

    public static void listen(MessageStore store, LogSubject logSubject) {
        new OperationalLoggingListener(store, logSubject);
    }
}

