/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store;

import java.util.EnumMap;
import java.util.Map;
import org.apache.qpid.server.store.Event;
import org.apache.qpid.server.store.EventListener;
import org.apache.qpid.server.store.EventManager;
import org.apache.qpid.server.store.State;

public class StateManager {
    private State _state = State.INITIAL;
    private EventListener _eventListener;
    private static final Map<State, Map<State, Transition>> _validTransitions = new EnumMap<State, Map<State, Transition>>(State.class);
    public static final Transition INITIALISE = new Transition(State.INITIAL, State.INITIALISING, Event.BEFORE_INIT);
    public static final Transition INITALISE_COMPLETE = new Transition(State.INITIALISING, State.INITIALISED, Event.AFTER_INIT);
    public static final Transition ACTIVATE = new Transition(State.INITIALISED, State.ACTIVATING, Event.BEFORE_ACTIVATE);
    public static final Transition ACTIVATE_COMPLETE = new Transition(State.ACTIVATING, State.ACTIVE, Event.AFTER_ACTIVATE);
    public static final Transition CLOSE_INITIALISED = new Transition(State.INITIALISED, State.CLOSING, Event.BEFORE_CLOSE);
    public static final Transition CLOSE_ACTIVE = new Transition(State.ACTIVE, State.CLOSING, Event.BEFORE_CLOSE);
    public static final Transition CLOSE_QUIESCED = new Transition(State.QUIESCED, State.CLOSING, Event.BEFORE_CLOSE);
    public static final Transition CLOSE_COMPLETE = new Transition(State.CLOSING, State.CLOSED, Event.AFTER_CLOSE);
    public static final Transition PASSIVATE = new Transition(State.ACTIVE, State.INITIALISED, Event.BEFORE_PASSIVATE);
    public static final Transition QUIESCE = new Transition(State.ACTIVE, State.QUIESCING, Event.BEFORE_QUIESCE);
    public static final Transition QUIESCE_COMPLETE = new Transition(State.QUIESCING, State.QUIESCED, Event.AFTER_QUIESCE);
    public static final Transition RESTART = new Transition(State.QUIESCED, State.ACTIVATING, Event.BEFORE_RESTART);

    public StateManager(final EventManager eventManager) {
        this(new EventListener(){

            public void event(Event event) {
                eventManager.notifyEvent(event);
            }
        });
    }

    public StateManager(EventListener eventListener) {
        this._eventListener = eventListener;
    }

    public synchronized State getState() {
        return this._state;
    }

    public synchronized void attainState(State desired) {
        Transition transition = null;
        Map<State, Transition> stateTransitionMap = _validTransitions.get((Object)this._state);
        if (stateTransitionMap != null) {
            transition = stateTransitionMap.get((Object)desired);
        }
        if (transition == null) {
            throw new IllegalStateException("No valid transition from state " + (Object)((Object)this._state) + " to state " + (Object)((Object)desired));
        }
        this._state = desired;
        this._eventListener.event(transition.getEvent());
    }

    public synchronized boolean isInState(State testedState) {
        return this._state.equals((Object)testedState);
    }

    public synchronized boolean isNotInState(State testedState) {
        return !this.isInState(testedState);
    }

    public synchronized void checkInState(State checkedState) {
        if (this.isNotInState(checkedState)) {
            throw new IllegalStateException("Unexpected state. Was : " + (Object)((Object)this._state) + " but expected : " + (Object)((Object)checkedState));
        }
    }

    static class Transition {
        private final Event _event;
        private final State _endState;
        private final State _startState;

        public Transition(State startState, State endState, Event event) {
            this._event = event;
            this._startState = startState;
            this._endState = endState;
            EnumMap<State, Transition> stateTransitions = (EnumMap<State, Transition>)_validTransitions.get((Object)startState);
            if (stateTransitions == null) {
                stateTransitions = new EnumMap<State, Transition>(State.class);
                _validTransitions.put(startState, stateTransitions);
            }
            stateTransitions.put(endState, this);
        }

        public Event getEvent() {
            return this._event;
        }

        public State getStartState() {
            return this._startState;
        }

        public State getEndState() {
            return this._endState;
        }
    }
}

