/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.subscription;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.queue.QueueEntryVisitor;
import org.apache.qpid.server.subscription.MessageGroupManager;
import org.apache.qpid.server.subscription.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssignedSubscriptionMessageGroupManager
implements MessageGroupManager {
    private static final Logger _logger = LoggerFactory.getLogger(AssignedSubscriptionMessageGroupManager.class);
    private final String _groupId;
    private final ConcurrentHashMap<Integer, Subscription> _groupMap = new ConcurrentHashMap();
    private final int _groupMask;

    public AssignedSubscriptionMessageGroupManager(String groupId, int maxGroups) {
        this._groupId = groupId;
        this._groupMask = AssignedSubscriptionMessageGroupManager.pow2(maxGroups) - 1;
    }

    private static int pow2(int i) {
        int val;
        for (val = 1; val < i; val <<= 1) {
        }
        return val;
    }

    public Subscription getAssignedSubscription(QueueEntry entry) {
        Object groupVal = entry.getMessage().getMessageHeader().getHeader(this._groupId);
        return groupVal == null ? null : this._groupMap.get(groupVal.hashCode() & this._groupMask);
    }

    public boolean acceptMessage(Subscription sub, QueueEntry entry) {
        Object groupVal = entry.getMessage().getMessageHeader().getHeader(this._groupId);
        if (groupVal == null) {
            return true;
        }
        Integer group = groupVal.hashCode() & this._groupMask;
        Subscription assignedSub = this._groupMap.get(group);
        if (assignedSub == sub) {
            return true;
        }
        if (assignedSub == null) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Assigning group " + groupVal + " to sub " + sub);
            }
            return (assignedSub = this._groupMap.putIfAbsent(group, sub)) == null || assignedSub == sub;
        }
        return false;
    }

    public QueueEntry findEarliestAssignedAvailableEntry(Subscription sub) {
        EntryFinder visitor = new EntryFinder(sub);
        sub.getQueue().visit(visitor);
        return visitor.getEntry();
    }

    public void clearAssignments(Subscription sub) {
        Iterator<Subscription> subIter = this._groupMap.values().iterator();
        while (subIter.hasNext()) {
            if (subIter.next() != sub) continue;
            subIter.remove();
        }
    }

    private class EntryFinder
    implements QueueEntryVisitor {
        private QueueEntry _entry;
        private Subscription _sub;

        public EntryFinder(Subscription sub) {
            this._sub = sub;
        }

        public boolean visit(QueueEntry entry) {
            if (!entry.isAvailable()) {
                return false;
            }
            Object groupId = entry.getMessage().getMessageHeader().getHeader(AssignedSubscriptionMessageGroupManager.this._groupId);
            if (groupId == null) {
                return false;
            }
            Integer group = groupId.hashCode() & AssignedSubscriptionMessageGroupManager.this._groupMask;
            Subscription assignedSub = (Subscription)AssignedSubscriptionMessageGroupManager.this._groupMap.get(group);
            if (assignedSub == this._sub) {
                this._entry = entry;
                return true;
            }
            return false;
        }

        public QueueEntry getEntry() {
            return this._entry;
        }
    }
}

