/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.txn;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.qpid.server.message.EnqueableMessage;
import org.apache.qpid.server.protocol.AMQSessionModel;
import org.apache.qpid.server.queue.BaseQueue;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.txn.AlreadyKnownDtxException;
import org.apache.qpid.server.txn.AutoCommitTransaction;
import org.apache.qpid.server.txn.DtxBranch;
import org.apache.qpid.server.txn.JoinAndResumeDtxException;
import org.apache.qpid.server.txn.NotAssociatedDtxException;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.server.txn.SuspendAndFailDtxException;
import org.apache.qpid.server.txn.TimeoutDtxException;
import org.apache.qpid.server.txn.UnknownDtxBranchException;
import org.apache.qpid.server.virtualhost.VirtualHost;
import org.apache.qpid.transport.Xid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributedTransaction
implements ServerTransaction {
    private final AutoCommitTransaction _autoCommitTransaction;
    private DtxBranch _branch;
    private AMQSessionModel _session;
    private VirtualHost _vhost;

    public DistributedTransaction(AMQSessionModel session, MessageStore store, VirtualHost vhost) {
        this._session = session;
        this._vhost = vhost;
        this._autoCommitTransaction = new AutoCommitTransaction(vhost.getMessageStore());
    }

    @Override
    public long getTransactionStartTime() {
        return 0L;
    }

    @Override
    public long getTransactionUpdateTime() {
        return 0L;
    }

    @Override
    public void addPostTransactionAction(ServerTransaction.Action postTransactionAction) {
        if (this._branch != null) {
            this._branch.addPostTransactionAcion(postTransactionAction);
        } else {
            this._autoCommitTransaction.addPostTransactionAction(postTransactionAction);
        }
    }

    @Override
    public void dequeue(BaseQueue queue, EnqueableMessage message, ServerTransaction.Action postTransactionAction) {
        if (this._branch != null) {
            this._branch.dequeue(queue, message);
            this._branch.addPostTransactionAcion(postTransactionAction);
        } else {
            this._autoCommitTransaction.dequeue(queue, message, postTransactionAction);
        }
    }

    @Override
    public void dequeue(Collection<QueueEntry> messages, ServerTransaction.Action postTransactionAction) {
        if (this._branch != null) {
            for (QueueEntry entry : messages) {
                this._branch.dequeue(entry.getQueue(), entry.getMessage());
            }
            this._branch.addPostTransactionAcion(postTransactionAction);
        } else {
            this._autoCommitTransaction.dequeue(messages, postTransactionAction);
        }
    }

    @Override
    public void enqueue(BaseQueue queue, EnqueableMessage message, ServerTransaction.Action postTransactionAction) {
        if (this._branch != null) {
            this._branch.enqueue(queue, message);
            this._branch.addPostTransactionAcion(postTransactionAction);
            this.enqueue(Collections.singletonList(queue), message, postTransactionAction);
        } else {
            this._autoCommitTransaction.enqueue(queue, message, postTransactionAction);
        }
    }

    @Override
    public void enqueue(List<? extends BaseQueue> queues, EnqueableMessage message, ServerTransaction.Action postTransactionAction) {
        if (this._branch != null) {
            for (BaseQueue baseQueue : queues) {
                this._branch.enqueue(baseQueue, message);
            }
            this._branch.addPostTransactionAcion(postTransactionAction);
        } else {
            this._autoCommitTransaction.enqueue(queues, message, postTransactionAction);
        }
    }

    @Override
    public void commit() {
        throw new IllegalStateException("Cannot call tx.commit() on a distributed transaction");
    }

    @Override
    public void commit(Runnable immediatePostTransactionAction) {
        throw new IllegalStateException("Cannot call tx.commit() on a distributed transaction");
    }

    @Override
    public void rollback() {
        throw new IllegalStateException("Cannot call tx.rollback() on a distributed transaction");
    }

    @Override
    public boolean isTransactional() {
        return this._branch != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void start(Xid id, boolean join, boolean resume) throws UnknownDtxBranchException, AlreadyKnownDtxException, JoinAndResumeDtxException {
        if (join && resume) {
            throw new JoinAndResumeDtxException(id);
        }
        DtxBranch branch = this._vhost.getDtxRegistry().getBranch(id);
        if (branch == null) {
            if (join || resume) {
                throw new UnknownDtxBranchException(id);
            }
            branch = new DtxBranch(id, this._vhost.getMessageStore(), this._vhost);
            if (!this._vhost.getDtxRegistry().registerBranch(branch)) throw new AlreadyKnownDtxException(id);
            this._branch = branch;
            branch.associateSession(this._session);
            return;
        } else {
            if (join) {
                branch.associateSession(this._session);
            } else {
                if (!resume) throw new AlreadyKnownDtxException(id);
                branch.resumeSession(this._session);
            }
            this._branch = branch;
        }
    }

    public void end(Xid id, boolean fail, boolean suspend) throws UnknownDtxBranchException, NotAssociatedDtxException, SuspendAndFailDtxException, TimeoutDtxException {
        DtxBranch branch = this._vhost.getDtxRegistry().getBranch(id);
        if (suspend && fail) {
            branch.disassociateSession(this._session);
            this._branch = null;
            throw new SuspendAndFailDtxException(id);
        }
        if (branch == null) {
            throw new UnknownDtxBranchException(id);
        }
        if (!branch.isAssociated(this._session)) {
            throw new NotAssociatedDtxException(id);
        }
        if (branch.expired() || branch.getState() == DtxBranch.State.TIMEDOUT) {
            branch.disassociateSession(this._session);
            throw new TimeoutDtxException(id);
        }
        if (suspend) {
            branch.suspendSession(this._session);
        } else {
            if (fail) {
                branch.setState(DtxBranch.State.ROLLBACK_ONLY);
            }
            branch.disassociateSession(this._session);
        }
        this._branch = null;
    }
}

