/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhost;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.server.configuration.ExchangeConfiguration;
import org.apache.qpid.server.configuration.QueueConfiguration;
import org.apache.qpid.server.configuration.VirtualHostConfiguration;
import org.apache.qpid.server.connection.ConnectionRegistry;
import org.apache.qpid.server.connection.IConnectionRegistry;
import org.apache.qpid.server.exchange.DefaultExchangeFactory;
import org.apache.qpid.server.exchange.DefaultExchangeRegistry;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.exchange.ExchangeFactory;
import org.apache.qpid.server.exchange.ExchangeRegistry;
import org.apache.qpid.server.logging.actors.CurrentActor;
import org.apache.qpid.server.logging.messages.VirtualHostMessages;
import org.apache.qpid.server.model.UUIDGenerator;
import org.apache.qpid.server.plugin.ExchangeType;
import org.apache.qpid.server.protocol.AMQConnectionModel;
import org.apache.qpid.server.protocol.AMQSessionModel;
import org.apache.qpid.server.protocol.LinkRegistry;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.AMQQueueFactory;
import org.apache.qpid.server.queue.DefaultQueueRegistry;
import org.apache.qpid.server.queue.QueueRegistry;
import org.apache.qpid.server.security.SecurityManager;
import org.apache.qpid.server.stats.StatisticsCounter;
import org.apache.qpid.server.stats.StatisticsGatherer;
import org.apache.qpid.server.store.DurableConfigurationStoreHelper;
import org.apache.qpid.server.store.Event;
import org.apache.qpid.server.store.EventListener;
import org.apache.qpid.server.txn.DtxRegistry;
import org.apache.qpid.server.virtualhost.ExchangeExistsException;
import org.apache.qpid.server.virtualhost.ExchangeIsAlternateException;
import org.apache.qpid.server.virtualhost.HouseKeepingTask;
import org.apache.qpid.server.virtualhost.RequiredExchangeException;
import org.apache.qpid.server.virtualhost.ReservedExchangeNameException;
import org.apache.qpid.server.virtualhost.State;
import org.apache.qpid.server.virtualhost.UnknownExchangeException;
import org.apache.qpid.server.virtualhost.VirtualHost;
import org.apache.qpid.server.virtualhost.VirtualHostListener;
import org.apache.qpid.server.virtualhost.VirtualHostRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractVirtualHost
implements VirtualHost,
IConnectionRegistry.RegistryChangeListener,
EventListener {
    private static final Logger _logger = Logger.getLogger(AbstractVirtualHost.class);
    private static final int HOUSEKEEPING_SHUTDOWN_TIMEOUT = 5;
    private final String _name;
    private final UUID _id;
    private final long _createTime = System.currentTimeMillis();
    private final ScheduledThreadPoolExecutor _houseKeepingTasks;
    private final VirtualHostRegistry _virtualHostRegistry;
    private final StatisticsGatherer _brokerStatisticsGatherer;
    private final SecurityManager _securityManager;
    private final VirtualHostConfiguration _vhostConfig;
    private final QueueRegistry _queueRegistry;
    private final ExchangeRegistry _exchangeRegistry;
    private final ExchangeFactory _exchangeFactory;
    private final ConnectionRegistry _connectionRegistry;
    private final DtxRegistry _dtxRegistry;
    private volatile State _state = State.INITIALISING;
    private StatisticsCounter _messagesDelivered;
    private StatisticsCounter _dataDelivered;
    private StatisticsCounter _messagesReceived;
    private StatisticsCounter _dataReceived;
    private final Map<String, LinkRegistry> _linkRegistry = new HashMap<String, LinkRegistry>();
    private boolean _blocked;

    public AbstractVirtualHost(VirtualHostRegistry virtualHostRegistry, StatisticsGatherer brokerStatisticsGatherer, SecurityManager parentSecurityManager, VirtualHostConfiguration hostConfig, org.apache.qpid.server.model.VirtualHost virtualHost) throws Exception {
        if (hostConfig == null) {
            throw new IllegalArgumentException("HostConfig cannot be null");
        }
        if (hostConfig.getName() == null || hostConfig.getName().length() == 0) {
            throw new IllegalArgumentException("Illegal name (" + hostConfig.getName() + ") for virtualhost.");
        }
        this._virtualHostRegistry = virtualHostRegistry;
        this._brokerStatisticsGatherer = brokerStatisticsGatherer;
        this._vhostConfig = hostConfig;
        this._name = this._vhostConfig.getName();
        this._dtxRegistry = new DtxRegistry();
        this._id = UUIDGenerator.generateVhostUUID(this._name);
        CurrentActor.get().message(VirtualHostMessages.CREATED(this._name));
        this._securityManager = new SecurityManager(parentSecurityManager, this._vhostConfig.getConfig().getString("security.acl"), this._name);
        this._connectionRegistry = new ConnectionRegistry();
        this._connectionRegistry.addRegistryChangeListener(this);
        this._houseKeepingTasks = new ScheduledThreadPoolExecutor(this._vhostConfig.getHouseKeepingThreadCount());
        this._queueRegistry = new DefaultQueueRegistry(this);
        this._exchangeFactory = new DefaultExchangeFactory(this);
        this._exchangeRegistry = new DefaultExchangeRegistry(this);
        this.initialiseStatistics();
        this.initialiseStorage(hostConfig, virtualHost);
        this.getMessageStore().addEventListener(this, Event.PERSISTENT_MESSAGE_SIZE_OVERFULL);
        this.getMessageStore().addEventListener(this, Event.PERSISTENT_MESSAGE_SIZE_UNDERFULL);
    }

    protected abstract void initialiseStorage(VirtualHostConfiguration var1, org.apache.qpid.server.model.VirtualHost var2) throws Exception;

    @Override
    public IConnectionRegistry getConnectionRegistry() {
        return this._connectionRegistry;
    }

    @Override
    public VirtualHostConfiguration getConfiguration() {
        return this._vhostConfig;
    }

    @Override
    public UUID getId() {
        return this._id;
    }

    public boolean isDurable() {
        return false;
    }

    private void initialiseHouseKeeping(long period) {
        if (period != 0L) {
            this.scheduleHouseKeepingTask(period, new VirtualHostHouseKeepingTask());
        }
    }

    protected void shutdownHouseKeeping() {
        this._houseKeepingTasks.shutdown();
        try {
            if (!this._houseKeepingTasks.awaitTermination(5L, TimeUnit.SECONDS)) {
                this._houseKeepingTasks.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            _logger.warn((Object)"Interrupted during Housekeeping shutdown:", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    protected void removeHouseKeepingTasks() {
        BlockingQueue<Runnable> taskQueue = this._houseKeepingTasks.getQueue();
        for (Runnable runnable : taskQueue) {
            this._houseKeepingTasks.remove(runnable);
        }
    }

    @Override
    public void scheduleHouseKeepingTask(long period, HouseKeepingTask task) {
        this._houseKeepingTasks.scheduleAtFixedRate(task, period / 2L, period, TimeUnit.MILLISECONDS);
    }

    @Override
    public ScheduledFuture<?> scheduleTask(long delay, Runnable task) {
        return this._houseKeepingTasks.schedule(task, delay, TimeUnit.MILLISECONDS);
    }

    @Override
    public long getHouseKeepingTaskCount() {
        return this._houseKeepingTasks.getTaskCount();
    }

    @Override
    public long getHouseKeepingCompletedTaskCount() {
        return this._houseKeepingTasks.getCompletedTaskCount();
    }

    @Override
    public int getHouseKeepingPoolSize() {
        return this._houseKeepingTasks.getCorePoolSize();
    }

    @Override
    public void setHouseKeepingPoolSize(int newSize) {
        this._houseKeepingTasks.setCorePoolSize(newSize);
    }

    @Override
    public int getHouseKeepingActiveCount() {
        return this._houseKeepingTasks.getActiveCount();
    }

    protected void initialiseModel(VirtualHostConfiguration config) throws ConfigurationException, AMQException {
        String[] queueNames;
        _logger.debug((Object)("Loading configuration for virtualhost: " + config.getName()));
        this._exchangeRegistry.initialise(this._exchangeFactory);
        List exchangeNames = config.getExchanges();
        for (String exchangeName : exchangeNames) {
            this.configureExchange(config.getExchangeConfiguration(exchangeName));
        }
        for (String queueNameObj : queueNames = config.getQueueNames()) {
            String queueName = String.valueOf(queueNameObj);
            this.configureQueue(config.getQueueConfiguration(queueName));
        }
    }

    private void configureExchange(ExchangeConfiguration exchangeConfiguration) throws AMQException {
        boolean durable = exchangeConfiguration.getDurable();
        boolean autodelete = exchangeConfiguration.getAutoDelete();
        try {
            Exchange newExchange = this.createExchange(null, exchangeConfiguration.getName(), exchangeConfiguration.getType(), durable, autodelete, null);
        }
        catch (ExchangeExistsException e) {
            _logger.info((Object)("Exchange " + exchangeConfiguration.getName() + " already defined. Configuration in XML file ignored"));
        }
    }

    private void configureQueue(QueueConfiguration queueConfiguration) throws AMQException, ConfigurationException {
        String exchangeName;
        Exchange exchange;
        AMQQueue queue = AMQQueueFactory.createAMQQueueImpl(queueConfiguration, this);
        String queueName = queue.getName();
        if (queue.isDurable()) {
            DurableConfigurationStoreHelper.createQueue(this.getDurableConfigurationStore(), queue, null);
        }
        if ((exchange = this._exchangeRegistry.getExchange(exchangeName = queueConfiguration.getExchange())) == null) {
            throw new ConfigurationException("Attempt to bind queue '" + queueName + "' to unknown exchange:" + exchangeName);
        }
        Exchange defaultExchange = this._exchangeRegistry.getDefaultExchange();
        List routingKeys = queueConfiguration.getRoutingKeys();
        for (Object routingKeyNameObj : routingKeys) {
            String routingKey = String.valueOf(routingKeyNameObj);
            if (exchange.equals(defaultExchange)) {
                if (queueName.equals(routingKey)) continue;
                throw new ConfigurationException("Illegal attempt to bind queue '" + queueName + "' to the default exchange with a key other than the queue name: " + routingKey);
            }
            this.configureBinding(queue, exchange, routingKey, queueConfiguration.getBindingArguments(routingKey));
        }
        if (!exchange.equals(defaultExchange) && !routingKeys.contains(queueName)) {
            this.configureBinding(queue, exchange, queueName, null);
        }
    }

    private void configureBinding(AMQQueue queue, Exchange exchange, String routingKey, Map<String, Object> arguments) throws AMQException {
        if (_logger.isInfoEnabled()) {
            _logger.info((Object)("Binding queue:" + queue + " with routing key '" + routingKey + "' to exchange:" + exchange.getName()));
        }
        exchange.addBinding(routingKey, queue, arguments);
    }

    @Override
    public String getName() {
        return this._name;
    }

    public long getCreateTime() {
        return this._createTime;
    }

    @Override
    public QueueRegistry getQueueRegistry() {
        return this._queueRegistry;
    }

    protected ExchangeRegistry getExchangeRegistry() {
        return this._exchangeRegistry;
    }

    protected ExchangeFactory getExchangeFactory() {
        return this._exchangeFactory;
    }

    @Override
    public void addVirtualHostListener(final VirtualHostListener listener) {
        this._exchangeRegistry.addRegistryChangeListener(new ExchangeRegistry.RegistryChangeListener(){

            public void exchangeRegistered(Exchange exchange) {
                listener.exchangeRegistered(exchange);
            }

            public void exchangeUnregistered(Exchange exchange) {
                listener.exchangeUnregistered(exchange);
            }
        });
        this._queueRegistry.addRegistryChangeListener(new QueueRegistry.RegistryChangeListener(){

            public void queueRegistered(AMQQueue queue) {
                listener.queueRegistered(queue);
            }

            public void queueUnregistered(AMQQueue queue) {
                listener.queueUnregistered(queue);
            }
        });
        this._connectionRegistry.addRegistryChangeListener(new IConnectionRegistry.RegistryChangeListener(){

            public void connectionRegistered(AMQConnectionModel connection) {
                listener.connectionRegistered(connection);
            }

            public void connectionUnregistered(AMQConnectionModel connection) {
                listener.connectionUnregistered(connection);
            }
        });
    }

    @Override
    public Exchange getExchange(String name) {
        return this._exchangeRegistry.getExchange(name);
    }

    @Override
    public Exchange getDefaultExchange() {
        return this._exchangeRegistry.getDefaultExchange();
    }

    @Override
    public Collection<Exchange> getExchanges() {
        return Collections.unmodifiableCollection(this._exchangeRegistry.getExchanges());
    }

    @Override
    public Collection<ExchangeType<? extends Exchange>> getExchangeTypes() {
        return this._exchangeFactory.getRegisteredTypes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Exchange createExchange(UUID id, String name, String type, boolean durable, boolean autoDelete, String alternateExchangeName) throws AMQException {
        if (this._exchangeRegistry.isReservedExchangeName(name)) {
            throw new ReservedExchangeNameException(name);
        }
        ExchangeRegistry exchangeRegistry = this._exchangeRegistry;
        synchronized (exchangeRegistry) {
            Exchange alternateExchange;
            Exchange existing = this._exchangeRegistry.getExchange(name);
            if (existing != null) {
                throw new ExchangeExistsException(name, existing);
            }
            if (alternateExchangeName != null) {
                alternateExchange = this._exchangeRegistry.getExchange(alternateExchangeName);
                if (alternateExchange == null) {
                    throw new UnknownExchangeException(alternateExchangeName);
                }
            } else {
                alternateExchange = null;
            }
            if (id == null) {
                id = UUIDGenerator.generateExchangeUUID(name, this.getName());
            }
            Exchange exchange = this._exchangeFactory.createExchange(id, name, type, durable, autoDelete);
            exchange.setAlternateExchange(alternateExchange);
            this._exchangeRegistry.registerExchange(exchange);
            if (durable) {
                DurableConfigurationStoreHelper.createExchange(this.getDurableConfigurationStore(), exchange);
            }
            return exchange;
        }
    }

    @Override
    public void removeExchange(Exchange exchange, boolean force) throws AMQException {
        if (exchange.hasReferrers()) {
            throw new ExchangeIsAlternateException(exchange.getName());
        }
        for (ExchangeType<? extends Exchange> type : this.getExchangeTypes()) {
            if (!type.getDefaultExchangeName().toString().equals(exchange.getName())) continue;
            throw new RequiredExchangeException(exchange.getName());
        }
        this._exchangeRegistry.unregisterExchange(exchange.getName(), !force);
        if (exchange.isDurable() && !exchange.isAutoDelete()) {
            DurableConfigurationStoreHelper.removeExchange(this.getDurableConfigurationStore(), exchange);
        }
    }

    @Override
    public SecurityManager getSecurityManager() {
        return this._securityManager;
    }

    @Override
    public void close() {
        this._connectionRegistry.close();
        this._queueRegistry.stopAllAndUnregisterMBeans();
        this._dtxRegistry.close();
        this.closeStorage();
        this.shutdownHouseKeeping();
        this._exchangeRegistry.clearAndUnregisterMbeans();
        this._state = State.STOPPED;
        CurrentActor.get().message(VirtualHostMessages.CLOSED());
    }

    protected void closeStorage() {
        if (this.getMessageStore() != null) {
            try {
                this.getMessageStore().close();
            }
            catch (Exception e) {
                _logger.error((Object)"Failed to close message store", (Throwable)e);
            }
        }
    }

    protected Logger getLogger() {
        return _logger;
    }

    @Override
    public VirtualHostRegistry getVirtualHostRegistry() {
        return this._virtualHostRegistry;
    }

    @Override
    public void registerMessageDelivered(long messageSize) {
        this._messagesDelivered.registerEvent(1L);
        this._dataDelivered.registerEvent(messageSize);
        this._brokerStatisticsGatherer.registerMessageDelivered(messageSize);
    }

    @Override
    public void registerMessageReceived(long messageSize, long timestamp) {
        this._messagesReceived.registerEvent(1L, timestamp);
        this._dataReceived.registerEvent(messageSize, timestamp);
        this._brokerStatisticsGatherer.registerMessageReceived(messageSize, timestamp);
    }

    @Override
    public StatisticsCounter getMessageReceiptStatistics() {
        return this._messagesReceived;
    }

    @Override
    public StatisticsCounter getDataReceiptStatistics() {
        return this._dataReceived;
    }

    @Override
    public StatisticsCounter getMessageDeliveryStatistics() {
        return this._messagesDelivered;
    }

    @Override
    public StatisticsCounter getDataDeliveryStatistics() {
        return this._dataDelivered;
    }

    @Override
    public void resetStatistics() {
        this._messagesDelivered.reset();
        this._dataDelivered.reset();
        this._messagesReceived.reset();
        this._dataReceived.reset();
        for (AMQConnectionModel connection : this._connectionRegistry.getConnections()) {
            connection.resetStatistics();
        }
    }

    @Override
    public void initialiseStatistics() {
        this._messagesDelivered = new StatisticsCounter("messages-delivered-" + this.getName());
        this._dataDelivered = new StatisticsCounter("bytes-delivered-" + this.getName());
        this._messagesReceived = new StatisticsCounter("messages-received-" + this.getName());
        this._dataReceived = new StatisticsCounter("bytes-received-" + this.getName());
    }

    @Override
    public synchronized LinkRegistry getLinkRegistry(String remoteContainerId) {
        LinkRegistry linkRegistry = this._linkRegistry.get(remoteContainerId);
        if (linkRegistry == null) {
            linkRegistry = new LinkRegistry();
            this._linkRegistry.put(remoteContainerId, linkRegistry);
        }
        return linkRegistry;
    }

    @Override
    public DtxRegistry getDtxRegistry() {
        return this._dtxRegistry;
    }

    public String toString() {
        return this._name;
    }

    @Override
    public State getState() {
        return this._state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void block() {
        ConnectionRegistry connectionRegistry = this._connectionRegistry;
        synchronized (connectionRegistry) {
            if (!this._blocked) {
                this._blocked = true;
                for (AMQConnectionModel conn : this._connectionRegistry.getConnections()) {
                    conn.block();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unblock() {
        ConnectionRegistry connectionRegistry = this._connectionRegistry;
        synchronized (connectionRegistry) {
            if (this._blocked) {
                this._blocked = false;
                for (AMQConnectionModel conn : this._connectionRegistry.getConnections()) {
                    conn.unblock();
                }
            }
        }
    }

    @Override
    public void connectionRegistered(AMQConnectionModel connection) {
        if (this._blocked) {
            connection.block();
        }
    }

    @Override
    public void connectionUnregistered(AMQConnectionModel connection) {
    }

    @Override
    public void event(Event event) {
        switch (event) {
            case PERSISTENT_MESSAGE_SIZE_OVERFULL: {
                this.block();
                break;
            }
            case PERSISTENT_MESSAGE_SIZE_UNDERFULL: {
                this.unblock();
            }
        }
    }

    protected void setState(State state) {
        this._state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void attainActivation() {
        State finalState = State.ERRORED;
        try {
            this.initialiseHouseKeeping(this._vhostConfig.getHousekeepingCheckPeriod());
            finalState = State.ACTIVE;
            Object var3_2 = null;
            this._state = finalState;
            this.reportIfError(this._state);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._state = finalState;
            this.reportIfError(this._state);
            throw throwable;
        }
    }

    protected void reportIfError(State state) {
        if (state == State.ERRORED) {
            CurrentActor.get().message(VirtualHostMessages.ERRORED());
        }
    }

    private class VirtualHostHouseKeepingTask
    extends HouseKeepingTask {
        public VirtualHostHouseKeepingTask() {
            super(AbstractVirtualHost.this);
        }

        public void execute() {
            for (AMQQueue q : AbstractVirtualHost.this._queueRegistry.getQueues()) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("Checking message status for queue: " + q.getName()));
                }
                try {
                    q.checkMessageStatus();
                }
                catch (Exception e) {
                    _logger.error((Object)("Exception in housekeeping for queue: " + q.getNameShortString().toString()), (Throwable)e);
                }
            }
            for (AMQConnectionModel connection : AbstractVirtualHost.this.getConnectionRegistry().getConnections()) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("Checking for long running open transactions on connection " + connection));
                }
                for (AMQSessionModel session : connection.getSessionModels()) {
                    if (_logger.isDebugEnabled()) {
                        _logger.debug((Object)("Checking for long running open transactions on session " + session));
                    }
                    try {
                        session.checkTransactionStatus(AbstractVirtualHost.this._vhostConfig.getTransactionTimeoutOpenWarn(), AbstractVirtualHost.this._vhostConfig.getTransactionTimeoutOpenClose(), AbstractVirtualHost.this._vhostConfig.getTransactionTimeoutIdleWarn(), AbstractVirtualHost.this._vhostConfig.getTransactionTimeoutIdleClose());
                    }
                    catch (Exception e) {
                        _logger.error((Object)("Exception in housekeeping for connection: " + connection.toString()), (Throwable)e);
                    }
                }
            }
        }
    }
}

