/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhost;

import org.apache.qpid.server.configuration.VirtualHostConfiguration;
import org.apache.qpid.server.logging.subjects.MessageStoreLogSubject;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.security.SecurityManager;
import org.apache.qpid.server.stats.StatisticsGatherer;
import org.apache.qpid.server.store.DurableConfigurationStore;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.MessageStoreCreator;
import org.apache.qpid.server.store.OperationalLoggingListener;
import org.apache.qpid.server.virtualhost.AbstractVirtualHost;
import org.apache.qpid.server.virtualhost.VirtualHostConfigRecoveryHandler;
import org.apache.qpid.server.virtualhost.VirtualHostRegistry;

public class StandardVirtualHost
extends AbstractVirtualHost {
    private MessageStore _messageStore;
    private DurableConfigurationStore _durableConfigurationStore;

    StandardVirtualHost(VirtualHostRegistry virtualHostRegistry, StatisticsGatherer brokerStatisticsGatherer, SecurityManager parentSecurityManager, VirtualHostConfiguration hostConfig, VirtualHost virtualHost) throws Exception {
        super(virtualHostRegistry, brokerStatisticsGatherer, parentSecurityManager, hostConfig, virtualHost);
    }

    private MessageStore initialiseMessageStore(VirtualHostConfiguration hostConfig, VirtualHost virtualHost) throws Exception {
        Object storeTypeAttr = virtualHost.getAttribute("storeType");
        String storeType = storeTypeAttr == null ? null : String.valueOf(storeTypeAttr);
        MessageStore messageStore = null;
        if (storeType == null) {
            Class<?> clazz = Class.forName(hostConfig.getMessageStoreClass());
            Object o = clazz.newInstance();
            if (!(o instanceof MessageStore)) {
                throw new ClassCastException(clazz + " does not implement " + MessageStore.class);
            }
            messageStore = (MessageStore)o;
        } else {
            messageStore = new MessageStoreCreator().createMessageStore(storeType);
        }
        MessageStoreLogSubject storeLogSubject = new MessageStoreLogSubject(this, messageStore.getClass().getSimpleName());
        OperationalLoggingListener.listen(messageStore, storeLogSubject);
        return messageStore;
    }

    private DurableConfigurationStore initialiseConfigurationStore(VirtualHost virtualHost) throws Exception {
        if (!(this.getMessageStore() instanceof DurableConfigurationStore)) {
            throw new ClassCastException(this.getMessageStore().getClass().getSimpleName() + " is not an instance of DurableConfigurationStore");
        }
        DurableConfigurationStore configurationStore = (DurableConfigurationStore)((Object)this.getMessageStore());
        return configurationStore;
    }

    protected void initialiseStorage(VirtualHostConfiguration hostConfig, VirtualHost virtualHost) throws Exception {
        this._messageStore = this.initialiseMessageStore(hostConfig, virtualHost);
        this._durableConfigurationStore = this.initialiseConfigurationStore(virtualHost);
        VirtualHostConfigRecoveryHandler recoveryHandler = new VirtualHostConfigRecoveryHandler(this, this.getExchangeRegistry(), this.getExchangeFactory());
        this._durableConfigurationStore.configureConfigStore(this.getName(), recoveryHandler, virtualHost);
        this._messageStore.configureMessageStore(this.getName(), recoveryHandler, recoveryHandler);
        this.initialiseModel(hostConfig);
        this._messageStore.activate();
        this.attainActivation();
    }

    protected void closeStorage() {
        if (this._messageStore != null) {
            try {
                this.getMessageStore().close();
            }
            catch (Exception e) {
                this.getLogger().error((Object)"Failed to close message store", (Throwable)e);
            }
        }
    }

    public MessageStore getMessageStore() {
        return this._messageStore;
    }

    public DurableConfigurationStore getDurableConfigurationStore() {
        return this._durableConfigurationStore;
    }
}

