/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhost;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.qpid.server.configuration.VirtualHostConfiguration;
import org.apache.qpid.server.model.adapter.VirtualHostAdapter;
import org.apache.qpid.server.plugin.MessageStoreFactory;
import org.apache.qpid.server.plugin.VirtualHostFactory;
import org.apache.qpid.server.security.SecurityManager;
import org.apache.qpid.server.stats.StatisticsGatherer;
import org.apache.qpid.server.store.MessageStoreCreator;
import org.apache.qpid.server.virtualhost.StandardVirtualHost;
import org.apache.qpid.server.virtualhost.VirtualHost;
import org.apache.qpid.server.virtualhost.VirtualHostRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardVirtualHostFactory
implements VirtualHostFactory {
    public static final String TYPE = "STANDARD";
    public static final String STORE_TYPE_ATTRIBUTE = "storeType";
    public static final String STORE_PATH_ATTRIBUTE = "storePath";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public VirtualHost createVirtualHost(VirtualHostRegistry virtualHostRegistry, StatisticsGatherer brokerStatisticsGatherer, SecurityManager parentSecurityManager, VirtualHostConfiguration hostConfig, org.apache.qpid.server.model.VirtualHost virtualHost) throws Exception {
        return new StandardVirtualHost(virtualHostRegistry, brokerStatisticsGatherer, parentSecurityManager, hostConfig, virtualHost);
    }

    @Override
    public void validateAttributes(Map<String, Object> attributes) {
        Object storeType = attributes.get(STORE_TYPE_ATTRIBUTE);
        if (!(storeType instanceof String)) {
            throw new IllegalArgumentException("Attribute 'storeType' is required and must be of type String.");
        }
        MessageStoreCreator storeCreator = new MessageStoreCreator();
        if (!storeCreator.isValidType((String)storeType)) {
            throw new IllegalArgumentException("Attribute 'storeType' has value '" + storeType + "' which is not one of the valid values: " + storeCreator.getStoreTypes() + ".");
        }
        for (MessageStoreFactory factory : storeCreator.getFactories()) {
            if (!factory.getType().equalsIgnoreCase((String)storeType)) continue;
            factory.validateAttributes(attributes);
        }
    }

    @Override
    public Map<String, Object> createVirtualHostConfiguration(VirtualHostAdapter virtualHostAdapter) {
        LinkedHashMap<String, Object> convertedMap = new LinkedHashMap<String, Object>();
        convertedMap.put("store.type", virtualHostAdapter.getAttribute(STORE_TYPE_ATTRIBUTE));
        convertedMap.put("store.environment-path", virtualHostAdapter.getAttribute(STORE_PATH_ATTRIBUTE));
        return convertedMap;
    }

    @Override
    public Map<String, Object> convertVirtualHostConfiguration(Configuration configuration) {
        LinkedHashMap<String, Object> convertedMap = new LinkedHashMap<String, Object>();
        Configuration storeConfiguration = configuration.subset("store");
        convertedMap.put(STORE_TYPE_ATTRIBUTE, storeConfiguration.getString("type"));
        convertedMap.put(STORE_PATH_ATTRIBUTE, storeConfiguration.getString("environment-path"));
        convertedMap.put("storeOverfullSize", storeConfiguration.getString("overfull-size"));
        convertedMap.put("storeUnderfullSize", storeConfiguration.getString("underfull-size"));
        for (MessageStoreFactory mf : new MessageStoreCreator().getFactories()) {
            convertedMap.putAll(mf.convertStoreConfiguration(storeConfiguration));
        }
        return convertedMap;
    }
}

