/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhost;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.apache.qpid.server.plugin.VirtualHostFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualHostFactoryRegistry {
    private static Map<String, VirtualHostFactory> getFactoryMap() {
        HashMap<String, VirtualHostFactory> virtualHostFactories = new HashMap<String, VirtualHostFactory>();
        QpidServiceLoader<VirtualHostFactory> qpidServiceLoader = new QpidServiceLoader<VirtualHostFactory>();
        Iterable<VirtualHostFactory> factories = qpidServiceLoader.atLeastOneInstanceOf(VirtualHostFactory.class);
        for (VirtualHostFactory virtualHostFactory : factories) {
            String type = virtualHostFactory.getType();
            VirtualHostFactory factory = virtualHostFactories.put(type, virtualHostFactory);
            if (factory == null) continue;
            throw new IllegalStateException("VirtualHostFactory with type name '" + type + "' is already registered using class '" + factory.getClass().getName() + "', can not register class '" + virtualHostFactory.getClass().getName() + "'");
        }
        return virtualHostFactories;
    }

    public static Collection<VirtualHostFactory> getFactories() {
        return Collections.unmodifiableCollection(VirtualHostFactoryRegistry.getFactoryMap().values());
    }

    public static Collection<String> getVirtualHostTypes() {
        return Collections.unmodifiableCollection(VirtualHostFactoryRegistry.getFactoryMap().keySet());
    }

    public static VirtualHostFactory getFactory(String type) {
        return VirtualHostFactoryRegistry.getFactoryMap().get(type);
    }
}

