/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.state;

import java.util.Set;
import org.apache.qpid.AMQException;
import org.apache.qpid.client.state.AMQState;
import org.apache.qpid.client.state.AMQStateManager;
import org.apache.qpid.client.util.BlockingWaiter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateWaiter
extends BlockingWaiter<AMQState> {
    private static final Logger _logger = LoggerFactory.getLogger(StateWaiter.class);
    Set<AMQState> _awaitStates;
    private AMQState _startState;
    private AMQStateManager _stateManager;

    public StateWaiter(AMQStateManager stateManager, AMQState currentState, Set<AMQState> awaitStates) {
        _logger.info("New StateWaiter :" + (Object)((Object)currentState) + ":" + awaitStates);
        this._stateManager = stateManager;
        this._awaitStates = awaitStates;
        this._startState = currentState;
    }

    @Override
    public boolean process(AMQState state) {
        return this._awaitStates.contains((Object)state);
    }

    public AMQState await() throws AMQException {
        return this.await(this._stateManager.getWaitTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AMQState await(long timeout) throws AMQException {
        try {
            if (this.process(this._startState)) {
                AMQState aMQState = this._startState;
                return aMQState;
            }
            AMQState aMQState = (AMQState)((Object)this.block(timeout));
            return aMQState;
        }
        finally {
            this.close();
            this._stateManager.removeWaiter(this);
        }
    }
}

