/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio;

import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import java.io.IOException;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Set;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.ExceptionMonitor;
import org.apache.mina.common.IoConnectorConfig;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoService;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.support.BaseIoConnector;
import org.apache.mina.common.support.DefaultConnectFuture;
import org.apache.mina.transport.socket.nio.SocketConnectorConfig;
import org.apache.mina.transport.socket.nio.SocketIoProcessor;
import org.apache.mina.transport.socket.nio.SocketSessionImpl;
import org.apache.mina.util.NamePreservingRunnable;
import org.apache.mina.util.NewThreadExecutor;
import org.apache.mina.util.Queue;

public class ExistingSocketConnector
extends BaseIoConnector {
    private static volatile int nextId = 0;
    private final Object lock = new Object();
    private final int id = nextId++;
    private final String threadName = "SocketConnector-" + this.id;
    private SocketConnectorConfig defaultConfig = new SocketConnectorConfig();
    private final Queue connectQueue = new Queue();
    private final SocketIoProcessor[] ioProcessors;
    private final int processorCount;
    private final Executor executor;
    private Selector selector;
    private Worker worker;
    private int processorDistributor = 0;
    private int workerTimeout = 60;
    private Socket _openSocket = null;

    public ExistingSocketConnector() {
        this(1, (Executor)new NewThreadExecutor());
    }

    public ExistingSocketConnector(int processorCount, Executor executor) {
        if (processorCount < 1) {
            throw new IllegalArgumentException("Must have at least one processor");
        }
        this.executor = executor;
        this.processorCount = processorCount;
        this.ioProcessors = new SocketIoProcessor[processorCount];
        for (int i = 0; i < processorCount; ++i) {
            this.ioProcessors[i] = new SocketIoProcessor("SocketConnectorIoProcessor-" + this.id + "." + i, executor);
        }
    }

    public int getWorkerTimeout() {
        return this.workerTimeout;
    }

    public void setWorkerTimeout(int workerTimeout) {
        if (workerTimeout < 0) {
            throw new IllegalArgumentException("Must be >= 0");
        }
        this.workerTimeout = workerTimeout;
    }

    public ConnectFuture connect(SocketAddress address, IoHandler handler, IoServiceConfig config) {
        return this.connect(address, null, handler, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectFuture connect(SocketAddress address, SocketAddress localAddress, IoHandler handler, IoServiceConfig config) {
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        if (config == null) {
            config = this.getDefaultConfig();
        }
        if (this._openSocket == null) {
            throw new IllegalArgumentException("Specifed Socket not active");
        }
        boolean success = false;
        try {
            DefaultConnectFuture future = new DefaultConnectFuture();
            this.newSession(this._openSocket, handler, config, (ConnectFuture)future);
            success = true;
            DefaultConnectFuture defaultConnectFuture = future;
            return defaultConnectFuture;
        }
        catch (IOException e) {
            ConnectFuture connectFuture = DefaultConnectFuture.newFailedFuture((Throwable)e);
            return connectFuture;
        }
        finally {
            if (!success && this._openSocket != null) {
                try {
                    this._openSocket.close();
                }
                catch (IOException e) {
                    ExceptionMonitor.getInstance().exceptionCaught((Throwable)e);
                }
            }
        }
    }

    public IoServiceConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public void setDefaultConfig(SocketConnectorConfig defaultConfig) {
        if (defaultConfig == null) {
            throw new NullPointerException("defaultConfig");
        }
        this.defaultConfig = defaultConfig;
    }

    private synchronized void startupWorker() throws IOException {
        if (this.worker == null) {
            this.selector = Selector.open();
            this.worker = new Worker();
            this.executor.execute((Runnable)new NamePreservingRunnable((Runnable)this.worker));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerNew() {
        if (this.connectQueue.isEmpty()) {
            return;
        }
        while (true) {
            ConnectionRequest req;
            Queue queue = this.connectQueue;
            synchronized (queue) {
                req = (ConnectionRequest)((Object)this.connectQueue.pop());
            }
            if (req == null) break;
            SocketChannel ch = req.channel;
            try {
                ch.register(this.selector, 8, (Object)req);
            }
            catch (IOException e) {
                req.setException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSessions(Set keys) {
        for (SelectionKey key : keys) {
            if (!key.isConnectable()) continue;
            SocketChannel ch = (SocketChannel)key.channel();
            ConnectionRequest entry = (ConnectionRequest)((Object)key.attachment());
            boolean success = false;
            try {
                ch.finishConnect();
                this.newSession(ch, entry.handler, entry.config, (ConnectFuture)entry);
                success = true;
            }
            catch (Throwable e) {
                entry.setException(e);
            }
            finally {
                key.cancel();
                if (success) continue;
                try {
                    ch.close();
                }
                catch (IOException e) {
                    ExceptionMonitor.getInstance().exceptionCaught((Throwable)e);
                }
            }
        }
        keys.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTimedOutSessions(Set keys) {
        long currentTime = System.currentTimeMillis();
        for (SelectionKey key : keys) {
            ConnectionRequest entry;
            if (!key.isValid() || currentTime < (entry = (ConnectionRequest)((Object)key.attachment())).deadline) continue;
            entry.setException(new ConnectException());
            try {
                key.channel().close();
            }
            catch (IOException e) {
                ExceptionMonitor.getInstance().exceptionCaught((Throwable)e);
            }
            finally {
                key.cancel();
            }
        }
    }

    private void newSession(Socket socket, IoHandler handler, IoServiceConfig config, ConnectFuture connectFuture) throws IOException {
        SocketSessionImpl session = new SocketSessionImpl((IoService)this, this.nextProcessor(), this.getListeners(), config, socket.getChannel(), handler, socket.getRemoteSocketAddress());
        this.newSession(session, config, connectFuture);
    }

    private void newSession(SocketChannel ch, IoHandler handler, IoServiceConfig config, ConnectFuture connectFuture) throws IOException {
        SocketSessionImpl session = new SocketSessionImpl((IoService)this, this.nextProcessor(), this.getListeners(), config, ch, handler, ch.socket().getRemoteSocketAddress());
        this.newSession(session, config, connectFuture);
    }

    private void newSession(SocketSessionImpl session, IoServiceConfig config, ConnectFuture connectFuture) throws IOException {
        try {
            this.getFilterChainBuilder().buildFilterChain(session.getFilterChain());
            config.getFilterChainBuilder().buildFilterChain(session.getFilterChain());
            config.getThreadModel().buildFilterChain(session.getFilterChain());
        }
        catch (Throwable e) {
            throw (IOException)new IOException("Failed to create a session.").initCause(e);
        }
        session.getIoProcessor().addNew(session);
        connectFuture.setSession((IoSession)session);
    }

    private SocketIoProcessor nextProcessor() {
        return this.ioProcessors[this.processorDistributor++ % this.processorCount];
    }

    public void setOpenSocket(Socket openSocket) {
        this._openSocket = openSocket;
    }

    private class ConnectionRequest
    extends DefaultConnectFuture {
        private final SocketChannel channel;
        private final long deadline;
        private final IoHandler handler;
        private final IoServiceConfig config;

        private ConnectionRequest(SocketChannel channel, IoHandler handler, IoServiceConfig config) {
            this.channel = channel;
            long timeout = config instanceof IoConnectorConfig ? ((IoConnectorConfig)config).getConnectTimeoutMillis() : ((IoConnectorConfig)ExistingSocketConnector.this.getDefaultConfig()).getConnectTimeoutMillis();
            this.deadline = System.currentTimeMillis() + timeout;
            this.handler = handler;
            this.config = config;
        }
    }

    private class Worker
    implements Runnable {
        private long lastActive = System.currentTimeMillis();

        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Thread.currentThread().setName(ExistingSocketConnector.this.threadName);
            block12: while (true) {
                try {
                    while (true) {
                        int nKeys = ExistingSocketConnector.this.selector.select(1000L);
                        ExistingSocketConnector.this.registerNew();
                        if (nKeys > 0) {
                            ExistingSocketConnector.this.processSessions(ExistingSocketConnector.this.selector.selectedKeys());
                        }
                        ExistingSocketConnector.this.processTimedOutSessions(ExistingSocketConnector.this.selector.keys());
                        if (ExistingSocketConnector.this.selector.keys().isEmpty()) {
                            if (System.currentTimeMillis() - this.lastActive <= (long)ExistingSocketConnector.this.workerTimeout * 1000L) continue;
                            Object object = ExistingSocketConnector.this.lock;
                            synchronized (object) {
                                if (ExistingSocketConnector.this.selector.keys().isEmpty() && ExistingSocketConnector.this.connectQueue.isEmpty()) {
                                    ExistingSocketConnector.this.worker = null;
                                    try {
                                        ExistingSocketConnector.this.selector.close();
                                    }
                                    catch (IOException e) {
                                        ExceptionMonitor.getInstance().exceptionCaught((Throwable)e);
                                    }
                                    finally {
                                        ExistingSocketConnector.this.selector = null;
                                    }
                                    break block12;
                                }
                                continue block12;
                            }
                        }
                        this.lastActive = System.currentTimeMillis();
                    }
                }
                catch (IOException e) {
                    ExceptionMonitor.getInstance().exceptionCaught((Throwable)e);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        ExceptionMonitor.getInstance().exceptionCaught((Throwable)e1);
                    }
                    continue;
                }
                break;
            }
        }
    }
}

