/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import java.nio.ByteBuffer;
import java.util.UUID;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.Topic;
import org.apache.qpid.AMQException;
import org.apache.qpid.client.AMQConnection;
import org.apache.qpid.client.AMQDestination;
import org.apache.qpid.client.AMQSession;
import org.apache.qpid.client.BasicMessageProducer;
import org.apache.qpid.client.CustomJMSXProperty;
import org.apache.qpid.client.message.AMQMessageDelegate_0_8;
import org.apache.qpid.client.message.AbstractJMSMessage;
import org.apache.qpid.client.protocol.AMQProtocolHandler;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.AMQFrame;
import org.apache.qpid.framing.BasicContentHeaderProperties;
import org.apache.qpid.framing.BasicPublishBody;
import org.apache.qpid.framing.CompositeAMQDataBlock;
import org.apache.qpid.framing.ContentBody;
import org.apache.qpid.framing.ContentHeaderBody;
import org.apache.qpid.framing.ExchangeDeclareBody;

public class BasicMessageProducer_0_8
extends BasicMessageProducer {
    BasicMessageProducer_0_8(AMQConnection connection, AMQDestination destination, boolean transacted, int channelId, AMQSession session, AMQProtocolHandler protocolHandler, long producerId, boolean immediate, boolean mandatory) throws AMQException {
        super(connection, destination, transacted, channelId, session, protocolHandler, producerId, immediate, mandatory);
    }

    void declareDestination(AMQDestination destination) {
        ExchangeDeclareBody body = this.getSession().getMethodRegistry().createExchangeDeclareBody(this._session.getTicket(), destination.getExchangeName(), destination.getExchangeClass(), false, false, false, false, true, null);
        AMQFrame declare = body.generateFrame(this._channelId);
        this._protocolHandler.writeFrame((AMQDataBlock)declare);
    }

    void sendMessage(AMQDestination destination, Message origMessage, AbstractJMSMessage message, UUID messageId, int deliveryMode, int priority, long timeToLive, boolean mandatory, boolean immediate) throws JMSException {
        BasicPublishBody body = this.getSession().getMethodRegistry().createBasicPublishBody(this._session.getTicket(), destination.getExchangeName(), destination.getRoutingKey(), mandatory, immediate);
        AMQFrame publishFrame = body.generateFrame(this._channelId);
        message.prepareForSending();
        ByteBuffer payload = message.getData();
        AMQMessageDelegate_0_8 delegate = (AMQMessageDelegate_0_8)message.getDelegate();
        BasicContentHeaderProperties contentHeaderProperties = delegate.getContentHeaderProperties();
        contentHeaderProperties.setUserId(this._userID);
        int type = destination instanceof Topic ? 2 : (destination instanceof Queue ? 1 : 3);
        delegate.getContentHeaderProperties().getHeaders().setInteger(CustomJMSXProperty.JMS_QPID_DESTTYPE.getShortStringName(), Integer.valueOf(type));
        if (!this._disableTimestamps) {
            long currentTime = System.currentTimeMillis();
            contentHeaderProperties.setTimestamp(currentTime);
            if (timeToLive > 0L) {
                contentHeaderProperties.setExpiration(currentTime + timeToLive);
            } else {
                contentHeaderProperties.setExpiration(0L);
            }
        }
        contentHeaderProperties.setDeliveryMode((byte)deliveryMode);
        contentHeaderProperties.setPriority((byte)priority);
        int size = payload != null ? payload.limit() : 0;
        int contentBodyFrameCount = this.calculateContentBodyFrameCount(payload);
        AMQFrame[] frames = new AMQFrame[2 + contentBodyFrameCount];
        if (payload != null) {
            this.createContentBodies(payload, frames, 2, this._channelId);
        }
        if (contentBodyFrameCount != 0 && this._logger.isDebugEnabled()) {
            this._logger.debug("Sending content body frames to " + destination);
        }
        int classIfForBasic = this.getSession().getMethodRegistry().createBasicQosOkBody().getClazz();
        AMQFrame contentHeaderFrame = ContentHeaderBody.createAMQFrame((int)this._channelId, (int)classIfForBasic, (int)0, (BasicContentHeaderProperties)contentHeaderProperties, (long)size);
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Sending content header frame to " + destination);
        }
        frames[0] = publishFrame;
        frames[1] = contentHeaderFrame;
        CompositeAMQDataBlock compositeFrame = new CompositeAMQDataBlock((AMQDataBlock[])frames);
        try {
            this._session.checkFlowControl();
        }
        catch (InterruptedException e) {
            JMSException jmse = new JMSException("Interrupted while waiting for flow control to be removed");
            jmse.setLinkedException((Exception)e);
            jmse.initCause((Throwable)e);
            throw jmse;
        }
        this._protocolHandler.writeFrame((AMQDataBlock)compositeFrame);
    }

    private void createContentBodies(ByteBuffer payload, AMQFrame[] frames, int offset, int channelId) {
        if (frames.length == offset + 1) {
            byte[] data = new byte[payload.remaining()];
            payload.get(data);
            frames[offset] = ContentBody.createAMQFrame((int)channelId, (ContentBody)new ContentBody(data));
        } else {
            long framePayloadMax = this._session.getAMQConnection().getMaximumFrameSize() - 1L;
            long remaining = payload.remaining();
            for (int i = offset; i < frames.length; ++i) {
                payload.position((int)framePayloadMax * (i - offset));
                int length = remaining >= framePayloadMax ? (int)framePayloadMax : (int)remaining;
                payload.limit(payload.position() + length);
                byte[] data = new byte[payload.remaining()];
                payload.get(data);
                frames[i] = ContentBody.createAMQFrame((int)channelId, (ContentBody)new ContentBody(data));
                remaining -= (long)length;
            }
        }
    }

    private int calculateContentBodyFrameCount(ByteBuffer payload) {
        int frameCount;
        if (payload == null || payload.remaining() == 0) {
            frameCount = 0;
        } else {
            long framePayloadMax;
            int dataLength = payload.remaining();
            int lastFrame = (long)dataLength % (framePayloadMax = this._session.getAMQConnection().getMaximumFrameSize() - 1L) > 0L ? 1 : 0;
            frameCount = (int)((long)dataLength / framePayloadMax) + lastFrame;
        }
        return frameCount;
    }
}

