/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import org.apache.qpid.client.AMQDestination;
import org.apache.qpid.client.AMQSession;
import org.apache.qpid.client.BasicMessageProducer;

public class TopicPublisherAdapter
implements TopicPublisher {
    private BasicMessageProducer _delegate;
    private Topic _topic;

    public TopicPublisherAdapter(BasicMessageProducer msgProducer, Topic topic) {
        this._delegate = msgProducer;
        this._topic = topic;
    }

    public Topic getTopic() throws JMSException {
        this.checkPreConditions();
        return this._topic;
    }

    public void publish(Message msg) throws JMSException {
        this.checkPreConditions();
        this.checkTopic((Destination)this._topic);
        this._delegate.send(msg);
    }

    public void publish(Topic topic, Message msg) throws JMSException {
        this.checkPreConditions();
        this.checkTopic((Destination)topic);
        this._delegate.send((Destination)topic, msg);
    }

    public void publish(Message msg, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkPreConditions();
        this.checkTopic((Destination)this._topic);
        this._delegate.send(msg, deliveryMode, priority, timeToLive);
    }

    public int getDeliveryMode() throws JMSException {
        this.checkPreConditions();
        return this._delegate.getDeliveryMode();
    }

    public void publish(Topic topic, Message msg, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkPreConditions();
        this.checkTopic((Destination)topic);
        this._delegate.send((Destination)topic, msg, deliveryMode, priority, timeToLive);
    }

    public void close() throws JMSException {
        this._delegate.close();
    }

    public boolean getDisableMessageID() throws JMSException {
        this.checkPreConditions();
        return this._delegate.getDisableMessageID();
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        this.checkPreConditions();
        return this._delegate.getDisableMessageTimestamp();
    }

    public Destination getDestination() throws JMSException {
        this.checkPreConditions();
        return this._delegate.getDestination();
    }

    public int getPriority() throws JMSException {
        this.checkPreConditions();
        return this._delegate.getPriority();
    }

    public long getTimeToLive() throws JMSException {
        this.checkPreConditions();
        return this._delegate.getTimeToLive();
    }

    public void send(Message msg) throws JMSException {
        this.checkPreConditions();
        this.checkTopic((Destination)this._topic);
        this._delegate.send(msg);
    }

    public void send(Destination dest, Message msg) throws JMSException {
        this.checkPreConditions();
        this.checkTopic((Destination)this._topic);
        this._delegate.send(dest, msg);
    }

    public void send(Message msg, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkPreConditions();
        this.checkTopic((Destination)this._topic);
        this._delegate.send(msg, deliveryMode, priority, timeToLive);
    }

    public void send(Destination dest, Message msg, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkPreConditions();
        this.checkTopic(dest);
        this._delegate.send(dest, msg, deliveryMode, priority, timeToLive);
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.checkPreConditions();
        this._delegate.setDeliveryMode(deliveryMode);
    }

    public void setDisableMessageID(boolean disableMessageID) throws JMSException {
        this.checkPreConditions();
        this._delegate.setDisableMessageID(disableMessageID);
    }

    public void setDisableMessageTimestamp(boolean disableMessageTimestamp) throws JMSException {
        this.checkPreConditions();
        this._delegate.setDisableMessageTimestamp(disableMessageTimestamp);
    }

    public void setPriority(int priority) throws JMSException {
        this.checkPreConditions();
        this._delegate.setPriority(priority);
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        this.checkPreConditions();
        this._delegate.setTimeToLive(timeToLive);
    }

    private void checkPreConditions() throws IllegalStateException {
        if (this._delegate.isClosed()) {
            throw new IllegalStateException("Publisher is _closed");
        }
        AMQSession session = this._delegate.getSession();
        if (session == null || session.isClosed()) {
            throw new IllegalStateException("Invalid Session");
        }
    }

    private void checkTopic(Destination topic) throws InvalidDestinationException {
        if (topic == null) {
            throw new UnsupportedOperationException("Topic is null");
        }
        if (!(topic instanceof Topic)) {
            throw new InvalidDestinationException("Destination " + topic + " is not a topic");
        }
        if (!(topic instanceof AMQDestination)) {
            throw new InvalidDestinationException("Destination " + topic + " is not a Qpid topic");
        }
    }
}

