/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.message;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import org.apache.qpid.client.AMQAnyDestination;
import org.apache.qpid.client.AMQDestination;
import org.apache.qpid.client.AMQQueue;
import org.apache.qpid.client.AMQSession;
import org.apache.qpid.client.AMQTopic;
import org.apache.qpid.client.message.AMQMessageDelegate;
import org.apache.qpid.client.message.ExchangeInfo;
import org.apache.qpid.exchange.ExchangeDefaults;
import org.apache.qpid.framing.AMQShortString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAMQMessageDelegate
implements AMQMessageDelegate {
    private static Map<String, Integer> _exchangeTypeToDestinationType = new ConcurrentHashMap<String, Integer>();
    private static Map<String, ExchangeInfo> _exchangeMap = new ConcurrentHashMap<String, ExchangeInfo>();
    private AMQSession<?, ?> _session;
    private final long _deliveryTag;

    protected AbstractAMQMessageDelegate(long deliveryTag) {
        this._deliveryTag = deliveryTag;
    }

    @Override
    public long getDeliveryTag() {
        return this._deliveryTag;
    }

    protected AMQDestination generateDestination(AMQShortString exchange, AMQShortString routingKey) {
        ExchangeInfo exchangeInfo = _exchangeMap.get(exchange.asString());
        if (exchangeInfo == null) {
            exchangeInfo = new ExchangeInfo(exchange.asString(), "", 3);
        }
        AMQDestination dest = "topic".equals(exchangeInfo.exchangeType) ? new AMQTopic(exchange, routingKey, null) : ("direct".equals(exchangeInfo.exchangeType) ? new AMQQueue(exchange, routingKey, routingKey) : new AMQAnyDestination(exchange, new AMQShortString(exchangeInfo.exchangeType), routingKey, false, false, routingKey, false, new AMQShortString[]{routingKey}));
        return dest;
    }

    protected static void updateExchangeType(String exchange, String newtype) {
        Integer type = _exchangeTypeToDestinationType.get(newtype);
        if (type == null) {
            type = 3;
        }
        _exchangeMap.put(exchange, new ExchangeInfo(exchange, newtype, type));
    }

    protected static boolean exchangeMapContains(String exchange) {
        return _exchangeMap.containsKey(exchange);
    }

    @Override
    public void acknowledgeThis() throws JMSException {
        if (this._session != null && this._session.getAcknowledgeMode() == 2) {
            if (this._session.getAMQConnection().isClosed()) {
                throw new IllegalStateException("Connection is already closed");
            }
            this._session.acknowledgeMessage(this.getDeliveryTag(), true);
        }
    }

    @Override
    public void acknowledge() throws JMSException {
        if (this._session != null && this._session.getAcknowledgeMode() == 2) {
            this._session.acknowledge();
        }
    }

    @Override
    public void setAMQSession(AMQSession<?, ?> s) {
        this._session = s;
    }

    @Override
    public AMQSession<?, ?> getAMQSession() {
        return this._session;
    }

    static {
        _exchangeTypeToDestinationType.put("", 1);
        _exchangeTypeToDestinationType.put(ExchangeDefaults.DIRECT_EXCHANGE_CLASS.toString(), 1);
        _exchangeTypeToDestinationType.put(ExchangeDefaults.TOPIC_EXCHANGE_CLASS.toString(), 2);
        _exchangeTypeToDestinationType.put(ExchangeDefaults.FANOUT_EXCHANGE_CLASS.toString(), 2);
        _exchangeTypeToDestinationType.put(ExchangeDefaults.HEADERS_EXCHANGE_CLASS.toString(), 1);
        _exchangeMap.put("", new ExchangeInfo("", "", 1));
        _exchangeMap.put(ExchangeDefaults.DIRECT_EXCHANGE_NAME.toString(), new ExchangeInfo(ExchangeDefaults.DIRECT_EXCHANGE_NAME.toString(), ExchangeDefaults.DIRECT_EXCHANGE_CLASS.toString(), 1));
        _exchangeMap.put(ExchangeDefaults.TOPIC_EXCHANGE_NAME.toString(), new ExchangeInfo(ExchangeDefaults.TOPIC_EXCHANGE_NAME.toString(), ExchangeDefaults.TOPIC_EXCHANGE_CLASS.toString(), 2));
        _exchangeMap.put(ExchangeDefaults.FANOUT_EXCHANGE_NAME.toString(), new ExchangeInfo(ExchangeDefaults.FANOUT_EXCHANGE_NAME.toString(), ExchangeDefaults.FANOUT_EXCHANGE_CLASS.toString(), 2));
        _exchangeMap.put(ExchangeDefaults.HEADERS_EXCHANGE_NAME.toString(), new ExchangeInfo(ExchangeDefaults.HEADERS_EXCHANGE_NAME.toString(), ExchangeDefaults.HEADERS_EXCHANGE_CLASS.toString(), 1));
    }
}

