/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.message;

import java.nio.ByteBuffer;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import org.apache.qpid.AMQException;
import org.apache.qpid.client.message.AMQMessageDelegate;
import org.apache.qpid.client.message.AMQMessageDelegateFactory;
import org.apache.qpid.client.message.AbstractBytesTypedMessage;
import org.apache.qpid.client.message.TypedBytesContentReader;
import org.apache.qpid.client.message.TypedBytesContentWriter;

public class JMSBytesMessage
extends AbstractBytesTypedMessage
implements BytesMessage {
    public static final String MIME_TYPE = "application/octet-stream";
    private TypedBytesContentReader _typedBytesContentReader;
    private TypedBytesContentWriter _typedBytesContentWriter;

    public JMSBytesMessage(AMQMessageDelegateFactory delegateFactory) {
        super(delegateFactory, false);
        this._typedBytesContentWriter = new TypedBytesContentWriter();
    }

    JMSBytesMessage(AMQMessageDelegate delegate, ByteBuffer data) throws AMQException {
        super(delegate, data != null);
        this._typedBytesContentReader = new TypedBytesContentReader(data);
    }

    public void reset() {
        this._readableMessage = true;
        if (this._typedBytesContentReader != null) {
            this._typedBytesContentReader.reset();
        } else if (this._typedBytesContentWriter != null) {
            this._typedBytesContentReader = new TypedBytesContentReader(this._typedBytesContentWriter.getData());
        }
    }

    public void clearBody() throws JMSException {
        super.clearBody();
        this._typedBytesContentReader = null;
        this._typedBytesContentWriter = new TypedBytesContentWriter();
    }

    protected String getMimeType() {
        return MIME_TYPE;
    }

    public ByteBuffer getData() throws JMSException {
        return this._typedBytesContentWriter == null ? this._typedBytesContentReader.getData() : this._typedBytesContentWriter.getData();
    }

    public long getBodyLength() throws JMSException {
        this.checkReadable();
        return this._typedBytesContentReader.size();
    }

    public boolean readBoolean() throws JMSException {
        this.checkReadable();
        this.checkAvailable(1);
        return this._typedBytesContentReader.readBooleanImpl();
    }

    private void checkAvailable(int i) throws MessageEOFException {
        this._typedBytesContentReader.checkAvailable(1);
    }

    public byte readByte() throws JMSException {
        this.checkReadable();
        this.checkAvailable(1);
        return this._typedBytesContentReader.readByteImpl();
    }

    public int readUnsignedByte() throws JMSException {
        this.checkReadable();
        this.checkAvailable(1);
        return this._typedBytesContentReader.readByteImpl() & 0xFF;
    }

    public short readShort() throws JMSException {
        this.checkReadable();
        this.checkAvailable(2);
        return this._typedBytesContentReader.readShortImpl();
    }

    public int readUnsignedShort() throws JMSException {
        this.checkReadable();
        this.checkAvailable(2);
        return this._typedBytesContentReader.readShortImpl() & 0xFFFF;
    }

    public char readChar() throws JMSException {
        this.checkReadable();
        this.checkAvailable(2);
        return this._typedBytesContentReader.readCharImpl();
    }

    public int readInt() throws JMSException {
        this.checkReadable();
        this.checkAvailable(4);
        return this._typedBytesContentReader.readIntImpl();
    }

    public long readLong() throws JMSException {
        this.checkReadable();
        this.checkAvailable(8);
        return this._typedBytesContentReader.readLongImpl();
    }

    public float readFloat() throws JMSException {
        this.checkReadable();
        this.checkAvailable(4);
        return this._typedBytesContentReader.readFloatImpl();
    }

    public double readDouble() throws JMSException {
        this.checkReadable();
        this.checkAvailable(8);
        return this._typedBytesContentReader.readDoubleImpl();
    }

    public String readUTF() throws JMSException {
        this.checkReadable();
        return this._typedBytesContentReader.readLengthPrefixedUTF();
    }

    public int readBytes(byte[] bytes) throws JMSException {
        int count;
        if (bytes == null) {
            throw new IllegalArgumentException("byte array must not be null");
        }
        this.checkReadable();
        int n = count = this._typedBytesContentReader.remaining() >= bytes.length ? bytes.length : this._typedBytesContentReader.remaining();
        if (count == 0) {
            return -1;
        }
        this._typedBytesContentReader.readRawBytes(bytes, 0, count);
        return count;
    }

    public int readBytes(byte[] bytes, int maxLength) throws JMSException {
        int count;
        if (bytes == null) {
            throw new IllegalArgumentException("byte array must not be null");
        }
        if (maxLength > bytes.length) {
            throw new IllegalArgumentException("maxLength must be <= bytes.length");
        }
        this.checkReadable();
        int n = count = this._typedBytesContentReader.remaining() >= maxLength ? maxLength : this._typedBytesContentReader.remaining();
        if (count == 0) {
            return -1;
        }
        this._typedBytesContentReader.readRawBytes(bytes, 0, count);
        return count;
    }

    public void writeBoolean(boolean b) throws JMSException {
        this.checkWritable();
        this._typedBytesContentWriter.writeBooleanImpl(b);
    }

    public void writeByte(byte b) throws JMSException {
        this.checkWritable();
        this._typedBytesContentWriter.writeByteImpl(b);
    }

    public void writeShort(short i) throws JMSException {
        this.checkWritable();
        this._typedBytesContentWriter.writeShortImpl(i);
    }

    public void writeChar(char c) throws JMSException {
        this.checkWritable();
        this._typedBytesContentWriter.writeCharImpl(c);
    }

    public void writeInt(int i) throws JMSException {
        this.checkWritable();
        this._typedBytesContentWriter.writeIntImpl(i);
    }

    public void writeLong(long l) throws JMSException {
        this.checkWritable();
        this._typedBytesContentWriter.writeLongImpl(l);
    }

    public void writeFloat(float v) throws JMSException {
        this.checkWritable();
        this._typedBytesContentWriter.writeFloatImpl(v);
    }

    public void writeDouble(double v) throws JMSException {
        this.checkWritable();
        this._typedBytesContentWriter.writeDoubleImpl(v);
    }

    public void writeUTF(String string) throws JMSException {
        this.checkWritable();
        this._typedBytesContentWriter.writeLengthPrefixedUTF(string);
    }

    public void writeBytes(byte[] bytes) throws JMSException {
        this.writeBytes(bytes, 0, bytes.length);
    }

    public void writeBytes(byte[] bytes, int offset, int length) throws JMSException {
        this.checkWritable();
        this._typedBytesContentWriter.writeBytesRaw(bytes, offset, length);
    }

    public void writeObject(Object object) throws JMSException {
        this.checkWritable();
        if (object == null) {
            throw new NullPointerException("Argument must not be null");
        }
        Class<?> clazz = object.getClass();
        if (clazz == Byte.class) {
            this.writeByte((Byte)object);
        } else if (clazz == Boolean.class) {
            this.writeBoolean((Boolean)object);
        } else if (clazz == byte[].class) {
            this.writeBytes((byte[])object);
        } else if (clazz == Short.class) {
            this.writeShort((Short)object);
        } else if (clazz == Character.class) {
            this.writeChar(((Character)object).charValue());
        } else if (clazz == Integer.class) {
            this.writeInt((Integer)object);
        } else if (clazz == Long.class) {
            this.writeLong((Long)object);
        } else if (clazz == Float.class) {
            this.writeFloat(((Float)object).floatValue());
        } else if (clazz == Double.class) {
            this.writeDouble((Double)object);
        } else if (clazz == String.class) {
            this.writeUTF((String)object);
        } else {
            throw new MessageFormatException("Only primitives plus byte arrays and String are valid types");
        }
    }
}

