/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.message;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import org.apache.qpid.AMQPInvalidClassException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.FieldTable;

public final class JMSHeaderAdapter {
    private final FieldTable _headers;

    public JMSHeaderAdapter(FieldTable headers) {
        this._headers = headers;
    }

    public FieldTable getHeaders() {
        return this._headers;
    }

    public boolean getBoolean(String string) throws JMSException {
        this.checkPropertyName(string);
        Boolean b = this.getHeaders().getBoolean(string);
        if (b == null) {
            if (this.getHeaders().containsKey(string)) {
                Object str = this.getHeaders().getObject(string);
                if (str == null || !(str instanceof String)) {
                    throw new MessageFormatException("getBoolean can't use " + string + " item.");
                }
                return Boolean.valueOf((String)str);
            }
            b = Boolean.valueOf(null);
        }
        return b;
    }

    public boolean getBoolean(AMQShortString string) throws JMSException {
        this.checkPropertyName((CharSequence)string);
        Boolean b = this.getHeaders().getBoolean(string);
        if (b == null) {
            if (this.getHeaders().containsKey(string)) {
                Object str = this.getHeaders().getObject(string);
                if (str == null || !(str instanceof String)) {
                    throw new MessageFormatException("getBoolean can't use " + string + " item.");
                }
                return Boolean.valueOf((String)str);
            }
            b = Boolean.valueOf(null);
        }
        return b;
    }

    public char getCharacter(String string) throws JMSException {
        this.checkPropertyName(string);
        Character c = this.getHeaders().getCharacter(string);
        if (c == null) {
            if (this.getHeaders().isNullStringValue(string)) {
                throw new NullPointerException("Cannot convert null char");
            }
            throw new MessageFormatException("getChar can't use " + string + " item.");
        }
        return c.charValue();
    }

    public byte[] getBytes(String string) throws JMSException {
        return this.getBytes(new AMQShortString(string));
    }

    public byte[] getBytes(AMQShortString string) throws JMSException {
        this.checkPropertyName((CharSequence)string);
        byte[] bs = this.getHeaders().getBytes(string);
        if (bs == null) {
            throw new MessageFormatException("getBytes can't use " + string + " item.");
        }
        return bs;
    }

    public byte getByte(String string) throws JMSException {
        this.checkPropertyName(string);
        Byte b = this.getHeaders().getByte(string);
        if (b == null) {
            if (this.getHeaders().containsKey(string)) {
                Object str = this.getHeaders().getObject(string);
                if (str == null || !(str instanceof String)) {
                    throw new MessageFormatException("getByte can't use " + string + " item.");
                }
                return Byte.valueOf((String)str);
            }
            b = Byte.valueOf(null);
        }
        return b;
    }

    public short getShort(String string) throws JMSException {
        this.checkPropertyName(string);
        Short s = this.getHeaders().getShort(string);
        if (s == null) {
            s = this.getByte(string);
        }
        return s;
    }

    public int getInteger(String string) throws JMSException {
        this.checkPropertyName(string);
        Integer i = this.getHeaders().getInteger(string);
        if (i == null) {
            i = this.getShort(string);
        }
        return i;
    }

    public long getLong(String string) throws JMSException {
        this.checkPropertyName(string);
        Long l = this.getHeaders().getLong(string);
        if (l == null) {
            l = this.getInteger(string);
        }
        return l;
    }

    public float getFloat(String string) throws JMSException {
        this.checkPropertyName(string);
        Float f = this.getHeaders().getFloat(string);
        if (f == null) {
            if (this.getHeaders().containsKey(string)) {
                Object str = this.getHeaders().getObject(string);
                if (str == null || !(str instanceof String)) {
                    throw new MessageFormatException("getFloat can't use " + string + " item.");
                }
                return Float.valueOf((String)str).floatValue();
            }
            throw new NullPointerException("No such property: " + string);
        }
        return f.floatValue();
    }

    public double getDouble(String string) throws JMSException {
        this.checkPropertyName(string);
        Double d = this.getHeaders().getDouble(string);
        if (d == null) {
            d = this.getFloat(string);
        }
        return d;
    }

    public String getString(String string) throws JMSException {
        this.checkPropertyName(string);
        String s = this.getHeaders().getString(string);
        if (s == null && this.getHeaders().containsKey(string)) {
            Object o = this.getHeaders().getObject(string);
            if (o instanceof byte[]) {
                throw new MessageFormatException("getObject couldn't find " + string + " item.");
            }
            if (o == null) {
                return null;
            }
            s = String.valueOf(o);
        }
        return s;
    }

    public Object getObject(String string) throws JMSException {
        this.checkPropertyName(string);
        return this.getHeaders().getObject(string);
    }

    public void setBoolean(AMQShortString string, boolean b) throws JMSException {
        this.checkPropertyName((CharSequence)string);
        this.getHeaders().setBoolean(string, Boolean.valueOf(b));
    }

    public void setBoolean(String string, boolean b) throws JMSException {
        this.checkPropertyName(string);
        this.getHeaders().setBoolean(string, Boolean.valueOf(b));
    }

    public void setChar(String string, char c) throws JMSException {
        this.checkPropertyName(string);
        this.getHeaders().setChar(string, c);
    }

    public Object setBytes(AMQShortString string, byte[] bytes) {
        this.checkPropertyName((CharSequence)string);
        return this.getHeaders().setBytes(string, bytes);
    }

    public Object setBytes(String string, byte[] bytes) {
        this.checkPropertyName(string);
        return this.getHeaders().setBytes(string, bytes);
    }

    public Object setBytes(String string, byte[] bytes, int start, int length) {
        this.checkPropertyName(string);
        return this.getHeaders().setBytes(string, bytes, start, length);
    }

    public void setByte(String string, byte b) throws JMSException {
        this.checkPropertyName(string);
        this.getHeaders().setByte(string, Byte.valueOf(b));
    }

    public void setByte(AMQShortString string, byte b) throws JMSException {
        this.checkPropertyName((CharSequence)string);
        this.getHeaders().setByte(string, Byte.valueOf(b));
    }

    public void setShort(String string, short i) throws JMSException {
        this.checkPropertyName(string);
        this.getHeaders().setShort(string, Short.valueOf(i));
    }

    public void setInteger(String string, int i) throws JMSException {
        this.checkPropertyName(string);
        this.getHeaders().setInteger(string, Integer.valueOf(i));
    }

    public void setInteger(AMQShortString string, int i) throws JMSException {
        this.checkPropertyName((CharSequence)string);
        this.getHeaders().setInteger(string, Integer.valueOf(i));
    }

    public void setLong(String string, long l) throws JMSException {
        this.checkPropertyName(string);
        this.getHeaders().setLong(string, Long.valueOf(l));
    }

    public void setFloat(String string, float v) throws JMSException {
        this.checkPropertyName(string);
        this.getHeaders().setFloat(string, Float.valueOf(v));
    }

    public void setDouble(String string, double v) throws JMSException {
        this.checkPropertyName(string);
        this.getHeaders().setDouble(string, Double.valueOf(v));
    }

    public void setString(String string, String string1) throws JMSException {
        this.checkPropertyName(string);
        this.getHeaders().setString(string, string1);
    }

    public void setString(AMQShortString string, String string1) throws JMSException {
        this.checkPropertyName((CharSequence)string);
        this.getHeaders().setString(string, string1);
    }

    public void setObject(String string, Object object) throws JMSException {
        this.checkPropertyName(string);
        try {
            this.getHeaders().setObject(string, object);
        }
        catch (AMQPInvalidClassException aice) {
            MessageFormatException mfe = new MessageFormatException("Only Primitive objects allowed. Object is: " + (object == null ? "null" : object.getClass()));
            mfe.setLinkedException((Exception)((Object)aice));
            mfe.initCause((Throwable)aice);
            throw mfe;
        }
    }

    public boolean itemExists(String string) throws JMSException {
        this.checkPropertyName(string);
        return this.getHeaders().containsKey(string);
    }

    public Enumeration getPropertyNames() {
        return this.getHeaders().getPropertyNames();
    }

    public void clear() {
        this.getHeaders().clear();
    }

    public boolean propertyExists(AMQShortString propertyName) {
        this.checkPropertyName((CharSequence)propertyName);
        return this.getHeaders().propertyExists(propertyName);
    }

    public boolean propertyExists(String propertyName) {
        this.checkPropertyName(propertyName);
        return this.getHeaders().propertyExists(propertyName);
    }

    public Object put(Object key, Object value) {
        this.checkPropertyName(key.toString());
        return this.getHeaders().setObject(key.toString(), value);
    }

    public Object remove(AMQShortString propertyName) {
        this.checkPropertyName((CharSequence)propertyName);
        return this.getHeaders().remove(propertyName);
    }

    public Object remove(String propertyName) {
        this.checkPropertyName(propertyName);
        return this.getHeaders().remove(propertyName);
    }

    public boolean isEmpty() {
        return this.getHeaders().isEmpty();
    }

    public void writeToBuffer(final ByteBuffer data) {
        try {
            this.getHeaders().writeToBuffer(new DataOutputStream(new OutputStream(){

                public void write(int b) {
                    data.put((byte)b);
                }

                public void write(byte[] b, int off, int len) {
                    data.put(b, off, len);
                }
            }));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unexpected IO Exception - should never happen", e);
        }
    }

    public Enumeration getMapNames() {
        return this.getPropertyNames();
    }

    protected void checkPropertyName(CharSequence propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException("Property name must not be null");
        }
        if (propertyName.length() == 0) {
            throw new IllegalArgumentException("Property name must not be the empty string");
        }
        this.checkIdentiferFormat(propertyName);
    }

    protected void checkIdentiferFormat(CharSequence propertyName) {
        if (Boolean.getBoolean("strict-jms")) {
            if (!Character.isJavaIdentifierStart(propertyName.charAt(0))) {
                throw new IllegalArgumentException("Identifier '" + propertyName + "' does not start with a valid JMS identifier start character");
            }
            int length = propertyName.length();
            for (int c = 1; c < length; ++c) {
                if (Character.isJavaIdentifierPart(propertyName.charAt(c))) continue;
                throw new IllegalArgumentException("Identifier '" + propertyName + "' contains an invalid JMS identifier character");
            }
            if (propertyName.equals("NULL") || propertyName.equals("TRUE") || propertyName.equals("FALSE") || propertyName.equals("NOT") || propertyName.equals("AND") || propertyName.equals("OR") || propertyName.equals("BETWEEN") || propertyName.equals("LIKE") || propertyName.equals("IN") || propertyName.equals("IS") || propertyName.equals("ESCAPE")) {
                throw new IllegalArgumentException("Identifier '" + propertyName + "' is not allowed in JMS");
            }
        }
    }
}

