/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.message;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.ObjectMessage;
import org.apache.qpid.AMQException;
import org.apache.qpid.client.message.AMQMessageDelegate;
import org.apache.qpid.client.message.AMQMessageDelegateFactory;
import org.apache.qpid.client.message.AbstractJMSMessage;
import org.apache.qpid.client.util.ClassLoadingAwareObjectInputStream;

public class JMSObjectMessage
extends AbstractJMSMessage
implements ObjectMessage {
    public static final String MIME_TYPE = "application/java-object-stream";
    private static final int DEFAULT_OUTPUT_BUFFER_SIZE = 256;
    private Serializable _readData;
    private ByteBuffer _data;
    private Exception _exception;
    private static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.allocate(0);

    public JMSObjectMessage(AMQMessageDelegateFactory delegateFactory) {
        super(delegateFactory, false);
    }

    JMSObjectMessage(AMQMessageDelegate delegate, final ByteBuffer data) throws AMQException {
        super(delegate, data != null);
        try {
            ClassLoadingAwareObjectInputStream in = new ClassLoadingAwareObjectInputStream(new InputStream(){

                public int read() throws IOException {
                    return data.get();
                }

                public int read(byte[] b, int off, int len) throws IOException {
                    len = data.remaining() < len ? data.remaining() : len;
                    data.get(b, off, len);
                    return len;
                }
            });
            this._readData = (Serializable)in.readObject();
        }
        catch (IOException e) {
            this._exception = e;
        }
        catch (ClassNotFoundException e) {
            this._exception = e;
        }
    }

    public void clearBody() throws JMSException {
        super.clearBody();
        this._exception = null;
        this._readData = null;
        this._data = null;
    }

    public String toBodyString() throws JMSException {
        return String.valueOf(this.getObject());
    }

    public String getMimeType() {
        return MIME_TYPE;
    }

    public ByteBuffer getData() throws JMSException {
        if (this._exception != null) {
            MessageFormatException messageFormatException = new MessageFormatException("Unable to deserialize message");
            messageFormatException.setLinkedException(this._exception);
            throw messageFormatException;
        }
        if (this._readData == null) {
            return this._data == null ? EMPTY_BYTE_BUFFER : this._data.duplicate();
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(256);
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this._readData);
            oos.flush();
            return ByteBuffer.wrap(baos.toByteArray());
        }
        catch (IOException e) {
            JMSException jmsException = new JMSException("Unable to encode object of type: " + this._readData.getClass().getName() + ", value " + this._readData);
            jmsException.setLinkedException((Exception)e);
            throw jmsException;
        }
    }

    public void setObject(Serializable serializable) throws JMSException {
        this.checkWritable();
        this.clearBody();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(256);
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(serializable);
            oos.flush();
            this._data = ByteBuffer.wrap(baos.toByteArray());
        }
        catch (IOException e) {
            JMSException jmsException = new JMSException("Unable to encode object of type: " + serializable.getClass().getName() + ", value " + serializable);
            jmsException.setLinkedException((Exception)e);
            throw jmsException;
        }
    }

    public Serializable getObject() throws JMSException {
        if (this._exception != null) {
            MessageFormatException messageFormatException = new MessageFormatException("Unable to deserialize message");
            messageFormatException.setLinkedException(this._exception);
            throw messageFormatException;
        }
        if (this._readData != null || this._data == null) {
            return this._readData;
        }
        Exception exception = null;
        final ByteBuffer data = this._data.duplicate();
        try {
            ClassLoadingAwareObjectInputStream in = new ClassLoadingAwareObjectInputStream(new InputStream(){

                public int read() throws IOException {
                    return data.get();
                }

                public int read(byte[] b, int off, int len) throws IOException {
                    len = data.remaining() < len ? data.remaining() : len;
                    data.get(b, off, len);
                    return len;
                }
            });
            return (Serializable)in.readObject();
        }
        catch (ClassNotFoundException e) {
            exception = e;
        }
        catch (IOException e) {
            exception = e;
        }
        JMSException jmsException = new JMSException("Could not deserialize object");
        jmsException.setLinkedException(exception);
        throw jmsException;
    }
}

