/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.filter;

import org.apache.qpid.AMQInternalException;
import org.apache.qpid.client.message.AbstractJMSMessage;
import org.apache.qpid.filter.BooleanExpression;
import org.apache.qpid.filter.MessageFilter;
import org.apache.qpid.filter.selector.SelectorParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSSelectorFilter
implements MessageFilter {
    private static final Logger _logger = LoggerFactory.getLogger(JMSSelectorFilter.class);
    private String _selector;
    private BooleanExpression _matcher;

    public JMSSelectorFilter(String selector) throws AMQInternalException {
        this._selector = selector;
        if (_logger.isDebugEnabled()) {
            _logger.debug("Created JMSSelectorFilter with selector:" + this._selector);
        }
        this._matcher = new SelectorParser().parse(selector);
    }

    public boolean matches(AbstractJMSMessage message) {
        try {
            boolean match = this._matcher.matches(message);
            if (_logger.isDebugEnabled()) {
                _logger.debug(message + " match(" + match + ") selector(" + System.identityHashCode(this._selector) + "):" + this._selector);
            }
            return match;
        }
        catch (AMQInternalException e) {
            _logger.warn("Caught exception when evaluating message selector for message  " + message, (Throwable)e);
            return false;
        }
    }

    public String getSelector() {
        return this._selector;
    }
}

