/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import java.net.URISyntaxException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Topic;
import org.apache.qpid.client.AMQConnection;
import org.apache.qpid.client.AMQDestination;
import org.apache.qpid.exchange.ExchangeDefaults;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.messaging.Address;
import org.apache.qpid.url.BindingURL;

public class AMQTopic
extends AMQDestination
implements Topic {
    public AMQTopic(String address) throws URISyntaxException {
        super(address);
    }

    public AMQTopic(Address address) throws Exception {
        super(address);
    }

    protected AMQTopic() {
    }

    public AMQTopic(BindingURL binding) {
        super(binding);
    }

    public AMQTopic(AMQShortString exchange, AMQShortString routingKey, AMQShortString queueName) {
        super(exchange, ExchangeDefaults.TOPIC_EXCHANGE_CLASS, routingKey, true, true, queueName, false);
    }

    public AMQTopic(AMQShortString exchange, AMQShortString routingKey, AMQShortString queueName, AMQShortString[] bindingKeys) {
        super(exchange, ExchangeDefaults.TOPIC_EXCHANGE_CLASS, routingKey, true, true, queueName, false, bindingKeys);
    }

    public AMQTopic(AMQConnection conn, String routingKey) {
        this(conn.getDefaultTopicExchangeName(), new AMQShortString(routingKey));
    }

    public AMQTopic(AMQShortString exchangeName, String routingKey) {
        this(exchangeName, new AMQShortString(routingKey));
    }

    public AMQTopic(AMQShortString exchangeName, AMQShortString routingKey) {
        this(exchangeName, routingKey, null);
    }

    public AMQTopic(AMQShortString exchangeName, AMQShortString name, boolean isAutoDelete, AMQShortString queueName, boolean isDurable) {
        super(exchangeName, ExchangeDefaults.TOPIC_EXCHANGE_CLASS, name, true, isAutoDelete, queueName, isDurable);
    }

    protected AMQTopic(AMQShortString exchangeName, AMQShortString exchangeClass, AMQShortString routingKey, boolean isExclusive, boolean isAutoDelete, AMQShortString queueName, boolean isDurable) {
        super(exchangeName, exchangeClass, routingKey, isExclusive, isAutoDelete, queueName, isDurable);
    }

    protected AMQTopic(AMQShortString exchangeName, AMQShortString exchangeClass, AMQShortString routingKey, boolean isExclusive, boolean isAutoDelete, AMQShortString queueName, boolean isDurable, AMQShortString[] bindingKeys) {
        super(exchangeName, exchangeClass, routingKey, isExclusive, isAutoDelete, queueName, isDurable, bindingKeys);
    }

    public static AMQTopic createDurableTopic(Topic topic, String subscriptionName, AMQConnection connection) throws JMSException {
        if (topic instanceof AMQDestination && topic instanceof Topic) {
            AMQDestination qpidTopic = (AMQDestination)topic;
            if (qpidTopic.getDestSyntax() == AMQDestination.DestSyntax.ADDR) {
                try {
                    AMQTopic t = new AMQTopic(qpidTopic.getAddress());
                    AMQShortString queueName = AMQTopic.getDurableTopicQueueName(subscriptionName, connection);
                    t.getLink().setName(queueName.asString());
                    t.getSourceNode().setAutoDelete(false);
                    t.getSourceNode().setDurable(true);
                    t.setQueueName(queueName);
                    t.setAutoDelete(false);
                    t.setDurable(true);
                    return t;
                }
                catch (Exception e) {
                    JMSException ex = new JMSException("Error creating durable topic");
                    ex.initCause((Throwable)e);
                    ex.setLinkedException(e);
                    throw ex;
                }
            }
            return new AMQTopic(qpidTopic.getExchangeName(), qpidTopic.getRoutingKey(), false, AMQTopic.getDurableTopicQueueName(subscriptionName, connection), true);
        }
        throw new InvalidDestinationException("The destination object used is not from this provider or of type javax.jms.Topic");
    }

    public static AMQShortString getDurableTopicQueueName(String subscriptionName, AMQConnection connection) throws JMSException {
        return new AMQShortString(connection.getClientID() + ":" + subscriptionName);
    }

    public String getTopicName() throws JMSException {
        if (this.getRoutingKey() != null) {
            return this.getRoutingKey().asString();
        }
        if (this.getSubject() != null) {
            return this.getSubject();
        }
        return null;
    }

    public AMQShortString getExchangeName() {
        if (super.getExchangeName() == null && super.getAddressName() != null) {
            return new AMQShortString(super.getAddressName());
        }
        return super.getExchangeName();
    }

    public AMQShortString getRoutingKey() {
        if (super.getRoutingKey() != null) {
            return super.getRoutingKey();
        }
        if (this.getSubject() != null) {
            return new AMQShortString(this.getSubject());
        }
        this.setRoutingKey(new AMQShortString(""));
        this.setSubject("");
        return super.getRoutingKey();
    }

    public boolean isNameRequired() {
        return !this.isDurable();
    }

    public void setQueueName(String queueName) {
    }

    public boolean equals(Object o) {
        return o instanceof AMQTopic && ((AMQTopic)o).getExchangeName().equals(this.getExchangeName()) && ((AMQTopic)o).getRoutingKey().equals(this.getRoutingKey());
    }

    public int hashCode() {
        return this.getExchangeName().hashCode() + this.getRoutingKey().hashCode();
    }
}

