/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.security;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.qpid.client.security.AMQCallbackHandler;
import org.apache.qpid.jms.ConnectionURL;

public class UsernameHashedPasswordCallbackHandler
implements AMQCallbackHandler {
    private ConnectionURL _connectionURL;

    public void initialise(ConnectionURL connectionURL) {
        this._connectionURL = connectionURL;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            Callback cb = callbacks[i];
            if (cb instanceof NameCallback) {
                ((NameCallback)cb).setName(this._connectionURL.getUsername());
                continue;
            }
            if (cb instanceof PasswordCallback) {
                try {
                    ((PasswordCallback)cb).setPassword(this.getHash(this._connectionURL.getPassword()));
                    continue;
                }
                catch (NoSuchAlgorithmException e) {
                    UnsupportedCallbackException uce = new UnsupportedCallbackException(cb);
                    uce.initCause(e);
                    throw uce;
                }
            }
            throw new UnsupportedCallbackException(cb);
        }
    }

    private char[] getHash(String text) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        byte[] data = text.getBytes("utf-8");
        MessageDigest md = MessageDigest.getInstance("MD5");
        for (byte b : data) {
            md.update(b);
        }
        byte[] digest = md.digest();
        char[] hash = new char[digest.length];
        int index = 0;
        for (byte b : digest) {
            hash[index++] = (char)b;
        }
        return hash;
    }
}

