/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.UUID;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XATopicConnection;
import javax.jms.XATopicConnectionFactory;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import org.apache.qpid.client.AMQConnection;
import org.apache.qpid.client.AMQConnectionURL;
import org.apache.qpid.client.AMQQueue;
import org.apache.qpid.client.AMQTopic;
import org.apache.qpid.client.XAConnectionImpl;
import org.apache.qpid.jms.ConnectionURL;
import org.apache.qpid.url.AMQBindingURL;
import org.apache.qpid.url.BindingURL;
import org.apache.qpid.url.URLSyntaxException;

public class AMQConnectionFactory
implements ConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory,
ObjectFactory,
Referenceable,
XATopicConnectionFactory,
XAQueueConnectionFactory,
XAConnectionFactory {
    protected static final String NO_URL_CONFIGURED = "The connection factory wasn't created with a proper URL, the connection details are empty";
    private ConnectionURL _connectionDetails;

    public AMQConnectionFactory() {
    }

    public AMQConnectionFactory(String url) throws URLSyntaxException {
        if (url == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        this._connectionDetails = new AMQConnectionURL(url);
    }

    public AMQConnectionFactory(ConnectionURL url) {
        if (url == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        this._connectionDetails = url;
    }

    public final String getVirtualPath() {
        return this._connectionDetails.getVirtualHost();
    }

    public static String getUniqueClientID() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.getHostName() + System.currentTimeMillis();
        }
        catch (UnknownHostException e) {
            return "UnknownHost" + UUID.randomUUID();
        }
    }

    public Connection createConnection() throws JMSException {
        if (this._connectionDetails == null) {
            throw new JMSException(NO_URL_CONFIGURED);
        }
        try {
            if (this._connectionDetails.getClientName() == null || this._connectionDetails.getClientName().equals("")) {
                this._connectionDetails.setClientName(AMQConnectionFactory.getUniqueClientID());
            }
            return new AMQConnection(this._connectionDetails);
        }
        catch (Exception e) {
            JMSException jmse = new JMSException("Error creating connection: " + e.getMessage());
            jmse.setLinkedException(e);
            jmse.initCause((Throwable)e);
            throw jmse;
        }
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        return this.createConnection(userName, password, null);
    }

    public Connection createConnection(String userName, String password, String id) throws JMSException {
        if (this._connectionDetails != null) {
            try {
                AMQConnectionURL connectionDetails = new AMQConnectionURL(this._connectionDetails.toString());
                connectionDetails.setUsername(userName);
                connectionDetails.setPassword(password);
                if (id != null && !id.equals("")) {
                    connectionDetails.setClientName(id);
                } else if (connectionDetails.getClientName() == null || connectionDetails.getClientName().equals("")) {
                    connectionDetails.setClientName(AMQConnectionFactory.getUniqueClientID());
                }
                return new AMQConnection(connectionDetails);
            }
            catch (Exception e) {
                JMSException jmse = new JMSException("Error creating connection: " + e.getMessage());
                jmse.setLinkedException(e);
                jmse.initCause((Throwable)e);
                throw jmse;
            }
        }
        throw new JMSException(NO_URL_CONFIGURED);
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return (QueueConnection)this.createConnection();
    }

    public QueueConnection createQueueConnection(String username, String password) throws JMSException {
        return (QueueConnection)this.createConnection(username, password);
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return (TopicConnection)this.createConnection();
    }

    public TopicConnection createTopicConnection(String username, String password) throws JMSException {
        return (TopicConnection)this.createConnection(username, password);
    }

    public ConnectionURL getConnectionURL() {
        return this._connectionDetails;
    }

    public String getConnectionURLString() {
        return this._connectionDetails.toString();
    }

    public final void setConnectionURLString(String url) throws URLSyntaxException {
        this._connectionDetails = new AMQConnectionURL(url);
    }

    public Object getObjectInstance(Object obj, Name name, Context ctx, Hashtable env) throws Exception {
        if (obj instanceof Reference) {
            RefAddr addr;
            Reference ref = (Reference)obj;
            if (ref.getClassName().equals(AMQConnection.class.getName()) && (addr = ref.get(AMQConnection.class.getName())) != null) {
                return new AMQConnection((String)addr.getContent());
            }
            if (ref.getClassName().equals(AMQQueue.class.getName()) && (addr = ref.get(AMQQueue.class.getName())) != null) {
                return new AMQQueue((BindingURL)new AMQBindingURL((String)addr.getContent()));
            }
            if (ref.getClassName().equals(AMQTopic.class.getName()) && (addr = ref.get(AMQTopic.class.getName())) != null) {
                return new AMQTopic((BindingURL)new AMQBindingURL((String)addr.getContent()));
            }
            if (ref.getClassName().equals(AMQConnectionFactory.class.getName()) && (addr = ref.get(AMQConnectionFactory.class.getName())) != null) {
                return new AMQConnectionFactory((String)addr.getContent());
            }
        }
        return null;
    }

    public Reference getReference() throws NamingException {
        return new Reference(AMQConnectionFactory.class.getName(), new StringRefAddr(AMQConnectionFactory.class.getName(), this._connectionDetails.getURL()), AMQConnectionFactory.class.getName(), null);
    }

    public XAConnection createXAConnection() throws JMSException {
        try {
            return new XAConnectionImpl(this._connectionDetails);
        }
        catch (Exception e) {
            JMSException jmse = new JMSException("Error creating connection: " + e.getMessage());
            jmse.setLinkedException(e);
            jmse.initCause((Throwable)e);
            throw jmse;
        }
    }

    public XAConnection createXAConnection(String username, String password) throws JMSException {
        if (this._connectionDetails != null) {
            try {
                AMQConnectionURL connectionDetails = new AMQConnectionURL(this._connectionDetails.toString());
                connectionDetails.setUsername(username);
                connectionDetails.setPassword(password);
                if (connectionDetails.getClientName() == null || connectionDetails.getClientName().equals("")) {
                    connectionDetails.setClientName(AMQConnectionFactory.getUniqueClientID());
                }
                return new XAConnectionImpl(connectionDetails);
            }
            catch (Exception e) {
                JMSException jmse = new JMSException("Error creating XA Connection: " + e.getMessage());
                jmse.setLinkedException(e);
                jmse.initCause((Throwable)e);
                throw jmse;
            }
        }
        throw new JMSException(NO_URL_CONFIGURED);
    }

    public XATopicConnection createXATopicConnection() throws JMSException {
        return (XATopicConnection)this.createXAConnection();
    }

    public XATopicConnection createXATopicConnection(String username, String password) throws JMSException {
        return (XATopicConnection)this.createXAConnection(username, password);
    }

    public XAQueueConnection createXAQueueConnection() throws JMSException {
        return (XAQueueConnection)this.createXAConnection();
    }

    public XAQueueConnection createXAQueueConnection(String username, String password) throws JMSException {
        return (XAQueueConnection)this.createXAConnection(username, password);
    }
}

