/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.message;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.MessageFormatException;
import org.apache.qpid.AMQException;
import org.apache.qpid.client.message.AMQMessageDelegate;
import org.apache.qpid.client.message.AMQMessageDelegateFactory;
import org.apache.qpid.client.message.AbstractJMSMessage;
import org.apache.qpid.client.message.TypedBytesContentReader;
import org.apache.qpid.client.message.TypedBytesContentWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSMapMessage
extends AbstractJMSMessage
implements MapMessage {
    private static final Logger _logger = LoggerFactory.getLogger(JMSMapMessage.class);
    public static final String MIME_TYPE = "jms/map-message";
    private Map<String, Object> _map = new HashMap<String, Object>();

    public JMSMapMessage(AMQMessageDelegateFactory delegateFactory) throws JMSException {
        this(delegateFactory, null);
    }

    JMSMapMessage(AMQMessageDelegateFactory delegateFactory, ByteBuffer data) throws JMSException {
        super(delegateFactory, data != null);
        if (data != null) {
            this.populateMapFromData(data);
        }
    }

    JMSMapMessage(AMQMessageDelegate delegate, ByteBuffer data) throws AMQException {
        super(delegate, data != null);
        try {
            this.populateMapFromData(data);
        }
        catch (JMSException je) {
            throw new AMQException(null, "Error populating MapMessage from ByteBuffer", (Throwable)je);
        }
    }

    @Override
    public String toBodyString() throws JMSException {
        return this._map == null ? "" : this._map.toString();
    }

    @Override
    protected String getMimeType() {
        return MIME_TYPE;
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this._map.clear();
    }

    public boolean getBoolean(String propName) throws JMSException {
        Object value = this._map.get(propName);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String || value == null) {
            return Boolean.valueOf((String)value);
        }
        throw new MessageFormatException("Property " + propName + " of type " + value.getClass().getName() + " cannot be converted to boolean.");
    }

    public byte getByte(String propName) throws JMSException {
        Object value = this._map.get(propName);
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof String || value == null) {
            return Byte.valueOf((String)value);
        }
        throw new MessageFormatException("Property " + propName + " of type " + value.getClass().getName() + " cannot be converted to byte.");
    }

    public short getShort(String propName) throws JMSException {
        Object value = this._map.get(propName);
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Byte) {
            return ((Byte)value).shortValue();
        }
        if (value instanceof String || value == null) {
            return Short.valueOf((String)value);
        }
        throw new MessageFormatException("Property " + propName + " of type " + value.getClass().getName() + " cannot be converted to short.");
    }

    public int getInt(String propName) throws JMSException {
        Object value = this._map.get(propName);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Short) {
            return ((Short)value).intValue();
        }
        if (value instanceof Byte) {
            return ((Byte)value).intValue();
        }
        if (value instanceof String || value == null) {
            return Integer.valueOf((String)value);
        }
        throw new MessageFormatException("Property " + propName + " of type " + value.getClass().getName() + " cannot be converted to int.");
    }

    public long getLong(String propName) throws JMSException {
        Object value = this._map.get(propName);
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        if (value instanceof Short) {
            return ((Short)value).longValue();
        }
        if (value instanceof Byte) {
            return ((Byte)value).longValue();
        }
        if (value instanceof String || value == null) {
            return Long.valueOf((String)value);
        }
        throw new MessageFormatException("Property " + propName + " of type " + value.getClass().getName() + " cannot be converted to long.");
    }

    public char getChar(String propName) throws JMSException {
        Object value = this._map.get(propName);
        if (!this._map.containsKey(propName)) {
            throw new MessageFormatException("Property " + propName + " not present");
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        if (value == null) {
            throw new NullPointerException("Property " + propName + " has null value and therefore cannot " + "be converted to char.");
        }
        throw new MessageFormatException("Property " + propName + " of type " + value.getClass().getName() + " cannot be converted to boolan.");
    }

    public float getFloat(String propName) throws JMSException {
        Object value = this._map.get(propName);
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof String || value == null) {
            return Float.valueOf((String)value).floatValue();
        }
        throw new MessageFormatException("Property " + propName + " of type " + value.getClass().getName() + " cannot be converted to float.");
    }

    public double getDouble(String propName) throws JMSException {
        Object value = this._map.get(propName);
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Float) {
            return ((Float)value).doubleValue();
        }
        if (value instanceof String || value == null) {
            return Double.valueOf((String)value);
        }
        throw new MessageFormatException("Property " + propName + " of type " + value.getClass().getName() + " cannot be converted to double.");
    }

    public String getString(String propName) throws JMSException {
        Object value = this._map.get(propName);
        if (value instanceof String || value == null) {
            return (String)value;
        }
        if (value instanceof byte[]) {
            throw new MessageFormatException("Property " + propName + " of type byte[] " + "cannot be converted to String.");
        }
        return value.toString();
    }

    public byte[] getBytes(String propName) throws JMSException {
        Object value = this._map.get(propName);
        if (!this._map.containsKey(propName)) {
            throw new MessageFormatException("Property " + propName + " not present");
        }
        if (value instanceof byte[] || value == null) {
            return (byte[])value;
        }
        throw new MessageFormatException("Property " + propName + " of type " + value.getClass().getName() + " cannot be converted to byte[].");
    }

    public Object getObject(String propName) throws JMSException {
        return this._map.get(propName);
    }

    public Enumeration getMapNames() throws JMSException {
        return Collections.enumeration(this._map.keySet());
    }

    public void setBoolean(String propName, boolean b) throws JMSException {
        this.checkWritable();
        this.checkPropertyName(propName);
        this._map.put(propName, b);
    }

    public void setByte(String propName, byte b) throws JMSException {
        this.checkWritable();
        this.checkPropertyName(propName);
        this._map.put(propName, b);
    }

    public void setShort(String propName, short i) throws JMSException {
        this.checkWritable();
        this.checkPropertyName(propName);
        this._map.put(propName, i);
    }

    public void setChar(String propName, char c) throws JMSException {
        this.checkWritable();
        this.checkPropertyName(propName);
        this._map.put(propName, Character.valueOf(c));
    }

    public void setInt(String propName, int i) throws JMSException {
        this.checkWritable();
        this.checkPropertyName(propName);
        this._map.put(propName, i);
    }

    public void setLong(String propName, long l) throws JMSException {
        this.checkWritable();
        this.checkPropertyName(propName);
        this._map.put(propName, l);
    }

    public void setFloat(String propName, float v) throws JMSException {
        this.checkWritable();
        this.checkPropertyName(propName);
        this._map.put(propName, Float.valueOf(v));
    }

    public void setDouble(String propName, double v) throws JMSException {
        this.checkWritable();
        this.checkPropertyName(propName);
        this._map.put(propName, v);
    }

    public void setString(String propName, String string1) throws JMSException {
        this.checkWritable();
        this.checkPropertyName(propName);
        this._map.put(propName, string1);
    }

    public void setBytes(String propName, byte[] bytes) throws JMSException {
        this.checkWritable();
        this.checkPropertyName(propName);
        this._map.put(propName, bytes);
    }

    public void setBytes(String propName, byte[] bytes, int offset, int length) throws JMSException {
        if (offset == 0 && length == bytes.length) {
            this.setBytes(propName, bytes);
        } else {
            byte[] newBytes = new byte[length];
            System.arraycopy(bytes, offset, newBytes, 0, length);
            this.setBytes(propName, newBytes);
        }
    }

    public void setObject(String propName, Object value) throws JMSException {
        this.checkWritable();
        this.checkPropertyName(propName);
        if (!(value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Character || value instanceof Float || value instanceof Double || value instanceof String || value instanceof byte[] || value == null)) {
            throw new MessageFormatException("Cannot set property " + propName + " to value " + value + "of type " + value.getClass().getName() + ".");
        }
        this._map.put(propName, value);
    }

    protected void checkPropertyName(String propName) {
        if (propName == null || propName.equals("")) {
            throw new IllegalArgumentException("Property name cannot be null, or the empty String.");
        }
    }

    public boolean itemExists(String propName) throws JMSException {
        return this._map.containsKey(propName);
    }

    protected void populateMapFromData(ByteBuffer data) throws JMSException {
        TypedBytesContentReader reader = new TypedBytesContentReader(data);
        if (data != null) {
            data.rewind();
            int entries = reader.readIntImpl();
            for (int i = 0; i < entries; ++i) {
                String propName = reader.readStringImpl();
                Object value = reader.readObject();
                this._map.put(propName, value);
            }
        } else {
            this._map.clear();
        }
    }

    @Override
    public ByteBuffer getData() throws JMSException {
        TypedBytesContentWriter writer = new TypedBytesContentWriter();
        int size = this._map.size();
        writer.writeIntImpl(size);
        for (Map.Entry<String, Object> entry : this._map.entrySet()) {
            writer.writeNullTerminatedStringImpl(entry.getKey());
            writer.writeObject(entry.getValue());
        }
        return writer.getData();
    }

    protected Map<String, Object> getMap() {
        return this._map;
    }

    protected void setMap(Map<String, Object> map) {
        this._map = map;
    }
}

