/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.qpid.AMQException;
import org.apache.qpid.client.AMQConnection;
import org.apache.qpid.client.AMQDestination;
import org.apache.qpid.client.AMQQueue;
import org.apache.qpid.client.AMQSession_0_8;
import org.apache.qpid.client.AMQTopic;
import org.apache.qpid.client.BasicMessageConsumer;
import org.apache.qpid.client.RejectBehaviour;
import org.apache.qpid.client.failover.FailoverException;
import org.apache.qpid.client.message.AMQMessageDelegateFactory;
import org.apache.qpid.client.message.AbstractJMSMessage;
import org.apache.qpid.client.message.MessageFactoryRegistry;
import org.apache.qpid.client.message.UnprocessedMessage_0_8;
import org.apache.qpid.common.AMQPFilterTypes;
import org.apache.qpid.framing.AMQFrame;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.BasicCancelBody;
import org.apache.qpid.framing.BasicCancelOkBody;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.jms.ConnectionURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicMessageConsumer_0_8
extends BasicMessageConsumer<UnprocessedMessage_0_8> {
    private final Logger _logger = LoggerFactory.getLogger(this.getClass());
    private AMQSession_0_8.DestinationCache<AMQTopic> _topicDestinationCache;
    private AMQSession_0_8.DestinationCache<AMQQueue> _queueDestinationCache;
    private final RejectBehaviour _rejectBehaviour;

    protected BasicMessageConsumer_0_8(int channelId, AMQConnection connection, AMQDestination destination, String messageSelector, boolean noLocal, MessageFactoryRegistry messageFactory, AMQSession_0_8 session, FieldTable rawSelector, int prefetchHigh, int prefetchLow, boolean exclusive, int acknowledgeMode, boolean browseOnly, boolean autoClose) throws JMSException {
        super(channelId, connection, destination, messageSelector, noLocal, messageFactory, session, rawSelector, prefetchHigh, prefetchLow, exclusive, acknowledgeMode, browseOnly, autoClose);
        FieldTable consumerArguments = this.getArguments();
        if (this.isAutoClose()) {
            consumerArguments.put(AMQPFilterTypes.AUTO_CLOSE.getValue(), (Object)Boolean.TRUE);
        }
        if (this.isBrowseOnly()) {
            consumerArguments.put(AMQPFilterTypes.NO_CONSUME.getValue(), (Object)Boolean.TRUE);
        }
        this._topicDestinationCache = session.getTopicDestinationCache();
        this._queueDestinationCache = session.getQueueDestinationCache();
        if (destination.getRejectBehaviour() != null) {
            this._rejectBehaviour = destination.getRejectBehaviour();
        } else {
            ConnectionURL connectionURL = connection.getConnectionURL();
            String rejectBehaviour = connectionURL.getOption("rejectbehaviour");
            if (rejectBehaviour != null) {
                this._rejectBehaviour = RejectBehaviour.valueOf(rejectBehaviour.toUpperCase());
            } else {
                rejectBehaviour = System.getProperty("qpid.reject.behaviour", RejectBehaviour.NORMAL.toString());
                this._rejectBehaviour = RejectBehaviour.valueOf(rejectBehaviour.toUpperCase());
            }
        }
    }

    @Override
    public AMQSession_0_8 getSession() {
        return (AMQSession_0_8)super.getSession();
    }

    @Override
    void sendCancel() throws AMQException, FailoverException {
        BasicCancelBody body = this.getSession().getMethodRegistry().createBasicCancelBody(new AMQShortString(String.valueOf(this.getConsumerTag())), false);
        AMQFrame cancelFrame = body.generateFrame(this.getChannelId());
        this.getConnection().getProtocolHandler().syncWrite(cancelFrame, BasicCancelOkBody.class);
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("CancelOk'd for consumer:" + this.debugIdentity());
        }
    }

    @Override
    public AbstractJMSMessage createJMSMessageFromUnprocessedMessage(AMQMessageDelegateFactory delegateFactory, UnprocessedMessage_0_8 messageFrame) throws Exception {
        return this.getMessageFactory().createMessage(messageFrame.getDeliveryTag(), messageFrame.isRedelivered(), messageFrame.getExchange(), messageFrame.getRoutingKey(), messageFrame.getContentHeader(), messageFrame.getBodies(), this._queueDestinationCache, this._topicDestinationCache);
    }

    @Override
    Message receiveBrowse() throws JMSException {
        return this.receive();
    }

    public RejectBehaviour getRejectBehaviour() {
        return this._rejectBehaviour;
    }
}

