/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.message;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;
import org.apache.qpid.AMQException;
import org.apache.qpid.client.AMQDestination;
import org.apache.qpid.client.AMQSession_0_10;
import org.apache.qpid.client.CustomJMSXProperty;
import org.apache.qpid.client.message.AbstractAMQMessageDelegate;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.transport.DeliveryProperties;
import org.apache.qpid.transport.ExchangeQueryResult;
import org.apache.qpid.transport.Future;
import org.apache.qpid.transport.Header;
import org.apache.qpid.transport.MessageDeliveryMode;
import org.apache.qpid.transport.MessageDeliveryPriority;
import org.apache.qpid.transport.MessageProperties;
import org.apache.qpid.transport.Option;
import org.apache.qpid.transport.ReplyTo;
import org.apache.qpid.transport.Session;
import org.apache.qpid.transport.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQMessageDelegate_0_10
extends AbstractAMQMessageDelegate {
    private static final Logger _logger = LoggerFactory.getLogger(AMQMessageDelegate_0_10.class);
    private static final float DESTINATION_CACHE_LOAD_FACTOR = 0.75f;
    private static final int DESTINATION_CACHE_SIZE = 500;
    private static final int DESTINATION_CACHE_CAPACITY = 666;
    private static final Map<ReplyTo, Destination> _destinationCache = Collections.synchronizedMap(new LinkedHashMap<ReplyTo, Destination>(666, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<ReplyTo, Destination> eldest) {
            return this.size() >= 500;
        }
    });
    public static final String JMS_TYPE = "x-jms-type";
    private boolean _readableProperties = false;
    private Destination _destination;
    private MessageProperties _messageProps;
    private DeliveryProperties _deliveryProps;
    private String _messageID;
    private boolean isStrictJMS = Boolean.getBoolean("strict-jms");
    private static final Set<Class> ALLOWED = new HashSet<Class>();

    protected AMQMessageDelegate_0_10() {
        this(new MessageProperties(), new DeliveryProperties(), -1L);
        this._readableProperties = false;
    }

    protected AMQMessageDelegate_0_10(MessageProperties messageProps, DeliveryProperties deliveryProps, long deliveryTag) {
        this(AMQDestination.getDefaultDestSyntax(), messageProps, deliveryProps, deliveryTag);
    }

    protected AMQMessageDelegate_0_10(AMQDestination.DestSyntax destSyntax, MessageProperties messageProps, DeliveryProperties deliveryProps, long deliveryTag) {
        super(deliveryTag);
        AMQDestination dest;
        this._messageProps = messageProps;
        this._deliveryProps = deliveryProps;
        boolean bl = this._readableProperties = this._messageProps != null;
        if (destSyntax == AMQDestination.DestSyntax.BURL) {
            dest = this.generateDestination(new AMQShortString(this._deliveryProps.getExchange()), new AMQShortString(this._deliveryProps.getRoutingKey()));
        } else {
            String subject = null;
            if (this.isStrictJMS && messageProps != null && messageProps.getApplicationHeaders() != null && (subject = (String)messageProps.getApplicationHeaders().get("qpid.subject")) != null) {
                messageProps.getApplicationHeaders().remove("qpid.subject");
                messageProps.getApplicationHeaders().put("JMS_qpid_subject", subject);
            }
            dest = (AMQDestination)this.convertToAddressBasedDestination(this._deliveryProps.getExchange(), this._deliveryProps.getRoutingKey(), subject);
        }
        this.setJMSDestination(dest);
    }

    public static void updateExchangeTypeMapping(Header header, Session session) {
        MessageProperties msgProps;
        DeliveryProperties deliveryProps = header.getDeliveryProperties();
        if (deliveryProps != null) {
            String exchange = deliveryProps.getExchange();
            AMQMessageDelegate_0_10.checkAndUpdateExchange(exchange, session);
        }
        if ((msgProps = header.getMessageProperties()) != null && msgProps.getReplyTo() != null) {
            String exchange = msgProps.getReplyTo().getExchange();
            AMQMessageDelegate_0_10.checkAndUpdateExchange(exchange, session);
        }
    }

    private static void checkAndUpdateExchange(String exchange, Session session) {
        if (exchange != null && !AMQMessageDelegate_0_10.exchangeMapContains(exchange)) {
            Future future = session.exchangeQuery(exchange.toString(), new Option[0]);
            ExchangeQueryResult res = (ExchangeQueryResult)future.get();
            AMQMessageDelegate_0_10.updateExchangeType(exchange, res.getType());
        }
    }

    @Override
    public String getJMSMessageID() throws JMSException {
        if (this._messageID == null && this._messageProps.getMessageId() != null) {
            UUID id = this._messageProps.getMessageId();
            this._messageID = "ID:" + id;
        }
        return this._messageID;
    }

    @Override
    public void setJMSMessageID(String messageId) throws JMSException {
        if (messageId == null) {
            this._messageProps.clearMessageId();
        } else if (messageId.startsWith("ID:")) {
            this._messageID = messageId;
        } else {
            throw new JMSException("MessageId '" + messageId + "' is not of the correct format, it must be prefixed with 'ID:'");
        }
    }

    @Override
    public void setJMSMessageID(UUID messageId) throws JMSException {
        if (messageId == null) {
            this._messageProps.clearMessageId();
        } else {
            this._messageProps.setMessageId(messageId);
        }
    }

    @Override
    public long getJMSTimestamp() throws JMSException {
        return this._deliveryProps.getTimestamp();
    }

    @Override
    public void setJMSTimestamp(long timestamp) throws JMSException {
        this._deliveryProps.setTimestamp(timestamp);
    }

    @Override
    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        return this._messageProps.getCorrelationId();
    }

    @Override
    public void setJMSCorrelationIDAsBytes(byte[] bytes) throws JMSException {
        this._messageProps.setCorrelationId(bytes);
    }

    @Override
    public void setJMSCorrelationID(String correlationId) throws JMSException {
        this.setJMSCorrelationIDAsBytes(correlationId == null ? null : correlationId.getBytes());
    }

    @Override
    public String getJMSCorrelationID() throws JMSException {
        byte[] correlationIDAsBytes = this.getJMSCorrelationIDAsBytes();
        return correlationIDAsBytes == null ? null : new String(correlationIDAsBytes);
    }

    @Override
    public Destination getJMSReplyTo() {
        ReplyTo replyTo = this._messageProps.getReplyTo();
        if (replyTo == null || replyTo.getExchange() == null && replyTo.getRoutingKey() == null) {
            return null;
        }
        Destination dest = _destinationCache.get(replyTo);
        if (dest == null) {
            String exchange = replyTo.getExchange();
            String routingKey = replyTo.getRoutingKey();
            dest = AMQDestination.getDefaultDestSyntax() == AMQDestination.DestSyntax.BURL ? this.generateDestination(new AMQShortString(exchange), new AMQShortString(routingKey)) : this.convertToAddressBasedDestination(exchange, routingKey, null);
            _destinationCache.put(replyTo, dest);
        }
        return dest;
    }

    private Destination convertToAddressBasedDestination(String exchange, String routingKey, String subject) {
        String addr;
        boolean isQueue = true;
        if ("".equals(exchange)) {
            subject = subject == null ? "" : "/" + subject;
            addr = routingKey + subject;
        } else {
            addr = exchange + "/" + routingKey;
            isQueue = false;
        }
        try {
            AMQDestination dest = (AMQDestination)AMQDestination.createDestination("ADDR:" + addr);
            if (isQueue) {
                dest.setQueueName(new AMQShortString(routingKey));
                dest.setRoutingKey(new AMQShortString(routingKey));
                dest.setExchangeName(new AMQShortString(""));
            } else {
                dest.setRoutingKey(new AMQShortString(routingKey));
                dest.setExchangeName(new AMQShortString(exchange));
            }
            return dest;
        }
        catch (Exception e) {
            _logger.error("Exception when constructing an address string from the ReplyTo struct");
            return this.generateDestination(new AMQShortString(exchange), new AMQShortString(routingKey));
        }
    }

    @Override
    public void setJMSReplyTo(Destination destination) throws JMSException {
        if (destination == null) {
            this._messageProps.clearReplyTo();
            return;
        }
        if (!(destination instanceof AMQDestination)) {
            throw new IllegalArgumentException("ReplyTo destination may only be an AMQDestination - passed argument was type " + destination.getClass());
        }
        AMQDestination amqd = (AMQDestination)destination;
        if (amqd.getDestSyntax() == AMQDestination.DestSyntax.ADDR) {
            try {
                int type = ((AMQSession_0_10)this.getAMQSession()).resolveAddressType(amqd);
                if (type == 1) {
                    ((AMQSession_0_10)this.getAMQSession()).setLegacyFieldsForQueueType(amqd);
                } else {
                    ((AMQSession_0_10)this.getAMQSession()).setLegacyFiledsForTopicType(amqd);
                }
            }
            catch (AMQException ex) {
                JMSException e = new JMSException("Error occured while figuring out the node type");
                e.initCause((Throwable)ex);
                e.setLinkedException((Exception)((Object)ex));
                throw e;
            }
            catch (TransportException e) {
                JMSException jmse = new JMSException("Exception occured while figuring out the node type:" + e.getMessage());
                jmse.initCause((Throwable)e);
                jmse.setLinkedException((Exception)((Object)e));
                throw jmse;
            }
        }
        ReplyTo replyTo = new ReplyTo(amqd.getExchangeName().toString(), amqd.getRoutingKey().toString());
        _destinationCache.put(replyTo, destination);
        this._messageProps.setReplyTo(replyTo);
    }

    @Override
    public Destination getJMSDestination() throws JMSException {
        return this._destination;
    }

    @Override
    public void setJMSDestination(Destination destination) {
        this._destination = destination;
    }

    @Override
    public void setContentType(String contentType) {
        this._messageProps.setContentType(contentType);
    }

    @Override
    public String getContentType() {
        return this._messageProps.getContentType();
    }

    @Override
    public void setEncoding(String encoding) {
        if (encoding == null || encoding.length() == 0) {
            this._messageProps.clearContentEncoding();
        } else {
            this._messageProps.setContentEncoding(encoding);
        }
    }

    @Override
    public String getEncoding() {
        return this._messageProps.getContentEncoding();
    }

    @Override
    public String getReplyToString() {
        Destination replyTo = this.getJMSReplyTo();
        if (replyTo != null) {
            return ((AMQDestination)replyTo).toString();
        }
        return null;
    }

    @Override
    public int getJMSDeliveryMode() throws JMSException {
        MessageDeliveryMode deliveryMode = this._deliveryProps.getDeliveryMode();
        if (deliveryMode != null) {
            switch (deliveryMode) {
                case PERSISTENT: {
                    return 2;
                }
                case NON_PERSISTENT: {
                    return 1;
                }
            }
            throw new JMSException("Unknown Message Delivery Mode: " + this._deliveryProps.getDeliveryMode());
        }
        return 2;
    }

    @Override
    public void setJMSDeliveryMode(int deliveryMode) throws JMSException {
        switch (deliveryMode) {
            case 2: {
                this._deliveryProps.setDeliveryMode(MessageDeliveryMode.PERSISTENT);
                break;
            }
            case 1: {
                this._deliveryProps.setDeliveryMode(MessageDeliveryMode.NON_PERSISTENT);
                break;
            }
            default: {
                throw new JMSException("Unknown JMS Delivery Mode: " + deliveryMode);
            }
        }
    }

    @Override
    public String getJMSType() throws JMSException {
        if (this.getApplicationHeaders().containsKey(JMS_TYPE)) {
            return this.getStringProperty(JMS_TYPE);
        }
        return null;
    }

    private Map<String, Object> getApplicationHeaders() {
        Map map = this._messageProps.getApplicationHeaders();
        return map == null ? Collections.EMPTY_MAP : map;
    }

    @Override
    public void setJMSType(String type) throws JMSException {
        HashMap<String, String> headers = this._messageProps.getApplicationHeaders();
        if (type == null) {
            if (headers != null) {
                headers.remove(JMS_TYPE);
            }
        } else {
            if (headers == null) {
                headers = new HashMap<String, String>();
                this._messageProps.setApplicationHeaders(headers);
            }
            headers.put(JMS_TYPE, type);
        }
    }

    @Override
    public long getJMSExpiration() throws JMSException {
        return this._deliveryProps.getExpiration();
    }

    @Override
    public void setJMSExpiration(long l) throws JMSException {
        this._deliveryProps.setExpiration(l);
    }

    @Override
    public boolean propertyExists(String propertyName) throws JMSException {
        return this.getApplicationHeaders().containsKey(propertyName);
    }

    @Override
    public boolean getBooleanProperty(String propertyName) throws JMSException {
        this.checkPropertyName(propertyName);
        Object o = this.getApplicationHeaders().get(propertyName);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            return Boolean.valueOf((String)o);
        }
        if (this.getApplicationHeaders().containsKey(propertyName)) {
            throw new MessageFormatException("getBooleanProperty(\"" + propertyName + "\") failed as value is not boolean: " + o);
        }
        return Boolean.valueOf(null);
    }

    @Override
    public byte getByteProperty(String propertyName) throws JMSException {
        this.checkPropertyName(propertyName);
        Map<String, Object> propertyMap = this.getApplicationHeaders();
        Object o = propertyMap.get(propertyName);
        if (o instanceof Byte) {
            return (Byte)o;
        }
        if (o instanceof String) {
            return Byte.valueOf((String)o);
        }
        if (this.getApplicationHeaders().containsKey(propertyName)) {
            throw new MessageFormatException("getByteProperty(\"" + propertyName + "\") failed as value is not a byte: " + o);
        }
        return Byte.valueOf(null);
    }

    @Override
    public short getShortProperty(String propertyName) throws JMSException {
        this.checkPropertyName(propertyName);
        Map<String, Object> propertyMap = this.getApplicationHeaders();
        Object o = propertyMap.get(propertyName);
        if (o instanceof Short) {
            return (Short)o;
        }
        if (o instanceof String) {
            return Short.valueOf((String)o);
        }
        try {
            return this.getByteProperty(propertyName);
        }
        catch (MessageFormatException e) {
            throw new MessageFormatException("getShortProperty(\"" + propertyName + "\") failed as value is not a short: " + o);
        }
    }

    @Override
    public int getIntProperty(String propertyName) throws JMSException {
        this.checkPropertyName(propertyName);
        Map<String, Object> propertyMap = this.getApplicationHeaders();
        Object o = propertyMap.get(propertyName);
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof String) {
            return Integer.valueOf((String)o);
        }
        try {
            return this.getShortProperty(propertyName);
        }
        catch (MessageFormatException e) {
            throw new MessageFormatException("getIntProperty(\"" + propertyName + "\") failed as value is not an int: " + o);
        }
    }

    @Override
    public long getLongProperty(String propertyName) throws JMSException {
        this.checkPropertyName(propertyName);
        Map<String, Object> propertyMap = this.getApplicationHeaders();
        Object o = propertyMap.get(propertyName);
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof String) {
            return Long.valueOf((String)o);
        }
        try {
            return this.getIntProperty(propertyName);
        }
        catch (MessageFormatException e) {
            throw new MessageFormatException("getLongProperty(\"" + propertyName + "\") failed as value is not a long: " + o);
        }
    }

    @Override
    public float getFloatProperty(String propertyName) throws JMSException {
        this.checkPropertyName(propertyName);
        Map<String, Object> propertyMap = this.getApplicationHeaders();
        Object o = propertyMap.get(propertyName);
        if (o instanceof Float) {
            return ((Float)o).floatValue();
        }
        if (o instanceof String) {
            return Float.valueOf((String)o).floatValue();
        }
        if (this.getApplicationHeaders().containsKey(propertyName)) {
            throw new MessageFormatException("getFloatProperty(\"" + propertyName + "\") failed as value is not a float: " + o);
        }
        throw new NullPointerException("No such property: " + propertyName);
    }

    @Override
    public double getDoubleProperty(String propertyName) throws JMSException {
        this.checkPropertyName(propertyName);
        Map<String, Object> propertyMap = this.getApplicationHeaders();
        Object o = propertyMap.get(propertyName);
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof String) {
            return Double.valueOf((String)o);
        }
        try {
            return this.getFloatProperty(propertyName);
        }
        catch (MessageFormatException e) {
            throw new MessageFormatException("getDoubleProperty(\"" + propertyName + "\") failed as value is not a double: " + o);
        }
    }

    @Override
    public String getStringProperty(String propertyName) throws JMSException {
        if (propertyName.equals(CustomJMSXProperty.JMSXUserID.toString())) {
            return new String(this._messageProps.getUserId());
        }
        if ("x-amqp-0-10.app-id".equals(propertyName) && this._messageProps.getAppId() != null) {
            return new String(this._messageProps.getAppId());
        }
        if ("x-amqp-0-10.routing-key".equals(propertyName) && this._deliveryProps.getRoutingKey() != null) {
            return this._deliveryProps.getRoutingKey();
        }
        if (this.isStrictJMS && "qpid.subject".equals(propertyName)) {
            return (String)this.getApplicationHeaders().get("JMS_qpid_subject");
        }
        this.checkPropertyName(propertyName);
        Map<String, Object> propertyMap = this.getApplicationHeaders();
        Object o = propertyMap.get(propertyName);
        if (o instanceof String) {
            return (String)o;
        }
        if (o == null) {
            return null;
        }
        if (o.getClass().isArray()) {
            throw new MessageFormatException("getString(\"" + propertyName + "\") failed as value of type " + o.getClass() + " is an array.");
        }
        return String.valueOf(o);
    }

    @Override
    public Object getObjectProperty(String propertyName) throws JMSException {
        this.checkPropertyName(propertyName);
        Map<String, Object> propertyMap = this.getApplicationHeaders();
        return propertyMap.get(propertyName);
    }

    @Override
    public Enumeration getPropertyNames() throws JMSException {
        ArrayList<String> props = new ArrayList<String>();
        Map<String, Object> propertyMap = this.getApplicationHeaders();
        for (String prop : this.getApplicationHeaders().keySet()) {
            Object value = propertyMap.get(prop);
            if (!(value instanceof Boolean) && !(value instanceof Number) && !(value instanceof String)) continue;
            props.add(prop);
        }
        return Collections.enumeration(props);
    }

    @Override
    public void setBooleanProperty(String propertyName, boolean b) throws JMSException {
        this.checkPropertyName(propertyName);
        this.checkWritableProperties();
        this.setApplicationHeader(propertyName, b);
    }

    @Override
    public void setByteProperty(String propertyName, byte b) throws JMSException {
        this.checkPropertyName(propertyName);
        this.checkWritableProperties();
        this.setApplicationHeader(propertyName, b);
    }

    @Override
    public void setShortProperty(String propertyName, short i) throws JMSException {
        this.checkPropertyName(propertyName);
        this.checkWritableProperties();
        this.setApplicationHeader(propertyName, i);
    }

    @Override
    public void setIntProperty(String propertyName, int i) throws JMSException {
        this.checkPropertyName(propertyName);
        this.checkWritableProperties();
        this.setApplicationHeader(propertyName, i);
    }

    @Override
    public void setLongProperty(String propertyName, long l) throws JMSException {
        this.checkPropertyName(propertyName);
        this.checkWritableProperties();
        this.setApplicationHeader(propertyName, l);
    }

    @Override
    public void setFloatProperty(String propertyName, float f) throws JMSException {
        this.checkPropertyName(propertyName);
        this.checkWritableProperties();
        this.setApplicationHeader(propertyName, Float.valueOf(f));
    }

    @Override
    public void setDoubleProperty(String propertyName, double v) throws JMSException {
        this.checkPropertyName(propertyName);
        this.checkWritableProperties();
        this.setApplicationHeader(propertyName, v);
    }

    @Override
    public void setStringProperty(String propertyName, String value) throws JMSException {
        this.checkPropertyName(propertyName);
        this.checkWritableProperties();
        if ("x-amqp-0-10.app-id".equals(propertyName)) {
            this._messageProps.setAppId(value.getBytes());
        } else {
            this.setApplicationHeader(propertyName, value);
        }
    }

    @Override
    public void setObjectProperty(String propertyName, Object object) throws JMSException {
        this.checkPropertyName(propertyName);
        this.checkWritableProperties();
        if (object == null) {
            throw new MessageFormatException("Only Primitive objects allowed. Object is: null");
        }
        if (!ALLOWED.contains(object.getClass())) {
            throw new MessageFormatException("Only Primitive objects allowed. Object is: " + object.getClass());
        }
        this.setApplicationHeader(propertyName, object);
    }

    private void setApplicationHeader(String propertyName, Object object) {
        HashMap<String, Object> headers = this._messageProps.getApplicationHeaders();
        if (headers == null) {
            headers = new HashMap<String, Object>();
            this._messageProps.setApplicationHeaders(headers);
        }
        headers.put(propertyName, object);
    }

    @Override
    public void removeProperty(String propertyName) throws JMSException {
        Map headers = this._messageProps.getApplicationHeaders();
        if (headers != null) {
            headers.remove(propertyName);
        }
    }

    protected void checkWritableProperties() throws MessageNotWriteableException {
        if (this._readableProperties) {
            throw new MessageNotWriteableException("You need to call clearProperties() to make the message writable");
        }
    }

    @Override
    public int getJMSPriority() throws JMSException {
        MessageDeliveryPriority messageDeliveryPriority = this._deliveryProps.getPriority();
        return messageDeliveryPriority == null ? 4 : (int)messageDeliveryPriority.getValue();
    }

    @Override
    public void setJMSPriority(int i) throws JMSException {
        this._deliveryProps.setPriority(MessageDeliveryPriority.get((short)((short)i)));
    }

    @Override
    public void clearProperties() throws JMSException {
        if (!this.getApplicationHeaders().isEmpty()) {
            this.getApplicationHeaders().clear();
        }
        this._readableProperties = false;
    }

    protected void checkPropertyName(CharSequence propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException("Property name must not be null");
        }
        if (propertyName.length() == 0) {
            throw new IllegalArgumentException("Property name must not be the empty string");
        }
        this.checkIdentiferFormat(propertyName);
    }

    protected void checkIdentiferFormat(CharSequence propertyName) {
        if (this.isStrictJMS) {
            if (!Character.isJavaIdentifierStart(propertyName.charAt(0))) {
                throw new IllegalArgumentException("Identifier '" + propertyName + "' does not start with a valid JMS identifier start character");
            }
            int length = propertyName.length();
            for (int c = 1; c < length; ++c) {
                if (Character.isJavaIdentifierPart(propertyName.charAt(c))) continue;
                throw new IllegalArgumentException("Identifier '" + propertyName + "' contains an invalid JMS identifier character");
            }
            if (propertyName.equals("NULL") || propertyName.equals("TRUE") || propertyName.equals("FALSE") || propertyName.equals("NOT") || propertyName.equals("AND") || propertyName.equals("OR") || propertyName.equals("BETWEEN") || propertyName.equals("LIKE") || propertyName.equals("IN") || propertyName.equals("IS") || propertyName.equals("ESCAPE")) {
                throw new IllegalArgumentException("Identifier '" + propertyName + "' is not allowed in JMS");
            }
        }
    }

    public MessageProperties getMessageProperties() {
        return this._messageProps;
    }

    public DeliveryProperties getDeliveryProperties() {
        return this._deliveryProps;
    }

    static {
        ALLOWED.add(Boolean.class);
        ALLOWED.add(Byte.class);
        ALLOWED.add(Short.class);
        ALLOWED.add(Integer.class);
        ALLOWED.add(Long.class);
        ALLOWED.add(Float.class);
        ALLOWED.add(Double.class);
        ALLOWED.add(Character.class);
        ALLOWED.add(String.class);
        ALLOWED.add(byte[].class);
    }
}

