/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jndi;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.apache.qpid.client.AMQConnectionFactory;
import org.apache.qpid.client.AMQDestination;
import org.apache.qpid.client.AMQHeadersExchange;
import org.apache.qpid.client.AMQQueue;
import org.apache.qpid.client.AMQTopic;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.jndi.ReadOnlyContext;
import org.apache.qpid.url.BindingURL;
import org.apache.qpid.url.URLSyntaxException;
import org.apache.qpid.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesFileInitialContextFactory
implements InitialContextFactory {
    private final Logger _logger = LoggerFactory.getLogger(PropertiesFileInitialContextFactory.class);
    private String CONNECTION_FACTORY_PREFIX = "connectionfactory.";
    private String DESTINATION_PREFIX = "destination.";
    private String QUEUE_PREFIX = "queue.";
    private String TOPIC_PREFIX = "topic.";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Context getInitialContext(Hashtable environment) throws NamingException {
        ConcurrentHashMap data = new ConcurrentHashMap();
        BufferedInputStream inputStream = null;
        try {
            String fileName;
            String string = fileName = environment.containsKey("java.naming.provider.url") ? (String)environment.get("java.naming.provider.url") : System.getProperty("java.naming.provider.url");
            if (fileName != null) {
                this._logger.info("Attempting to load " + fileName);
                inputStream = new BufferedInputStream(new FileInputStream(fileName.contains("file:") ? new File(new URI(fileName)) : new File(fileName)));
                Properties p = new Properties();
                p.load(inputStream);
                Strings.ChainedResolver resolver = new Strings.ChainedResolver(Strings.SYSTEM_RESOLVER, (Strings.Resolver)new Strings.PropertiesResolver(p));
                for (Map.Entry<Object, Object> me : p.entrySet()) {
                    String key = (String)me.getKey();
                    String value = (String)me.getValue();
                    String expanded = Strings.expand((String)value, (Strings.Resolver)resolver);
                    environment.put(key, expanded);
                    if (System.getProperty(key) != null) continue;
                    System.setProperty(key, expanded);
                }
                this._logger.info("Loaded Context Properties:" + environment.toString());
            } else {
                this._logger.info("No Provider URL specified.");
            }
        }
        catch (IOException ioe) {
            this._logger.warn("Unable to load property file specified in Provider_URL:" + environment.get("java.naming.provider.url") + "\n" + "Due to:" + ioe.getMessage());
        }
        catch (URISyntaxException uoe) {
            this._logger.warn("Unable to load property file specified in Provider_URL:" + environment.get("java.naming.provider.url") + "\n" + "Due to:" + uoe.getMessage());
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception ignore) {}
        }
        this.createConnectionFactories(data, environment);
        this.createDestinations(data, environment);
        this.createQueues(data, environment);
        this.createTopics(data, environment);
        return this.createContext(data, environment);
    }

    protected ReadOnlyContext createContext(Map data, Hashtable environment) {
        return new ReadOnlyContext(environment, data);
    }

    protected void createConnectionFactories(Map data, Hashtable environment) throws ConfigurationException {
        for (Map.Entry entry : environment.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith(this.CONNECTION_FACTORY_PREFIX)) continue;
            String jndiName = key.substring(this.CONNECTION_FACTORY_PREFIX.length());
            ConnectionFactory cf = this.createFactory(entry.getValue().toString().trim());
            if (cf == null) continue;
            data.put(jndiName, cf);
        }
    }

    protected void createDestinations(Map data, Hashtable environment) throws ConfigurationException {
        for (Map.Entry entry : environment.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith(this.DESTINATION_PREFIX)) continue;
            String jndiName = key.substring(this.DESTINATION_PREFIX.length());
            Destination dest = this.createDestination(entry.getValue().toString().trim());
            if (dest == null) continue;
            data.put(jndiName, dest);
        }
    }

    protected void createQueues(Map data, Hashtable environment) {
        for (Map.Entry entry : environment.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith(this.QUEUE_PREFIX)) continue;
            String jndiName = key.substring(this.QUEUE_PREFIX.length());
            Queue q = this.createQueue(entry.getValue().toString().trim());
            if (q == null) continue;
            data.put(jndiName, q);
        }
    }

    protected void createTopics(Map data, Hashtable environment) {
        for (Map.Entry entry : environment.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith(this.TOPIC_PREFIX)) continue;
            String jndiName = key.substring(this.TOPIC_PREFIX.length());
            Topic t = this.createTopic(entry.getValue().toString().trim());
            if (t == null) continue;
            if (this._logger.isDebugEnabled()) {
                StringBuffer b = new StringBuffer();
                b.append("Creating the topic: " + jndiName + " with the following binding keys ");
                for (AMQShortString binding : ((AMQTopic)t).getBindingKeys()) {
                    b.append(binding.toString()).append(",");
                }
                this._logger.debug(b.toString());
            }
            data.put(jndiName, t);
        }
    }

    protected ConnectionFactory createFactory(String url) throws ConfigurationException {
        try {
            return new AMQConnectionFactory(url);
        }
        catch (URLSyntaxException urlse) {
            this._logger.warn("Unable to create factory:" + (Object)((Object)urlse));
            ConfigurationException ex = new ConfigurationException("Failed to parse entry: " + (Object)((Object)urlse) + " due to : " + urlse.getMessage());
            ex.initCause(urlse);
            throw ex;
        }
    }

    protected Destination createDestination(String str) throws ConfigurationException {
        try {
            return AMQDestination.createDestination(str);
        }
        catch (Exception e) {
            this._logger.warn("Unable to create destination:" + e, (Throwable)e);
            ConfigurationException ex = new ConfigurationException("Failed to parse entry: " + str + " due to : " + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    protected Queue createQueue(Object value) {
        if (value instanceof AMQShortString) {
            return new AMQQueue(AMQShortString.valueOf((String)"amq.direct"), (AMQShortString)value);
        }
        if (value instanceof String) {
            return new AMQQueue(AMQShortString.valueOf((String)"amq.direct"), new AMQShortString((String)value));
        }
        if (value instanceof BindingURL) {
            return new AMQQueue((BindingURL)value);
        }
        return null;
    }

    protected Topic createTopic(Object value) {
        if (value instanceof AMQShortString) {
            return new AMQTopic(AMQShortString.valueOf((String)"amq.topic"), (AMQShortString)value);
        }
        if (value instanceof String) {
            String[] keys = ((String)value).split(",");
            AMQShortString[] bindings = new AMQShortString[keys.length];
            int i = 0;
            for (String key : keys) {
                bindings[i] = new AMQShortString(key.trim());
                ++i;
            }
            return new AMQTopic(AMQShortString.valueOf((String)"amq.topic"), bindings[0], null, bindings);
        }
        if (value instanceof BindingURL) {
            return new AMQTopic((BindingURL)value);
        }
        return null;
    }

    protected Destination createHeaderExchange(Object value) {
        if (value instanceof String) {
            return new AMQHeadersExchange((String)value);
        }
        if (value instanceof BindingURL) {
            return new AMQHeadersExchange((BindingURL)value);
        }
        return null;
    }

    public String getConnectionPrefix() {
        return this.CONNECTION_FACTORY_PREFIX;
    }

    public void setConnectionPrefix(String connectionPrefix) {
        this.CONNECTION_FACTORY_PREFIX = connectionPrefix;
    }

    public String getDestinationPrefix() {
        return this.DESTINATION_PREFIX;
    }

    public void setDestinationPrefix(String destinationPrefix) {
        this.DESTINATION_PREFIX = destinationPrefix;
    }

    public String getQueuePrefix() {
        return this.QUEUE_PREFIX;
    }

    public void setQueuePrefix(String queuePrefix) {
        this.QUEUE_PREFIX = queuePrefix;
    }

    public String getTopicPrefix() {
        return this.TOPIC_PREFIX;
    }

    public void setTopicPrefix(String topicPrefix) {
        this.TOPIC_PREFIX = topicPrefix;
    }
}

