/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.qpid.client.url.URLParser;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.jms.BrokerDetails;
import org.apache.qpid.jms.ConnectionURL;
import org.apache.qpid.url.URLHelper;
import org.apache.qpid.url.URLSyntaxException;

public class AMQConnectionURL
implements ConnectionURL,
Serializable {
    private static final long serialVersionUID = -5102704772070465832L;
    private String _url;
    private String _failoverMethod;
    private Map<String, String> _failoverOptions;
    private Map<String, String> _options;
    private List<BrokerDetails> _brokers;
    private String _clientName;
    private String _username;
    private String _password;
    private String _virtualHost;
    private String _defaultQueueExchangeName;
    private String _defaultTopicExchangeName;
    private String _temporaryTopicExchangeName;
    private String _temporaryQueueExchangeName;

    public AMQConnectionURL(String fullURL) throws URLSyntaxException {
        if (fullURL == null) {
            throw new IllegalArgumentException("URL cannot be null");
        }
        this._url = fullURL;
        this._options = new HashMap<String, String>();
        this._brokers = new LinkedList<BrokerDetails>();
        this._failoverOptions = new HashMap<String, String>();
        new URLParser(this);
    }

    @Override
    public String getURL() {
        return this._url;
    }

    public Map<String, String> getOptions() {
        return this._options;
    }

    @Override
    public String getFailoverMethod() {
        return this._failoverMethod;
    }

    public void setFailoverMethod(String failoverMethod) {
        this._failoverMethod = failoverMethod;
    }

    public Map<String, String> getFailoverOptions() {
        return this._failoverOptions;
    }

    @Override
    public String getFailoverOption(String key) {
        return this._failoverOptions.get(key);
    }

    public void setFailoverOption(String key, String value) {
        this._failoverOptions.put(key, value);
    }

    @Override
    public int getBrokerCount() {
        return this._brokers.size();
    }

    @Override
    public BrokerDetails getBrokerDetails(int index) {
        if (index < this._brokers.size()) {
            return this._brokers.get(index);
        }
        return null;
    }

    @Override
    public void addBrokerDetails(BrokerDetails broker) {
        if (!this._brokers.contains(broker)) {
            this._brokers.add(broker);
        }
    }

    @Override
    public void setBrokerDetails(List<BrokerDetails> brokers) {
        this._brokers = brokers;
    }

    @Override
    public List<BrokerDetails> getAllBrokerDetails() {
        return this._brokers;
    }

    @Override
    public String getClientName() {
        return this._clientName;
    }

    @Override
    public void setClientName(String clientName) {
        this._clientName = clientName;
    }

    @Override
    public String getUsername() {
        return this._username;
    }

    @Override
    public void setUsername(String username) {
        this._username = username;
    }

    @Override
    public String getPassword() {
        return this._password;
    }

    @Override
    public void setPassword(String password) {
        this._password = password;
    }

    @Override
    public String getVirtualHost() {
        return this._virtualHost;
    }

    @Override
    public void setVirtualHost(String virtuaHost) {
        this._virtualHost = virtuaHost;
    }

    @Override
    public String getOption(String key) {
        return this._options.get(key);
    }

    @Override
    public void setOption(String key, String value) {
        this._options.put(key, value);
    }

    @Override
    public AMQShortString getDefaultQueueExchangeName() {
        return this._defaultQueueExchangeName == null ? null : new AMQShortString(this._defaultQueueExchangeName);
    }

    public void setDefaultQueueExchangeName(AMQShortString defaultQueueExchangeName) {
        this._defaultQueueExchangeName = defaultQueueExchangeName == null ? null : defaultQueueExchangeName.asString();
    }

    @Override
    public AMQShortString getDefaultTopicExchangeName() {
        return this._defaultTopicExchangeName == null ? null : new AMQShortString(this._defaultTopicExchangeName);
    }

    public void setDefaultTopicExchangeName(AMQShortString defaultTopicExchangeName) {
        this._defaultTopicExchangeName = defaultTopicExchangeName == null ? null : defaultTopicExchangeName.asString();
    }

    @Override
    public AMQShortString getTemporaryQueueExchangeName() {
        return this._temporaryQueueExchangeName == null ? null : new AMQShortString(this._temporaryQueueExchangeName);
    }

    public void setTemporaryQueueExchangeName(AMQShortString temporaryQueueExchangeName) {
        this._temporaryQueueExchangeName = temporaryQueueExchangeName == null ? null : temporaryQueueExchangeName.asString();
    }

    @Override
    public AMQShortString getTemporaryTopicExchangeName() {
        return this._temporaryTopicExchangeName == null ? null : new AMQShortString(this._temporaryTopicExchangeName);
    }

    public void setTemporaryTopicExchangeName(AMQShortString temporaryTopicExchangeName) {
        this._temporaryTopicExchangeName = temporaryTopicExchangeName == null ? null : temporaryTopicExchangeName.asString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AMQConnectionURL that = (AMQConnectionURL)o;
        if (this._brokers != null ? !this._brokers.equals(that._brokers) : that._brokers != null) {
            return false;
        }
        if (this._clientName != null ? !this._clientName.equals(that._clientName) : that._clientName != null) {
            return false;
        }
        if (this._defaultQueueExchangeName != null ? !this._defaultQueueExchangeName.equals(that._defaultQueueExchangeName) : that._defaultQueueExchangeName != null) {
            return false;
        }
        if (this._defaultTopicExchangeName != null ? !this._defaultTopicExchangeName.equals(that._defaultTopicExchangeName) : that._defaultTopicExchangeName != null) {
            return false;
        }
        if (this._failoverMethod != null ? !this._failoverMethod.equals(that._failoverMethod) : that._failoverMethod != null) {
            return false;
        }
        if (this._failoverOptions != null ? !this._failoverOptions.equals(that._failoverOptions) : that._failoverOptions != null) {
            return false;
        }
        if (this._options != null ? !this._options.equals(that._options) : that._options != null) {
            return false;
        }
        if (this._password != null ? !this._password.equals(that._password) : that._password != null) {
            return false;
        }
        if (this._temporaryQueueExchangeName != null ? !this._temporaryQueueExchangeName.equals(that._temporaryQueueExchangeName) : that._temporaryQueueExchangeName != null) {
            return false;
        }
        if (this._temporaryTopicExchangeName != null ? !this._temporaryTopicExchangeName.equals(that._temporaryTopicExchangeName) : that._temporaryTopicExchangeName != null) {
            return false;
        }
        if (this._url != null ? !this._url.equals(that._url) : that._url != null) {
            return false;
        }
        if (this._username != null ? !this._username.equals(that._username) : that._username != null) {
            return false;
        }
        return !(this._virtualHost != null ? !this._virtualHost.equals(that._virtualHost) : that._virtualHost != null);
    }

    public int hashCode() {
        int result = this._url != null ? this._url.hashCode() : 0;
        result = 31 * result + (this._failoverMethod != null ? this._failoverMethod.hashCode() : 0);
        result = 31 * result + (this._failoverOptions != null ? this._failoverOptions.hashCode() : 0);
        result = 31 * result + (this._options != null ? this._options.hashCode() : 0);
        result = 31 * result + (this._brokers != null ? this._brokers.hashCode() : 0);
        result = 31 * result + (this._clientName != null ? this._clientName.hashCode() : 0);
        result = 31 * result + (this._username != null ? this._username.hashCode() : 0);
        result = 31 * result + (this._password != null ? this._password.hashCode() : 0);
        result = 31 * result + (this._virtualHost != null ? this._virtualHost.hashCode() : 0);
        result = 31 * result + (this._defaultQueueExchangeName != null ? this._defaultQueueExchangeName.hashCode() : 0);
        result = 31 * result + (this._defaultTopicExchangeName != null ? this._defaultTopicExchangeName.hashCode() : 0);
        result = 31 * result + (this._temporaryTopicExchangeName != null ? this._temporaryTopicExchangeName.hashCode() : 0);
        result = 31 * result + (this._temporaryQueueExchangeName != null ? this._temporaryQueueExchangeName.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("amqp");
        sb.append("://");
        if (this._username != null) {
            sb.append(this._username);
            if (this._password != null) {
                sb.append(':');
                sb.append("********");
            }
            sb.append('@');
        }
        sb.append(this._clientName);
        sb.append(this._virtualHost);
        sb.append(this.optionsToString());
        return sb.toString();
    }

    private String optionsToString() {
        StringBuffer sb = new StringBuffer("?");
        if (!this._options.isEmpty()) {
            for (Map.Entry<String, String> option : this._options.entrySet()) {
                sb.append(option.getKey()).append("='").append(option.getValue()).append("'");
                sb.append('&');
            }
        }
        sb.append("brokerlist").append("='");
        for (BrokerDetails service : this._brokers) {
            sb.append(service.toString());
            sb.append(';');
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("'");
        if (this._failoverMethod != null) {
            sb.append('&');
            sb.append("failover");
            sb.append("='");
            sb.append(this._failoverMethod);
            sb.append(URLHelper.printOptions(this._failoverOptions));
            sb.append("'");
        }
        return sb.toString();
    }
}

