/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.handler;

import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.AMQException;
import org.apache.qpid.client.handler.BasicCancelOkMethodHandler;
import org.apache.qpid.client.handler.BasicDeliverMethodHandler;
import org.apache.qpid.client.handler.BasicReturnMethodHandler;
import org.apache.qpid.client.handler.ChannelCloseMethodHandler;
import org.apache.qpid.client.handler.ChannelCloseOkMethodHandler;
import org.apache.qpid.client.handler.ChannelFlowMethodHandler;
import org.apache.qpid.client.handler.ChannelFlowOkMethodHandler;
import org.apache.qpid.client.handler.ClientMethodDispatcherImpl_0_9;
import org.apache.qpid.client.handler.ClientMethodDispatcherImpl_0_91;
import org.apache.qpid.client.handler.ClientMethodDispatcherImpl_8_0;
import org.apache.qpid.client.handler.ConnectionCloseMethodHandler;
import org.apache.qpid.client.handler.ConnectionOpenOkMethodHandler;
import org.apache.qpid.client.handler.ConnectionRedirectMethodHandler;
import org.apache.qpid.client.handler.ConnectionSecureMethodHandler;
import org.apache.qpid.client.handler.ConnectionStartMethodHandler;
import org.apache.qpid.client.handler.ConnectionTuneMethodHandler;
import org.apache.qpid.client.handler.ExchangeBoundOkMethodHandler;
import org.apache.qpid.client.handler.QueueDeleteOkMethodHandler;
import org.apache.qpid.client.protocol.AMQProtocolSession;
import org.apache.qpid.client.state.AMQMethodNotImplementedException;
import org.apache.qpid.client.state.AMQStateManager;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AccessRequestBody;
import org.apache.qpid.framing.AccessRequestOkBody;
import org.apache.qpid.framing.BasicAckBody;
import org.apache.qpid.framing.BasicCancelBody;
import org.apache.qpid.framing.BasicCancelOkBody;
import org.apache.qpid.framing.BasicConsumeBody;
import org.apache.qpid.framing.BasicConsumeOkBody;
import org.apache.qpid.framing.BasicDeliverBody;
import org.apache.qpid.framing.BasicGetBody;
import org.apache.qpid.framing.BasicGetEmptyBody;
import org.apache.qpid.framing.BasicGetOkBody;
import org.apache.qpid.framing.BasicPublishBody;
import org.apache.qpid.framing.BasicQosBody;
import org.apache.qpid.framing.BasicQosOkBody;
import org.apache.qpid.framing.BasicRecoverBody;
import org.apache.qpid.framing.BasicRejectBody;
import org.apache.qpid.framing.BasicReturnBody;
import org.apache.qpid.framing.ChannelCloseBody;
import org.apache.qpid.framing.ChannelCloseOkBody;
import org.apache.qpid.framing.ChannelFlowBody;
import org.apache.qpid.framing.ChannelFlowOkBody;
import org.apache.qpid.framing.ChannelOpenBody;
import org.apache.qpid.framing.ChannelOpenOkBody;
import org.apache.qpid.framing.ConnectionCloseBody;
import org.apache.qpid.framing.ConnectionCloseOkBody;
import org.apache.qpid.framing.ConnectionOpenBody;
import org.apache.qpid.framing.ConnectionOpenOkBody;
import org.apache.qpid.framing.ConnectionRedirectBody;
import org.apache.qpid.framing.ConnectionSecureBody;
import org.apache.qpid.framing.ConnectionSecureOkBody;
import org.apache.qpid.framing.ConnectionStartBody;
import org.apache.qpid.framing.ConnectionStartOkBody;
import org.apache.qpid.framing.ConnectionTuneBody;
import org.apache.qpid.framing.ConnectionTuneOkBody;
import org.apache.qpid.framing.DtxSelectBody;
import org.apache.qpid.framing.DtxSelectOkBody;
import org.apache.qpid.framing.DtxStartBody;
import org.apache.qpid.framing.DtxStartOkBody;
import org.apache.qpid.framing.ExchangeBoundBody;
import org.apache.qpid.framing.ExchangeBoundOkBody;
import org.apache.qpid.framing.ExchangeDeclareBody;
import org.apache.qpid.framing.ExchangeDeclareOkBody;
import org.apache.qpid.framing.ExchangeDeleteBody;
import org.apache.qpid.framing.ExchangeDeleteOkBody;
import org.apache.qpid.framing.FileAckBody;
import org.apache.qpid.framing.FileCancelBody;
import org.apache.qpid.framing.FileCancelOkBody;
import org.apache.qpid.framing.FileConsumeBody;
import org.apache.qpid.framing.FileConsumeOkBody;
import org.apache.qpid.framing.FileDeliverBody;
import org.apache.qpid.framing.FileOpenBody;
import org.apache.qpid.framing.FileOpenOkBody;
import org.apache.qpid.framing.FilePublishBody;
import org.apache.qpid.framing.FileQosBody;
import org.apache.qpid.framing.FileQosOkBody;
import org.apache.qpid.framing.FileRejectBody;
import org.apache.qpid.framing.FileReturnBody;
import org.apache.qpid.framing.FileStageBody;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.ProtocolVersion;
import org.apache.qpid.framing.QueueBindBody;
import org.apache.qpid.framing.QueueBindOkBody;
import org.apache.qpid.framing.QueueDeclareBody;
import org.apache.qpid.framing.QueueDeclareOkBody;
import org.apache.qpid.framing.QueueDeleteBody;
import org.apache.qpid.framing.QueueDeleteOkBody;
import org.apache.qpid.framing.QueuePurgeBody;
import org.apache.qpid.framing.QueuePurgeOkBody;
import org.apache.qpid.framing.StreamCancelBody;
import org.apache.qpid.framing.StreamCancelOkBody;
import org.apache.qpid.framing.StreamConsumeBody;
import org.apache.qpid.framing.StreamConsumeOkBody;
import org.apache.qpid.framing.StreamDeliverBody;
import org.apache.qpid.framing.StreamPublishBody;
import org.apache.qpid.framing.StreamQosBody;
import org.apache.qpid.framing.StreamQosOkBody;
import org.apache.qpid.framing.StreamReturnBody;
import org.apache.qpid.framing.TunnelRequestBody;
import org.apache.qpid.framing.TxCommitBody;
import org.apache.qpid.framing.TxCommitOkBody;
import org.apache.qpid.framing.TxRollbackBody;
import org.apache.qpid.framing.TxRollbackOkBody;
import org.apache.qpid.framing.TxSelectBody;
import org.apache.qpid.framing.TxSelectOkBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientMethodDispatcherImpl
implements MethodDispatcher {
    private static final BasicCancelOkMethodHandler _basicCancelOkMethodHandler = BasicCancelOkMethodHandler.getInstance();
    private static final BasicDeliverMethodHandler _basicDeliverMethodHandler = BasicDeliverMethodHandler.getInstance();
    private static final BasicReturnMethodHandler _basicReturnMethodHandler = BasicReturnMethodHandler.getInstance();
    private static final ChannelCloseMethodHandler _channelCloseMethodHandler = ChannelCloseMethodHandler.getInstance();
    private static final ChannelCloseOkMethodHandler _channelCloseOkMethodHandler = ChannelCloseOkMethodHandler.getInstance();
    private static final ChannelFlowOkMethodHandler _channelFlowOkMethodHandler = ChannelFlowOkMethodHandler.getInstance();
    private static final ChannelFlowMethodHandler _channelFlowMethodHandler = ChannelFlowMethodHandler.getInstance();
    private static final ConnectionCloseMethodHandler _connectionCloseMethodHandler = ConnectionCloseMethodHandler.getInstance();
    private static final ConnectionOpenOkMethodHandler _connectionOpenOkMethodHandler = ConnectionOpenOkMethodHandler.getInstance();
    private static final ConnectionRedirectMethodHandler _connectionRedirectMethodHandler = ConnectionRedirectMethodHandler.getInstance();
    private static final ConnectionSecureMethodHandler _connectionSecureMethodHandler = ConnectionSecureMethodHandler.getInstance();
    private static final ConnectionStartMethodHandler _connectionStartMethodHandler = ConnectionStartMethodHandler.getInstance();
    private static final ConnectionTuneMethodHandler _connectionTuneMethodHandler = ConnectionTuneMethodHandler.getInstance();
    private static final ExchangeBoundOkMethodHandler _exchangeBoundOkMethodHandler = ExchangeBoundOkMethodHandler.getInstance();
    private static final QueueDeleteOkMethodHandler _queueDeleteOkMethodHandler = QueueDeleteOkMethodHandler.getInstance();
    private static final Logger _logger = LoggerFactory.getLogger(ClientMethodDispatcherImpl.class);
    private static final Map<ProtocolVersion, DispatcherFactory> _dispatcherFactories = new HashMap<ProtocolVersion, DispatcherFactory>();
    private AMQProtocolSession _session;

    public static ClientMethodDispatcherImpl newMethodDispatcher(ProtocolVersion version, AMQProtocolSession session) {
        DispatcherFactory factory;
        if (_logger.isDebugEnabled()) {
            _logger.debug("New Method Dispatcher:" + session);
        }
        if ((factory = _dispatcherFactories.get(version)) == null) {
            throw new UnsupportedOperationException("The protocol version " + version + " is not supported");
        }
        return factory.createMethodDispatcher(session);
    }

    public ClientMethodDispatcherImpl(AMQProtocolSession session) {
        this._session = session;
    }

    public AMQStateManager getStateManager() {
        return this._session.getStateManager();
    }

    public boolean dispatchAccessRequestOk(AccessRequestOkBody body, int channelId) throws AMQException {
        return false;
    }

    public boolean dispatchBasicCancelOk(BasicCancelOkBody body, int channelId) throws AMQException {
        _basicCancelOkMethodHandler.methodReceived(this._session, body, channelId);
        return true;
    }

    public boolean dispatchBasicConsumeOk(BasicConsumeOkBody body, int channelId) throws AMQException {
        return false;
    }

    public boolean dispatchBasicDeliver(BasicDeliverBody body, int channelId) throws AMQException {
        _basicDeliverMethodHandler.methodReceived(this._session, body, channelId);
        return true;
    }

    public boolean dispatchBasicGetEmpty(BasicGetEmptyBody body, int channelId) throws AMQException {
        return false;
    }

    public boolean dispatchBasicGetOk(BasicGetOkBody body, int channelId) throws AMQException {
        return false;
    }

    public boolean dispatchBasicQosOk(BasicQosOkBody body, int channelId) throws AMQException {
        return false;
    }

    public boolean dispatchBasicReturn(BasicReturnBody body, int channelId) throws AMQException {
        _basicReturnMethodHandler.methodReceived(this._session, body, channelId);
        return true;
    }

    public boolean dispatchChannelClose(ChannelCloseBody body, int channelId) throws AMQException {
        _channelCloseMethodHandler.methodReceived(this._session, body, channelId);
        return true;
    }

    public boolean dispatchChannelCloseOk(ChannelCloseOkBody body, int channelId) throws AMQException {
        _channelCloseOkMethodHandler.methodReceived(this._session, body, channelId);
        return true;
    }

    public boolean dispatchChannelFlow(ChannelFlowBody body, int channelId) throws AMQException {
        _channelFlowMethodHandler.methodReceived(this._session, body, channelId);
        return true;
    }

    public boolean dispatchChannelFlowOk(ChannelFlowOkBody body, int channelId) throws AMQException {
        _channelFlowOkMethodHandler.methodReceived(this._session, body, channelId);
        return true;
    }

    public boolean dispatchChannelOpenOk(ChannelOpenOkBody body, int channelId) throws AMQException {
        return false;
    }

    public boolean dispatchConnectionClose(ConnectionCloseBody body, int channelId) throws AMQException {
        _connectionCloseMethodHandler.methodReceived(this._session, body, channelId);
        return true;
    }

    public boolean dispatchConnectionCloseOk(ConnectionCloseOkBody body, int channelId) throws AMQException {
        return false;
    }

    public boolean dispatchConnectionOpenOk(ConnectionOpenOkBody body, int channelId) throws AMQException {
        _connectionOpenOkMethodHandler.methodReceived(this._session, body, channelId);
        return true;
    }

    public boolean dispatchConnectionRedirect(ConnectionRedirectBody body, int channelId) throws AMQException {
        _connectionRedirectMethodHandler.methodReceived(this._session, body, channelId);
        return true;
    }

    public boolean dispatchConnectionSecure(ConnectionSecureBody body, int channelId) throws AMQException {
        _connectionSecureMethodHandler.methodReceived(this._session, body, channelId);
        return true;
    }

    public boolean dispatchConnectionStart(ConnectionStartBody body, int channelId) throws AMQException {
        _connectionStartMethodHandler.methodReceived(this._session, body, channelId);
        return true;
    }

    public boolean dispatchConnectionTune(ConnectionTuneBody body, int channelId) throws AMQException {
        _connectionTuneMethodHandler.methodReceived(this._session, body, channelId);
        return true;
    }

    public boolean dispatchQueueDeleteOk(QueueDeleteOkBody body, int channelId) throws AMQException {
        _queueDeleteOkMethodHandler.methodReceived(this._session, body, channelId);
        return true;
    }

    public boolean dispatchQueuePurgeOk(QueuePurgeOkBody body, int channelId) throws AMQException {
        return false;
    }

    public boolean dispatchStreamCancelOk(StreamCancelOkBody body, int channelId) throws AMQException {
        return false;
    }

    public boolean dispatchStreamConsumeOk(StreamConsumeOkBody body, int channelId) throws AMQException {
        return false;
    }

    public boolean dispatchAccessRequest(AccessRequestBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchBasicAck(BasicAckBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchBasicCancel(BasicCancelBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchBasicConsume(BasicConsumeBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchBasicGet(BasicGetBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchBasicPublish(BasicPublishBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchBasicQos(BasicQosBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchBasicRecover(BasicRecoverBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchBasicReject(BasicRejectBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchChannelOpen(ChannelOpenBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchConnectionOpen(ConnectionOpenBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchConnectionSecureOk(ConnectionSecureOkBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchConnectionStartOk(ConnectionStartOkBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchConnectionTuneOk(ConnectionTuneOkBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchDtxSelect(DtxSelectBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchDtxStart(DtxStartBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchExchangeBound(ExchangeBoundBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchExchangeDeclare(ExchangeDeclareBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchExchangeDelete(ExchangeDeleteBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchFileAck(FileAckBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchFileCancel(FileCancelBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchFileConsume(FileConsumeBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchFilePublish(FilePublishBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchFileQos(FileQosBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchFileReject(FileRejectBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchQueueBind(QueueBindBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchQueueDeclare(QueueDeclareBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchQueueDelete(QueueDeleteBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchQueuePurge(QueuePurgeBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchStreamCancel(StreamCancelBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchStreamConsume(StreamConsumeBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchStreamPublish(StreamPublishBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchStreamQos(StreamQosBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchTunnelRequest(TunnelRequestBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchTxCommit(TxCommitBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchTxRollback(TxRollbackBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchTxSelect(TxSelectBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchDtxSelectOk(DtxSelectOkBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchDtxStartOk(DtxStartOkBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchExchangeBoundOk(ExchangeBoundOkBody body, int channelId) throws AMQException {
        _exchangeBoundOkMethodHandler.methodReceived(this._session, body, channelId);
        return true;
    }

    public boolean dispatchExchangeDeclareOk(ExchangeDeclareOkBody body, int channelId) throws AMQException {
        return false;
    }

    public boolean dispatchExchangeDeleteOk(ExchangeDeleteOkBody body, int channelId) throws AMQException {
        return false;
    }

    public boolean dispatchFileCancelOk(FileCancelOkBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchFileConsumeOk(FileConsumeOkBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchFileDeliver(FileDeliverBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchFileOpen(FileOpenBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchFileOpenOk(FileOpenOkBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchFileQosOk(FileQosOkBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchFileReturn(FileReturnBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchFileStage(FileStageBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchQueueBindOk(QueueBindOkBody body, int channelId) throws AMQException {
        return false;
    }

    public boolean dispatchQueueDeclareOk(QueueDeclareOkBody body, int channelId) throws AMQException {
        return false;
    }

    public boolean dispatchStreamDeliver(StreamDeliverBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchStreamQosOk(StreamQosOkBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchStreamReturn(StreamReturnBody body, int channelId) throws AMQException {
        throw new AMQMethodNotImplementedException((AMQMethodBody)body);
    }

    public boolean dispatchTxCommitOk(TxCommitOkBody body, int channelId) throws AMQException {
        return false;
    }

    public boolean dispatchTxRollbackOk(TxRollbackOkBody body, int channelId) throws AMQException {
        return false;
    }

    public boolean dispatchTxSelectOk(TxSelectOkBody body, int channelId) throws AMQException {
        return false;
    }

    static {
        _dispatcherFactories.put(ProtocolVersion.v8_0, new DispatcherFactory(){

            @Override
            public ClientMethodDispatcherImpl createMethodDispatcher(AMQProtocolSession session) {
                return new ClientMethodDispatcherImpl_8_0(session);
            }
        });
        _dispatcherFactories.put(ProtocolVersion.v0_9, new DispatcherFactory(){

            @Override
            public ClientMethodDispatcherImpl createMethodDispatcher(AMQProtocolSession session) {
                return new ClientMethodDispatcherImpl_0_9(session);
            }
        });
        _dispatcherFactories.put(ProtocolVersion.v0_91, new DispatcherFactory(){

            @Override
            public ClientMethodDispatcherImpl createMethodDispatcher(AMQProtocolSession session) {
                return new ClientMethodDispatcherImpl_0_91(session);
            }
        });
    }

    private static interface DispatcherFactory {
        public ClientMethodDispatcherImpl createMethodDispatcher(AMQProtocolSession var1);
    }
}

