/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.message;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.TextMessage;
import org.apache.qpid.AMQException;
import org.apache.qpid.client.CustomJMSXProperty;
import org.apache.qpid.client.message.AMQMessageDelegate;
import org.apache.qpid.client.message.AMQMessageDelegateFactory;
import org.apache.qpid.client.message.AbstractJMSMessage;

public class JMSTextMessage
extends AbstractJMSMessage
implements TextMessage {
    private static final String MIME_TYPE = "text/plain";
    private Exception _exception;
    private String _decodedValue;
    private static final String PAYLOAD_NULL_PROPERTY = CustomJMSXProperty.JMS_AMQP_NULL.toString();
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private CharsetDecoder _decoder = DEFAULT_CHARSET.newDecoder();
    private CharsetEncoder _encoder = DEFAULT_CHARSET.newEncoder();
    private static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.allocate(0);

    public JMSTextMessage(AMQMessageDelegateFactory delegateFactory) throws JMSException {
        super(delegateFactory, false);
    }

    JMSTextMessage(AMQMessageDelegate delegate, ByteBuffer data) throws AMQException {
        super(delegate, data != null);
        try {
            this._decodedValue = this.propertyExists(PAYLOAD_NULL_PROPERTY) ? null : this._decoder.decode(data).toString();
        }
        catch (CharacterCodingException e) {
            this._exception = e;
        }
        catch (JMSException e) {
            this._exception = e;
        }
    }

    @Override
    public String toBodyString() throws JMSException {
        return this.getText();
    }

    @Override
    protected String getMimeType() {
        return MIME_TYPE;
    }

    @Override
    public ByteBuffer getData() throws JMSException {
        this._encoder.reset();
        try {
            if (this._exception != null) {
                MessageFormatException messageFormatException = new MessageFormatException("Cannot decode original message");
                messageFormatException.setLinkedException(this._exception);
                throw messageFormatException;
            }
            if (this._decodedValue == null) {
                return EMPTY_BYTE_BUFFER;
            }
            return this._encoder.encode(CharBuffer.wrap(this._decodedValue));
        }
        catch (CharacterCodingException e) {
            JMSException jmsException = new JMSException("Cannot encode string in UFT-8: " + this._decodedValue);
            jmsException.setLinkedException((Exception)e);
            throw jmsException;
        }
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this._decodedValue = null;
        this._exception = null;
    }

    public void setText(String text) throws JMSException {
        this.checkWritable();
        this.clearBody();
        this._decodedValue = text;
    }

    public String getText() throws JMSException {
        return this._decodedValue;
    }

    @Override
    public void prepareForSending() throws JMSException {
        super.prepareForSending();
        if (this._decodedValue == null) {
            this.setBooleanProperty(PAYLOAD_NULL_PROPERTY, true);
        } else {
            this.removeProperty(PAYLOAD_NULL_PROPERTY);
        }
    }
}

