/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.qpid.AMQException;
import org.apache.qpid.AMQTimeoutException;
import org.apache.qpid.client.failover.FailoverException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BlockingWaiter<T> {
    private static final Logger _logger = LoggerFactory.getLogger(BlockingWaiter.class);
    private volatile boolean _ready = false;
    private volatile boolean _errorAck = false;
    private final ReentrantLock _lock = new ReentrantLock();
    private final Condition _receivedCondition = this._lock.newCondition();
    private final Condition _errorConditionAck = this._lock.newCondition();
    private volatile Exception _error;
    private Object _doneObject = null;
    private AtomicBoolean _waiting = new AtomicBoolean(false);
    private boolean _closed = false;

    public abstract boolean process(T var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean received(T object) {
        boolean ready = this.process(object);
        if (ready) {
            this._lock.lock();
            try {
                this._doneObject = object;
                this._ready = ready;
                this._receivedCondition.signal();
            }
            finally {
                this._lock.unlock();
            }
        }
        return ready;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object block(long timeout) throws AMQException, FailoverException {
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout must be zero or greater");
        }
        long nanoTimeout = TimeUnit.MILLISECONDS.toNanos(timeout);
        this._lock.lock();
        try {
            if (this._closed) {
                throw this.throwClosedException();
            }
            if (this._error == null) {
                this._waiting.set(true);
                while (!this._ready && this._error == null) {
                    try {
                        if ((nanoTimeout = this._receivedCondition.awaitNanos(nanoTimeout)) > 0L || this._ready || this._error != null) continue;
                        this._error = new AMQTimeoutException("Server did not respond in a timely fashion", null);
                        this._ready = true;
                    }
                    catch (InterruptedException e) {
                        _logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
            if (this._error != null) {
                if (this._error instanceof AMQException) {
                    throw (AMQException)((Object)this._error);
                }
                if (this._error instanceof FailoverException) {
                    throw (FailoverException)this._error;
                }
                throw new AMQException("Woken up due to " + this._error.getClass(), (Throwable)this._error);
            }
        }
        finally {
            this._waiting.set(false);
            if (this._error != null) {
                this._errorAck = true;
                this._errorConditionAck.signal();
                this._error = null;
            }
            this._lock.unlock();
        }
        return this._doneObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(Exception e) {
        this._lock.lock();
        try {
            if (this._closed) {
                return;
            }
            if (this._error == null) {
                this._error = e;
            } else {
                _logger.error("WARNING: new error '" + (e == null ? "null" : e.getMessage()) + "' arrived while old one not yet processed:" + this._error.getMessage());
            }
            if (this._waiting.get()) {
                this._ready = true;
                this._receivedCondition.signal();
                while (!this._errorAck) {
                    try {
                        this._errorConditionAck.await();
                    }
                    catch (InterruptedException e1) {
                        _logger.error(e1.getMessage(), (Throwable)e1);
                    }
                }
                this._errorAck = false;
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this._lock.lock();
        try {
            if (this._closed) {
                return;
            }
            this._closed = true;
            if (this._waiting.get()) {
                this.error((Exception)((Object)this.throwClosedException()));
            }
            if (!this._errorAck) {
                this._errorAck = true;
                this._errorConditionAck.signal();
                this._error = null;
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    private AMQException throwClosedException() {
        return new AMQException(null, "Waiter was closed.", null);
    }
}

