/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;

public abstract class Closeable {
    private final AtomicBoolean _closed = new AtomicBoolean(false);
    private final AtomicBoolean _closing = new AtomicBoolean(false);

    protected void checkNotClosed() throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException("Object " + this.toString() + " has been closed");
        }
    }

    public boolean isClosed() {
        return this._closed.get();
    }

    public boolean isClosing() {
        return this._closing.get();
    }

    public void resetClosedFlag() {
        this._closed.set(false);
    }

    protected boolean setClosed() {
        return this._closed.getAndSet(true);
    }

    protected void setClosing(boolean closing) {
        this._closing.set(closing);
    }

    public abstract void close() throws JMSException;
}

