/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.message;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageNotWriteableException;
import javax.jms.Queue;
import org.apache.qpid.client.AMQDestination;
import org.apache.qpid.client.AMQQueue;
import org.apache.qpid.client.AMQSession_0_8;
import org.apache.qpid.client.AMQTopic;
import org.apache.qpid.client.CustomJMSXProperty;
import org.apache.qpid.client.message.AbstractAMQMessageDelegate;
import org.apache.qpid.client.message.JMSHeaderAdapter;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.BasicContentHeaderProperties;
import org.apache.qpid.url.AMQBindingURL;
import org.apache.qpid.url.BindingURL;

public class AMQMessageDelegate_0_8
extends AbstractAMQMessageDelegate {
    private static final float DESTINATION_CACHE_LOAD_FACTOR = 0.75f;
    private static final int DESTINATION_CACHE_SIZE = 500;
    private static final int DESTINATION_CACHE_CAPACITY = 666;
    private static final Map<String, Destination> _destinationCache = Collections.synchronizedMap(new LinkedHashMap<String, Destination>(666, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Destination> eldest) {
            return this.size() >= 500;
        }
    });
    public static final String JMS_TYPE = "x-jms-type";
    public static final boolean STRICT_JMS = Boolean.getBoolean("strict-jms");
    private boolean _readableProperties = false;
    private Destination _destination;
    private JMSHeaderAdapter _headerAdapter;
    private static final boolean STRICT_AMQP_COMPLIANCE = Boolean.parseBoolean(System.getProperties().getProperty("STRICT_AMQP", "false"));
    private BasicContentHeaderProperties _contentHeaderProperties;
    private static final byte[] HEX_DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    private AMQMessageDelegate_0_8(BasicContentHeaderProperties properties, long deliveryTag) {
        super(deliveryTag);
        this._contentHeaderProperties = properties;
        this._readableProperties = this._contentHeaderProperties != null;
        this._headerAdapter = new JMSHeaderAdapter(this._readableProperties ? this._contentHeaderProperties.getHeaders() : new BasicContentHeaderProperties().getHeaders());
    }

    protected AMQMessageDelegate_0_8() {
        this(new BasicContentHeaderProperties(), -1L);
        this._readableProperties = false;
        this._headerAdapter = new JMSHeaderAdapter(this._contentHeaderProperties.getHeaders());
    }

    protected AMQMessageDelegate_0_8(long deliveryTag, BasicContentHeaderProperties contentHeader, AMQShortString exchange, AMQShortString routingKey, AMQSession_0_8.DestinationCache<AMQQueue> queueDestinationCache, AMQSession_0_8.DestinationCache<AMQTopic> topicDestinationCache, int addressType) {
        this(contentHeader, deliveryTag);
        Integer type = contentHeader.getHeaders().getInteger(CustomJMSXProperty.JMS_QPID_DESTTYPE.getShortStringName());
        AMQDestination dest = null;
        if (AMQDestination.getDefaultDestSyntax() == AMQDestination.DestSyntax.BURL) {
            if (type != null) {
                switch (type) {
                    case 1: {
                        dest = queueDestinationCache.getDestination(exchange, routingKey);
                        break;
                    }
                    case 2: {
                        dest = topicDestinationCache.getDestination(exchange, routingKey);
                        break;
                    }
                    default: {
                        dest = null;
                    }
                }
            }
            if (dest == null) {
                dest = this.generateDestination(exchange, routingKey);
            }
        } else {
            String subject = null;
            if (contentHeader.getHeaders() != null && contentHeader.getHeaders().containsKey("qpid.subject")) {
                subject = contentHeader.getHeaders().getString("qpid.subject");
            }
            if (type == null) {
                type = addressType;
            }
            dest = (AMQDestination)this.convertToAddressBasedDestination(AMQShortString.toString((AMQShortString)exchange), AMQShortString.toString((AMQShortString)routingKey), subject, true, type);
        }
        this.setJMSDestination(dest);
    }

    @Override
    public String getJMSMessageID() throws JMSException {
        return this.getContentHeaderProperties().getMessageIdAsString();
    }

    @Override
    public void setJMSMessageID(String messageId) throws JMSException {
        if (messageId != null) {
            this.getContentHeaderProperties().setMessageId(messageId);
        }
    }

    @Override
    public void setJMSMessageID(UUID messageId) throws JMSException {
        if (messageId != null) {
            this.getContentHeaderProperties().setMessageId(AMQMessageDelegate_0_8.asShortStringMsgId(messageId));
        }
    }

    private static AMQShortString asShortStringMsgId(UUID messageId) {
        long msb = messageId.getMostSignificantBits();
        long lsb = messageId.getLeastSignificantBits();
        byte[] messageIdBytes = new byte[]{73, 68, 58, HEX_DIGITS[(int)(msb >> 60 & 0xFL)], HEX_DIGITS[(int)(msb >> 56 & 0xFL)], HEX_DIGITS[(int)(msb >> 52 & 0xFL)], HEX_DIGITS[(int)(msb >> 48 & 0xFL)], HEX_DIGITS[(int)(msb >> 44 & 0xFL)], HEX_DIGITS[(int)(msb >> 40 & 0xFL)], HEX_DIGITS[(int)(msb >> 36 & 0xFL)], HEX_DIGITS[(int)(msb >> 32 & 0xFL)], 45, HEX_DIGITS[(int)(msb >> 28 & 0xFL)], HEX_DIGITS[(int)(msb >> 24 & 0xFL)], HEX_DIGITS[(int)(msb >> 20 & 0xFL)], HEX_DIGITS[(int)(msb >> 16 & 0xFL)], 45, HEX_DIGITS[(int)(msb >> 12 & 0xFL)], HEX_DIGITS[(int)(msb >> 8 & 0xFL)], HEX_DIGITS[(int)(msb >> 4 & 0xFL)], HEX_DIGITS[(int)(msb & 0xFL)], 45, HEX_DIGITS[(int)(lsb >> 60 & 0xFL)], HEX_DIGITS[(int)(lsb >> 56 & 0xFL)], HEX_DIGITS[(int)(lsb >> 52 & 0xFL)], HEX_DIGITS[(int)(lsb >> 48 & 0xFL)], 45, HEX_DIGITS[(int)(lsb >> 44 & 0xFL)], HEX_DIGITS[(int)(lsb >> 40 & 0xFL)], HEX_DIGITS[(int)(lsb >> 36 & 0xFL)], HEX_DIGITS[(int)(lsb >> 32 & 0xFL)], HEX_DIGITS[(int)(lsb >> 28 & 0xFL)], HEX_DIGITS[(int)(lsb >> 24 & 0xFL)], HEX_DIGITS[(int)(lsb >> 20 & 0xFL)], HEX_DIGITS[(int)(lsb >> 16 & 0xFL)], HEX_DIGITS[(int)(lsb >> 12 & 0xFL)], HEX_DIGITS[(int)(lsb >> 8 & 0xFL)], HEX_DIGITS[(int)(lsb >> 4 & 0xFL)], HEX_DIGITS[(int)(lsb & 0xFL)]};
        return new AMQShortString(messageIdBytes, 0, 39);
    }

    @Override
    public long getJMSTimestamp() throws JMSException {
        return this.getContentHeaderProperties().getTimestamp();
    }

    @Override
    public void setJMSTimestamp(long timestamp) throws JMSException {
        this.getContentHeaderProperties().setTimestamp(timestamp);
    }

    @Override
    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        return this.getContentHeaderProperties().getCorrelationIdAsString().getBytes();
    }

    @Override
    public void setJMSCorrelationIDAsBytes(byte[] bytes) throws JMSException {
        this.getContentHeaderProperties().setCorrelationId(new String(bytes));
    }

    @Override
    public void setJMSCorrelationID(String correlationId) throws JMSException {
        this.getContentHeaderProperties().setCorrelationId(correlationId);
    }

    @Override
    public String getJMSCorrelationID() throws JMSException {
        return this.getContentHeaderProperties().getCorrelationIdAsString();
    }

    @Override
    public Destination getJMSReplyTo() throws JMSException {
        String replyToEncoding = this.getContentHeaderProperties().getReplyToAsString();
        if (replyToEncoding == null) {
            return null;
        }
        Destination dest = _destinationCache.get(replyToEncoding);
        if (dest == null) {
            try {
                AMQBindingURL binding = new AMQBindingURL(replyToEncoding);
                dest = AMQDestination.createDestination((BindingURL)binding);
            }
            catch (URISyntaxException e) {
                if (replyToEncoding.startsWith("/")) {
                    dest = new DefaultRouterDestination(replyToEncoding);
                }
                if (replyToEncoding.contains("/")) {
                    String[] parts = replyToEncoding.split("/", 2);
                    dest = new NonBURLReplyToDestination(parts[0], parts[1]);
                }
                dest = this.getAMQSession().isQueueBound(AMQShortString.valueOf((String)replyToEncoding), null, null) ? new NonBURLReplyToDestination(replyToEncoding, "") : new DefaultRouterDestination(replyToEncoding);
            }
            _destinationCache.put(replyToEncoding, dest);
        }
        return dest;
    }

    @Override
    public void setJMSReplyTo(Destination destination) throws JMSException {
        if (destination == null) {
            this.getContentHeaderProperties().setReplyTo((String)null);
            return;
        }
        if (!(destination instanceof AMQDestination)) {
            throw new IllegalArgumentException("ReplyTo destination may only be an AMQDestination - passed argument was type " + destination.getClass());
        }
        AMQDestination amqd = (AMQDestination)destination;
        AMQShortString encodedDestination = amqd.getEncodedName();
        _destinationCache.put(encodedDestination.asString(), destination);
        this.getContentHeaderProperties().setReplyTo(encodedDestination);
    }

    @Override
    public Destination getJMSDestination() throws JMSException {
        return this._destination;
    }

    @Override
    public void setJMSDestination(Destination destination) {
        this._destination = destination;
    }

    @Override
    public void setContentType(String contentType) {
        this.getContentHeaderProperties().setContentType(contentType);
    }

    @Override
    public String getContentType() {
        return this.getContentHeaderProperties().getContentTypeAsString();
    }

    @Override
    public void setEncoding(String encoding) {
        this.getContentHeaderProperties().setEncoding(encoding);
    }

    @Override
    public String getEncoding() {
        return this.getContentHeaderProperties().getEncodingAsString();
    }

    @Override
    public String getReplyToString() {
        return this.getContentHeaderProperties().getReplyToAsString();
    }

    @Override
    public int getJMSDeliveryMode() throws JMSException {
        return this.getContentHeaderProperties().getDeliveryMode();
    }

    @Override
    public void setJMSDeliveryMode(int i) throws JMSException {
        this.getContentHeaderProperties().setDeliveryMode((byte)i);
    }

    public BasicContentHeaderProperties getContentHeaderProperties() {
        return this._contentHeaderProperties;
    }

    @Override
    public String getJMSType() throws JMSException {
        return this.getContentHeaderProperties().getTypeAsString();
    }

    @Override
    public void setJMSType(String string) throws JMSException {
        this.getContentHeaderProperties().setType(string);
    }

    @Override
    public long getJMSExpiration() throws JMSException {
        return this.getContentHeaderProperties().getExpiration();
    }

    @Override
    public void setJMSExpiration(long l) throws JMSException {
        this.getContentHeaderProperties().setExpiration(l);
    }

    @Override
    public boolean propertyExists(String propertyName) throws JMSException {
        return this.getJmsHeaders().propertyExists(propertyName);
    }

    @Override
    public boolean getBooleanProperty(String propertyName) throws JMSException {
        if (STRICT_AMQP_COMPLIANCE) {
            throw new UnsupportedOperationException("JMS Properties not supported in AMQP");
        }
        return this.getJmsHeaders().getBoolean(propertyName);
    }

    @Override
    public byte getByteProperty(String propertyName) throws JMSException {
        if (STRICT_AMQP_COMPLIANCE) {
            throw new UnsupportedOperationException("JMS Properties not supported in AMQP");
        }
        return this.getJmsHeaders().getByte(propertyName);
    }

    @Override
    public short getShortProperty(String propertyName) throws JMSException {
        if (STRICT_AMQP_COMPLIANCE) {
            throw new UnsupportedOperationException("JMS Properties not supported in AMQP");
        }
        return this.getJmsHeaders().getShort(propertyName);
    }

    @Override
    public int getIntProperty(String propertyName) throws JMSException {
        if (STRICT_AMQP_COMPLIANCE) {
            throw new UnsupportedOperationException("JMS Properties not supported in AMQP");
        }
        return this.getJmsHeaders().getInteger(propertyName);
    }

    @Override
    public long getLongProperty(String propertyName) throws JMSException {
        if (STRICT_AMQP_COMPLIANCE) {
            throw new UnsupportedOperationException("JMS Properties not supported in AMQP");
        }
        return this.getJmsHeaders().getLong(propertyName);
    }

    @Override
    public float getFloatProperty(String propertyName) throws JMSException {
        if (STRICT_AMQP_COMPLIANCE) {
            throw new UnsupportedOperationException("JMS Properties not supported in AMQP");
        }
        return this.getJmsHeaders().getFloat(propertyName);
    }

    @Override
    public double getDoubleProperty(String propertyName) throws JMSException {
        if (STRICT_AMQP_COMPLIANCE) {
            throw new UnsupportedOperationException("JMS Properties not supported in AMQP");
        }
        return this.getJmsHeaders().getDouble(propertyName);
    }

    @Override
    public String getStringProperty(String propertyName) throws JMSException {
        if (propertyName.equals(CustomJMSXProperty.JMSXUserID.toString())) {
            return this._contentHeaderProperties.getUserIdAsString();
        }
        if (STRICT_AMQP_COMPLIANCE) {
            throw new UnsupportedOperationException("JMS Properties not supported in AMQP");
        }
        return this.getJmsHeaders().getString(propertyName);
    }

    @Override
    public Object getObjectProperty(String propertyName) throws JMSException {
        return this.getJmsHeaders().getObject(propertyName);
    }

    @Override
    public Enumeration getPropertyNames() throws JMSException {
        Set<String> keys = this.getJmsHeaders().getPropertyNames();
        return Collections.enumeration(keys);
    }

    @Override
    public void setBooleanProperty(String propertyName, boolean b) throws JMSException {
        if (STRICT_AMQP_COMPLIANCE) {
            throw new UnsupportedOperationException("JMS Properties not supported in AMQP");
        }
        this.checkWritableProperties();
        this.getJmsHeaders().setBoolean(propertyName, b);
    }

    @Override
    public void setByteProperty(String propertyName, byte b) throws JMSException {
        if (STRICT_AMQP_COMPLIANCE) {
            throw new UnsupportedOperationException("JMS Properties not supported in AMQP");
        }
        this.checkWritableProperties();
        this.getJmsHeaders().setByte(propertyName, b);
    }

    @Override
    public void setShortProperty(String propertyName, short i) throws JMSException {
        if (STRICT_AMQP_COMPLIANCE) {
            throw new UnsupportedOperationException("JMS Properties not supported in AMQP");
        }
        this.checkWritableProperties();
        this.getJmsHeaders().setShort(propertyName, i);
    }

    @Override
    public void setIntProperty(String propertyName, int i) throws JMSException {
        this.checkWritableProperties();
        this.getJmsHeaders().setInteger(propertyName, i);
    }

    @Override
    public void setLongProperty(String propertyName, long l) throws JMSException {
        if (STRICT_AMQP_COMPLIANCE) {
            throw new UnsupportedOperationException("JMS Properties not supported in AMQP");
        }
        this.checkWritableProperties();
        this.getJmsHeaders().setLong(propertyName, l);
    }

    @Override
    public void setFloatProperty(String propertyName, float f) throws JMSException {
        if (STRICT_AMQP_COMPLIANCE) {
            throw new UnsupportedOperationException("JMS Properties not supported in AMQP");
        }
        this.checkWritableProperties();
        this.getJmsHeaders().setFloat(propertyName, f);
    }

    @Override
    public void setDoubleProperty(String propertyName, double v) throws JMSException {
        if (STRICT_AMQP_COMPLIANCE) {
            throw new UnsupportedOperationException("JMS Properties not supported in AMQP");
        }
        this.checkWritableProperties();
        this.getJmsHeaders().setDouble(propertyName, v);
    }

    @Override
    public void setStringProperty(String propertyName, String value) throws JMSException {
        this.checkWritableProperties();
        this.getJmsHeaders().setString(propertyName, value);
    }

    @Override
    public void setObjectProperty(String propertyName, Object object) throws JMSException {
        this.checkWritableProperties();
        this.getJmsHeaders().setObject(propertyName, object);
    }

    @Override
    public void removeProperty(String propertyName) throws JMSException {
        this.getJmsHeaders().remove(propertyName);
    }

    private JMSHeaderAdapter getJmsHeaders() {
        return this._headerAdapter;
    }

    protected void checkWritableProperties() throws MessageNotWriteableException {
        if (this._readableProperties) {
            throw new MessageNotWriteableException("You need to call clearProperties() to make the message writable");
        }
    }

    @Override
    public int getJMSPriority() throws JMSException {
        return this.getContentHeaderProperties().getPriority();
    }

    @Override
    public void setJMSPriority(int i) throws JMSException {
        this.getContentHeaderProperties().setPriority((byte)i);
    }

    @Override
    public void clearProperties() throws JMSException {
        this.getJmsHeaders().clear();
        this._readableProperties = false;
    }

    private static class NonBURLReplyToDestination
    extends AMQDestination
    implements Queue {
        private static final long serialVersionUID = 122897705932489259L;

        public NonBURLReplyToDestination(String exchange, String routingKey) {
            super(AMQShortString.valueOf((String)exchange), null, AMQShortString.valueOf((String)routingKey), AMQShortString.valueOf((String)routingKey));
        }

        @Override
        public boolean isNameRequired() {
            return false;
        }

        @Override
        public boolean neverDeclare() {
            return true;
        }
    }

    private static class DefaultRouterDestination
    extends AMQDestination
    implements Queue {
        private static final long serialVersionUID = -5042408431861384536L;

        public DefaultRouterDestination(String replyToEncoding) {
            super(AMQShortString.EMPTY_STRING, AMQShortString.valueOf((String)"direct"), AMQShortString.valueOf((String)replyToEncoding), AMQShortString.valueOf((String)replyToEncoding));
        }

        @Override
        public boolean isNameRequired() {
            return false;
        }

        @Override
        public boolean neverDeclare() {
            return true;
        }
    }
}

