/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.url;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.StringTokenizer;
import org.apache.qpid.client.AMQBrokerDetails;
import org.apache.qpid.client.AMQConnectionFactory;
import org.apache.qpid.client.AMQConnectionURL;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.url.URLHelper;
import org.apache.qpid.url.URLSyntaxException;

public class URLParser {
    private AMQConnectionURL _url;

    public URLParser(AMQConnectionURL url) throws URLSyntaxException {
        this._url = url;
        this.parseURL(this._url.getURL());
    }

    private void parseURL(String fullURL) throws URLSyntaxException {
        try {
            String virtualHost;
            URI connection = new URI(fullURL);
            if (connection.getScheme() == null || !connection.getScheme().equalsIgnoreCase("amqp")) {
                throw new URISyntaxException(fullURL, "Not an AMQP URL");
            }
            if (connection.getHost() == null || connection.getHost().equals("")) {
                String tmp = connection.getAuthority();
                if (tmp != null && tmp.indexOf(64) < tmp.length() - 1) {
                    this._url.setClientName(tmp.substring(tmp.indexOf(64) + 1, tmp.length()));
                } else {
                    String uid = AMQConnectionFactory.getUniqueClientID();
                    if (uid == null) {
                        throw URLHelper.parseError((int)-1, (String)"Client Name not specified", (String)fullURL);
                    }
                    this._url.setClientName(uid);
                }
            } else {
                this._url.setClientName(connection.getHost());
            }
            String userInfo = connection.getUserInfo();
            if (userInfo == null && (userInfo = connection.getAuthority()) != null) {
                int atIndex = userInfo.indexOf(64);
                userInfo = atIndex != -1 ? userInfo.substring(0, atIndex) : null;
            }
            if (userInfo != null) {
                this.parseUserInfo(userInfo);
            }
            if ((virtualHost = connection.getPath()) == null || virtualHost.equals("")) {
                int authLength = connection.getAuthority().length();
                int start = "amqp".length() + 3;
                int testIndex = start + authLength;
                if (testIndex < fullURL.length() && fullURL.charAt(testIndex) == '?') {
                    throw URLHelper.parseError((int)start, (int)(testIndex - start), (String)"Virtual host found", (String)fullURL);
                }
                throw URLHelper.parseError((int)-1, (String)"Virtual host not specified", (String)fullURL);
            }
            this._url.setVirtualHost(virtualHost);
            URLHelper.parseOptions(this._url.getOptions(), (String)connection.getQuery());
            this.processOptions();
        }
        catch (URISyntaxException uris) {
            if (uris instanceof URLSyntaxException) {
                throw (URLSyntaxException)((Object)uris);
            }
            int slash = fullURL.indexOf("\\");
            if (slash == -1) {
                throw URLHelper.parseError((int)uris.getIndex(), (String)uris.getReason(), (String)uris.getInput());
            }
            if (slash != 0 && fullURL.charAt(slash - 1) == ':') {
                throw URLHelper.parseError((int)(slash - 2), (int)(fullURL.indexOf(63) - slash + 2), (String)"Virtual host looks like a windows path, forward slash not allowed in URL", (String)fullURL);
            }
            throw URLHelper.parseError((int)slash, (String)"Forward slash not allowed in URL", (String)fullURL);
        }
    }

    private void parseUserInfo(String userinfo) throws URLSyntaxException {
        int colonIndex = userinfo.indexOf(58);
        if (colonIndex == -1) {
            throw URLHelper.parseError((int)("amqp".length() + 3), (int)userinfo.length(), (String)"Null password in user information not allowed.", (String)this._url.getURL());
        }
        this._url.setUsername(userinfo.substring(0, colonIndex));
        this._url.setPassword(userinfo.substring(colonIndex + 1));
    }

    private void processOptions() throws URLSyntaxException {
        if (this._url.getOptions().containsKey("brokerlist")) {
            String brokerlist = this._url.getOptions().get("brokerlist");
            StringTokenizer st = new StringTokenizer(brokerlist, ";");
            while (st.hasMoreTokens()) {
                String broker = st.nextToken();
                this._url.addBrokerDetails(new AMQBrokerDetails(broker));
            }
            this._url.getOptions().remove("brokerlist");
        }
        if (this._url.getOptions().containsKey("failover")) {
            String failover = this._url.getOptions().get("failover");
            int methodIndex = failover.indexOf(63);
            if (methodIndex > -1) {
                this._url.setFailoverMethod(failover.substring(0, methodIndex));
                URLHelper.parseOptions(this._url.getFailoverOptions(), (String)failover.substring(methodIndex + 1));
            } else {
                this._url.setFailoverMethod(failover);
            }
            this._url.getOptions().remove("failover");
        }
        if (this._url.getOptions().containsKey("defaultTopicExchange")) {
            this._url.setDefaultTopicExchangeName(new AMQShortString(this._url.getOptions().get("defaultTopicExchange")));
        }
        if (this._url.getOptions().containsKey("defaultQueueExchange")) {
            this._url.setDefaultQueueExchangeName(new AMQShortString(this._url.getOptions().get("defaultQueueExchange")));
        }
        if (this._url.getOptions().containsKey("temporaryQueueExchange")) {
            this._url.setTemporaryQueueExchangeName(new AMQShortString(this._url.getOptions().get("temporaryQueueExchange")));
        }
        if (this._url.getOptions().containsKey("temporaryTopicExchange")) {
            this._url.setTemporaryTopicExchangeName(new AMQShortString(this._url.getOptions().get("temporaryTopicExchange")));
        }
    }
}

