/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.XASession;
import org.apache.qpid.AMQException;
import org.apache.qpid.QpidException;
import org.apache.qpid.client.AMQConnection;
import org.apache.qpid.client.AMQConnectionDelegate;
import org.apache.qpid.client.AMQSession;
import org.apache.qpid.client.AMQSession_0_10;
import org.apache.qpid.client.BrokerDetails;
import org.apache.qpid.client.HeartbeatListener;
import org.apache.qpid.client.XASessionImpl;
import org.apache.qpid.client.failover.FailoverException;
import org.apache.qpid.client.failover.FailoverProtectedOperation;
import org.apache.qpid.client.transport.ClientConnectionDelegate;
import org.apache.qpid.client.util.JMSExceptionHelper;
import org.apache.qpid.framing.ProtocolVersion;
import org.apache.qpid.jms.ChannelLimitReachedException;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.transport.Connection;
import org.apache.qpid.transport.ConnectionClose;
import org.apache.qpid.transport.ConnectionCloseCode;
import org.apache.qpid.transport.ConnectionDelegate;
import org.apache.qpid.transport.ConnectionException;
import org.apache.qpid.transport.ConnectionListener;
import org.apache.qpid.transport.ConnectionSettings;
import org.apache.qpid.transport.FrameSizeObserver;
import org.apache.qpid.transport.ProtocolVersionException;
import org.apache.qpid.transport.Session;
import org.apache.qpid.transport.SessionDetachCode;
import org.apache.qpid.transport.SessionException;
import org.apache.qpid.transport.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQConnectionDelegate_0_10
implements AMQConnectionDelegate,
ConnectionListener,
FrameSizeObserver {
    private static final int DEFAULT_PORT = 5672;
    private static final Logger _logger = LoggerFactory.getLogger(AMQConnectionDelegate_0_10.class);
    private final AMQConnection _conn;
    private Connection _qpidConnection;
    private ConnectionException exception = null;

    public AMQConnectionDelegate_0_10(AMQConnection conn) {
        this._conn = conn;
        this._qpidConnection = new Connection();
        this._qpidConnection.addConnectionListener((ConnectionListener)this);
        this._qpidConnection.addFrameSizeObserver((FrameSizeObserver)this);
    }

    @Override
    public org.apache.qpid.jms.Session createSession(boolean transacted, int acknowledgeMode, int prefetchHigh, int prefetchLow) throws JMSException {
        return this.createSession(transacted, acknowledgeMode, prefetchHigh, prefetchLow, null);
    }

    public org.apache.qpid.jms.Session createSession(boolean transacted, int acknowledgeMode, int prefetchHigh, int prefetchLow, String name) throws JMSException {
        AMQSession_0_10 session;
        this._conn.checkNotClosed();
        if (this._conn.channelLimitReached()) {
            throw new ChannelLimitReachedException(this._conn.getMaximumChannelCount());
        }
        int channelId = this._conn.getNextChannelID();
        try {
            session = new AMQSession_0_10(this._qpidConnection, this._conn, channelId, transacted, acknowledgeMode, prefetchHigh, prefetchLow, name);
            this._conn.registerSession(channelId, session);
            if (this._conn.started()) {
                session.start();
            }
        }
        catch (Exception e) {
            _logger.error("exception creating session:", (Throwable)e);
            throw JMSExceptionHelper.chainJMSException(new JMSException("cannot create session"), e);
        }
        return session;
    }

    @Override
    public XASession createXASession() throws JMSException {
        return this.createXASession((int)this._conn.getMaxPrefetch(), (int)this._conn.getMaxPrefetch() / 2);
    }

    @Override
    public XASession createXASession(int prefetchHigh, int prefetchLow) throws JMSException {
        XASessionImpl session;
        this._conn.checkNotClosed();
        if (this._conn.channelLimitReached()) {
            throw new ChannelLimitReachedException(this._conn.getMaximumChannelCount());
        }
        int channelId = this._conn.getNextChannelID();
        try {
            session = new XASessionImpl(this._qpidConnection, this._conn, channelId, prefetchHigh, prefetchLow);
            this._conn.registerSession(channelId, session);
            if (this._conn.started()) {
                session.start();
            }
        }
        catch (Exception e) {
            throw JMSExceptionHelper.chainJMSException(new JMSException("cannot create session"), e);
        }
        return session;
    }

    @Override
    public XASession createXASession(int ackMode) throws JMSException {
        XASessionImpl session;
        this._conn.checkNotClosed();
        if (this._conn.channelLimitReached()) {
            throw new ChannelLimitReachedException(this._conn.getMaximumChannelCount());
        }
        int channelId = this._conn.getNextChannelID();
        try {
            session = new XASessionImpl(this._qpidConnection, this._conn, channelId, ackMode, (int)this._conn.getMaxPrefetch(), (int)this._conn.getMaxPrefetch() / 2);
            this._conn.registerSession(channelId, session);
            if (this._conn.started()) {
                session.start();
            }
        }
        catch (Exception e) {
            throw JMSExceptionHelper.chainJMSException(new JMSException("cannot create session"), e);
        }
        return session;
    }

    @Override
    public ProtocolVersion makeBrokerConnection(BrokerDetails brokerDetail) throws IOException, QpidException {
        try {
            if (_logger.isDebugEnabled()) {
                _logger.debug("connecting to host: " + brokerDetail.getHost() + " port: " + brokerDetail.getPort() + " vhost: " + this._conn.getVirtualHost() + " username: " + this._conn.getUsername() + " password: " + "********");
            }
            ConnectionSettings conSettings = this.retrieveConnectionSettings(brokerDetail);
            this._qpidConnection.setConnectionDelegate((ConnectionDelegate)new ClientConnectionDelegate(conSettings, this._conn.getConnectionURL()));
            this._qpidConnection.connect(conSettings);
            this._conn.setConnected(true);
            this._conn.setUsername(this._qpidConnection.getUserID());
            this._conn.setMaximumChannelCount(this._qpidConnection.getChannelMax());
            this._conn.getFailoverPolicy().attainedConnection();
            this._conn.logConnected(this._qpidConnection.getLocalAddress(), this._qpidConnection.getRemoteSocketAddress());
            this._conn.setConnectionSettings(conSettings);
        }
        catch (ProtocolVersionException pe) {
            if (pe.getMajor() == 9 && pe.getMinor() == 1) {
                return ProtocolVersion.v0_91;
            }
            return ProtocolVersion.get((byte)pe.getMajor(), (byte)pe.getMinor());
        }
        catch (ConnectionException ce) {
            AMQConstant code = AMQConstant.REPLY_SUCCESS;
            if (ce.getClose() != null && ce.getClose().getReplyCode() != null) {
                code = AMQConstant.getConstant((int)ce.getClose().getReplyCode().getValue());
            }
            String msg = "Cannot connect to broker (" + brokerDetail + "): " + ce.getMessage();
            throw new AMQException(code, msg, (Throwable)ce);
        }
        return null;
    }

    public void failoverPrep() {
        ArrayList<AMQSession> sessions = new ArrayList<AMQSession>(this._conn.getSessions().values());
        for (AMQSession s : sessions) {
            ((AMQSession_0_10)s).failoverPrep();
        }
    }

    @Override
    public void resubscribeSessions() throws JMSException, QpidException, FailoverException {
        _logger.info("Resuming connection");
        this.getQpidConnection().resume();
        ArrayList<AMQSession> sessions = new ArrayList<AMQSession>(this._conn.getSessions().values());
        _logger.info(String.format("Resubscribing sessions = %s sessions.size=%d", sessions, sessions.size()));
        for (AMQSession s : sessions) {
            s.resubscribe();
        }
    }

    @Override
    public void closeConnection(long timeout) throws JMSException, QpidException {
        try {
            this._qpidConnection.close();
        }
        catch (TransportException e) {
            throw new QpidException(e.getMessage(), (Throwable)e);
        }
    }

    public void opened(Connection conn) {
    }

    public void exception(Connection conn, ConnectionException exc) {
        if (this.exception != null) {
            _logger.error("previous exception", (Throwable)this.exception);
        }
        this.exception = exc;
    }

    public void closed(Connection conn) {
        final ConnectionException exc = this.exception;
        this.exception = null;
        if (exc == null) {
            return;
        }
        final ConnectionClose close = exc.getClose();
        if (close == null || close.getReplyCode() == ConnectionCloseCode.CONNECTION_FORCED) {
            this._conn.getProtocolHandler().setFailoverLatch(new CountDownLatch(1));
            this._qpidConnection.notifyFailoverRequired();
            final AtomicBoolean failoverDone = new AtomicBoolean();
            this._conn.doWithAllLocks(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        boolean preFailover = AMQConnectionDelegate_0_10.this._conn.firePreFailover(false);
                        if (preFailover) {
                            boolean reconnected;
                            if (exc instanceof RedirectConnectionException) {
                                RedirectConnectionException redirect = (RedirectConnectionException)exc;
                                reconnected = AMQConnectionDelegate_0_10.this.attemptRedirection(redirect.getHost(), redirect.getKnownHosts());
                            } else {
                                reconnected = AMQConnectionDelegate_0_10.this._conn.attemptReconnection();
                            }
                            if (reconnected) {
                                AMQConnectionDelegate_0_10.this.failoverPrep();
                                AMQConnectionDelegate_0_10.this._conn.resubscribeSessions();
                                AMQConnectionDelegate_0_10.this._conn.fireFailoverComplete();
                                failoverDone.set(true);
                            }
                        }
                    }
                    catch (Exception e) {
                        _logger.error("error during failover", (Throwable)e);
                    }
                    finally {
                        AMQConnectionDelegate_0_10.this._conn.getProtocolHandler().getFailoverLatch().countDown();
                        AMQConnectionDelegate_0_10.this._conn.getProtocolHandler().setFailoverLatch(null);
                    }
                }
            });
            if (failoverDone.get()) {
                return;
            }
        }
        for (AMQSession session : this._conn.getSessions().values()) {
            session.markClosed();
        }
        this._conn.setClosed();
        final ExceptionListener listener = this._conn.getExceptionListenerNoCheck();
        if (listener == null) {
            _logger.error("connection exception: " + conn, (Throwable)exc);
        } else {
            this._conn.performConnectionTask(new Runnable(){

                @Override
                public void run() {
                    String code = null;
                    if (close != null) {
                        code = close.getReplyCode().toString();
                    }
                    listener.onException(JMSExceptionHelper.chainJMSException(new JMSException(exc.getMessage(), code), (Throwable)exc));
                }
            });
        }
    }

    public boolean redirect(String host, List<Object> knownHosts) {
        this.exception = new RedirectConnectionException(host, knownHosts);
        return false;
    }

    private boolean attemptRedirection(String host, List<Object> knownHosts) {
        boolean redirected;
        block1: {
            Object knownHost;
            boolean bl = redirected = host != null && this.attemptRedirection(host);
            if (knownHosts == null) break block1;
            Iterator<Object> i$ = knownHosts.iterator();
            while (i$.hasNext() && !(redirected = this.attemptRedirection(String.valueOf(knownHost = i$.next())))) {
            }
        }
        return redirected;
    }

    private boolean attemptRedirection(String host) {
        int port;
        int portIndex = host.indexOf(58);
        if (portIndex == -1) {
            port = 5672;
        } else {
            try {
                port = Integer.parseInt(host.substring(portIndex + 1));
            }
            catch (NumberFormatException e) {
                _logger.info("Unable to redirect to " + host + " - does not look like a valid address");
                return false;
            }
            host = host.substring(0, portIndex);
        }
        return this._conn.attemptReconnection(host, port, false);
    }

    @Override
    public <T, E extends Exception> T executeRetrySupport(FailoverProtectedOperation<T, E> operation) throws E {
        if (this._conn.isFailingOver()) {
            try {
                this._conn.blockUntilNotFailingOver();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        try {
            return operation.execute();
        }
        catch (FailoverException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getMaxChannelID() {
        return this._qpidConnection.getChannelMax() - 1;
    }

    @Override
    public int getMinChannelID() {
        return 0;
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return ProtocolVersion.v0_10;
    }

    public String getUUID() {
        return (String)this._qpidConnection.getServerProperties().get("qpid.federation_tag");
    }

    @Override
    public boolean isSupportedServerFeature(String featureName) {
        if (featureName == null) {
            throw new IllegalArgumentException("featureName cannot be null");
        }
        Map serverProperties = this._qpidConnection.getServerProperties();
        boolean featureSupported = false;
        if (serverProperties != null && serverProperties.containsKey("qpid.features")) {
            Object supportServerFeatures = serverProperties.get("qpid.features");
            boolean bl = featureSupported = supportServerFeatures instanceof List && ((List)supportServerFeatures).contains(featureName);
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("Server support for feature '" + featureName + "' : " + featureSupported);
        }
        return featureSupported;
    }

    @Override
    public void setHeartbeatListener(HeartbeatListener listener) {
        ((ClientConnectionDelegate)this._qpidConnection.getConnectionDelegate()).setHeartbeatListener(listener);
    }

    private ConnectionSettings retrieveConnectionSettings(BrokerDetails brokerDetail) {
        boolean brokerlistUseSsl;
        boolean connUseSsl;
        ConnectionSettings conSettings = brokerDetail.buildConnectionSettings();
        conSettings.setVhost(this._conn.getVirtualHost());
        conSettings.setUsername(this._conn.getUsername());
        conSettings.setPassword(this._conn.getPassword());
        HashMap<String, String> clientProps = new HashMap<String, String>();
        try {
            clientProps.put("clientName", this._conn.getClientID());
            if (this._conn.isMessageCompressionDesired()) {
                clientProps.put("qpid.message_compression_supported", Boolean.TRUE.toString());
            }
            conSettings.setClientProperties(clientProps);
        }
        catch (JMSException e) {
            // empty catch block
        }
        String connectionSslOption = this._conn.getConnectionURL().getOption("ssl");
        if (connectionSslOption != null && (connUseSsl = Boolean.parseBoolean(connectionSslOption)) != (brokerlistUseSsl = conSettings.isUseSSL())) {
            conSettings.setUseSSL(connUseSsl);
            if (_logger.isDebugEnabled()) {
                _logger.debug("Applied connection ssl option override, setting UseSsl to: " + connUseSsl);
            }
        }
        return conSettings;
    }

    protected Connection getQpidConnection() {
        return this._qpidConnection;
    }

    @Override
    public boolean verifyClientID() throws JMSException, QpidException {
        int prefetch = (int)this._conn.getMaxPrefetch();
        AMQSession_0_10 ssn = (AMQSession_0_10)this.createSession(false, 1, prefetch, prefetch, this._conn.getClientID());
        Session ssn_0_10 = ssn.getQpidSession();
        try {
            ssn_0_10.awaitOpen();
        }
        catch (SessionException se) {
            if (ssn_0_10.getDetachCode() != null && ssn_0_10.getDetachCode() == SessionDetachCode.SESSION_BUSY) {
                return false;
            }
            throw new AMQException(AMQConstant.INTERNAL_ERROR, "Unexpected SessionException thrown while awaiting session opening", (Throwable)se);
        }
        return true;
    }

    @Override
    public boolean supportsIsBound() {
        return true;
    }

    @Override
    public boolean isMessageCompressionSupported() {
        return this._qpidConnection.isMessageCompressionSupported();
    }

    @Override
    public boolean isVirtualHostPropertiesSupported() {
        return this._qpidConnection.isVirtualHostPropertiesSupported();
    }

    public void setMaxFrameSize(int frameSize) {
        this._conn.setMaximumFrameSize(frameSize);
    }

    private class RedirectConnectionException
    extends ConnectionException {
        private final String _host;
        private final List<Object> _knownHosts;

        public RedirectConnectionException(String host, List<Object> knownHosts) {
            super("Connection redirected to " + host + " alternates " + knownHosts);
            this._host = host;
            this._knownHosts = knownHosts;
        }

        public String getHost() {
            return this._host;
        }

        public List<Object> getKnownHosts() {
            return this._knownHosts;
        }
    }
}

