/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.message;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.jms.JMSException;
import org.apache.qpid.QpidException;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.client.AMQQueue;
import org.apache.qpid.client.AMQSession_0_8;
import org.apache.qpid.client.AMQTopic;
import org.apache.qpid.client.message.AMQMessageDelegate_0_10;
import org.apache.qpid.client.message.AMQMessageDelegate_0_8;
import org.apache.qpid.client.message.AbstractAMQMessageDelegate;
import org.apache.qpid.client.message.AbstractJMSMessage;
import org.apache.qpid.framing.ContentBody;
import org.apache.qpid.framing.ContentHeaderBody;
import org.apache.qpid.transport.DeliveryProperties;
import org.apache.qpid.transport.MessageProperties;
import org.apache.qpid.util.GZIPUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJMSMessageFactory {
    private static final Logger _logger = LoggerFactory.getLogger(AbstractJMSMessageFactory.class);

    protected AbstractJMSMessage create08MessageWithBody(long messageNbr, ContentHeaderBody contentHeader, String exchange, String routingKey, List bodies, AMQSession_0_8.DestinationCache<AMQQueue> queueDestinationCache, AMQSession_0_8.DestinationCache<AMQTopic> topicDestinationCache, int addressType) throws QpidException {
        ByteBuffer data;
        byte[] uncompressed;
        boolean debug = _logger.isDebugEnabled();
        if ("gzip".equals(contentHeader.getProperties().getEncodingAsString()) && (uncompressed = GZIPUtils.uncompressStreamToArray((InputStream)new BodyInputStream(bodies))) != null) {
            contentHeader.getProperties().setEncoding((String)null);
            data = ByteBuffer.wrap(uncompressed);
        } else if (bodies != null && bodies.size() == 1) {
            if (debug) {
                _logger.debug("Non-fragmented message body (bodySize=" + contentHeader.getBodySize() + ")");
            }
            data = ((ContentBody)bodies.get(0)).getPayload().asByteBuffer().duplicate();
        } else if (bodies != null) {
            if (debug) {
                _logger.debug("Fragmented message body (" + bodies.size() + " frames, bodySize=" + contentHeader.getBodySize() + ")");
            }
            data = ByteBuffer.allocate((int)contentHeader.getBodySize());
            for (ContentBody cb : bodies) {
                ByteBuffer payload = cb.getPayload().asByteBuffer().duplicate();
                if (payload.isDirect() || payload.isReadOnly()) {
                    data.put(payload);
                    continue;
                }
                data.put(payload.array(), payload.arrayOffset(), payload.limit());
            }
            data.flip();
        } else {
            data = ByteBuffer.allocate(0);
        }
        if (debug) {
            _logger.debug("Creating message from buffer with position=" + data.position() + " and remaining=" + data.remaining());
        }
        AMQMessageDelegate_0_8 delegate = new AMQMessageDelegate_0_8(messageNbr, contentHeader.getProperties(), exchange, routingKey, queueDestinationCache, topicDestinationCache, addressType);
        return this.createMessage(delegate, data);
    }

    protected abstract AbstractJMSMessage createMessage(AbstractAMQMessageDelegate var1, ByteBuffer var2) throws QpidException;

    protected AbstractJMSMessage create010MessageWithBody(long messageNbr, MessageProperties msgProps, DeliveryProperties deliveryProps, Collection<QpidByteBuffer> body) throws QpidException {
        byte[] uncompressed;
        ByteBuffer data;
        boolean debug = _logger.isDebugEnabled();
        if (body != null && body.size() != 0) {
            int size = 0;
            for (QpidByteBuffer b : body) {
                size += b.remaining();
            }
            data = ByteBuffer.allocate(size);
            for (QpidByteBuffer b : body) {
                b.get(data);
            }
            data.flip();
        } else {
            data = ByteBuffer.allocate(0);
        }
        if (debug) {
            _logger.debug("Creating message from buffer with position=" + data.position() + " and remaining=" + data.remaining());
        }
        if ("gzip".equals(msgProps.getContentEncoding()) && (uncompressed = GZIPUtils.uncompressBufferToArray((ByteBuffer)data)) != null) {
            msgProps.setContentEncoding(null);
            data = ByteBuffer.wrap(uncompressed);
        }
        AMQMessageDelegate_0_10 delegate = new AMQMessageDelegate_0_10(msgProps, deliveryProps, messageNbr);
        AbstractJMSMessage message = this.createMessage(delegate, data);
        return message;
    }

    public AbstractJMSMessage createMessage(long messageNbr, boolean redelivered, ContentHeaderBody contentHeader, String exchange, String routingKey, List bodies, AMQSession_0_8.DestinationCache<AMQQueue> queueDestinationCache, AMQSession_0_8.DestinationCache<AMQTopic> topicDestinationCache, int addressType) throws JMSException, QpidException {
        AbstractJMSMessage msg = this.create08MessageWithBody(messageNbr, contentHeader, exchange, routingKey, bodies, queueDestinationCache, topicDestinationCache, addressType);
        msg.setJMSRedelivered(redelivered);
        msg.setReceivedFromServer();
        return msg;
    }

    public AbstractJMSMessage createMessage(long messageNbr, boolean redelivered, MessageProperties msgProps, DeliveryProperties deliveryProps, Collection<QpidByteBuffer> body) throws JMSException, QpidException {
        AbstractJMSMessage msg = this.create010MessageWithBody(messageNbr, msgProps, deliveryProps, body);
        msg.setJMSRedelivered(redelivered);
        msg.setReceivedFromServer();
        return msg;
    }

    private class BodyInputStream
    extends InputStream {
        private final Iterator<ContentBody> _bodiesIter;
        private QpidByteBuffer _currentBuffer;

        public BodyInputStream(List<ContentBody> bodies) {
            this._bodiesIter = bodies.iterator();
            this._currentBuffer = this._bodiesIter.next().getPayload().duplicate();
        }

        @Override
        public int read() throws IOException {
            byte[] buf = new byte[1];
            int size = this.read(buf);
            if (size == -1) {
                throw new EOFException();
            }
            return buf[0] & 0xFF;
        }

        @Override
        public int read(byte[] dst, int off, int len) {
            while (!this._currentBuffer.hasRemaining()) {
                if (!this._bodiesIter.hasNext()) {
                    return -1;
                }
                this._currentBuffer = this._bodiesIter.next().getPayload().duplicate();
            }
            int size = Math.min(len, this._currentBuffer.remaining());
            this._currentBuffer.get(dst, off, size);
            return size;
        }

        @Override
        public void close() {
        }
    }
}

