/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import java.net.URISyntaxException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Topic;
import org.apache.qpid.client.AMQConnection;
import org.apache.qpid.client.AMQDestination;
import org.apache.qpid.client.util.JMSExceptionHelper;
import org.apache.qpid.messaging.Address;
import org.apache.qpid.url.BindingURL;

public class AMQTopic
extends AMQDestination
implements Topic {
    private static final long serialVersionUID = -4773561540716587036L;

    public AMQTopic(String address) throws URISyntaxException {
        super(address);
        if (super.getRoutingKey() == null) {
            this.setRoutingKey("");
        }
    }

    public AMQTopic(Address address) {
        super(address);
        if (super.getRoutingKey() == null) {
            this.setRoutingKey("");
        }
    }

    public AMQTopic() {
        if (super.getRoutingKey() == null) {
            this.setRoutingKey("");
        }
    }

    public AMQTopic(BindingURL binding) {
        super(binding);
        if (super.getRoutingKey() == null) {
            this.setRoutingKey("");
        }
    }

    public AMQTopic(String exchange, String routingKey, String queueName) {
        this(exchange, "topic", routingKey, true, true, queueName, false);
    }

    public AMQTopic(String exchange, String routingKey, String queueName, String[] bindingKeys) {
        this(exchange, "topic", routingKey, true, true, queueName, false, bindingKeys);
    }

    public AMQTopic(AMQConnection conn, String routingKey) {
        this(conn.getDefaultTopicExchangeName(), routingKey);
    }

    public AMQTopic(String exchangeName, String routingKey) {
        this(exchangeName, routingKey, null);
    }

    public AMQTopic(String exchangeName, String name, boolean isAutoDelete, String queueName, boolean isDurable) {
        this(exchangeName, "topic", name, true, isAutoDelete, queueName, isDurable);
    }

    protected AMQTopic(String exchangeName, String exchangeClass, String name, boolean isAutoDelete, String queueName, boolean isDurable) {
        this(exchangeName, exchangeClass, name, true, isAutoDelete, queueName, isDurable);
    }

    protected AMQTopic(String exchangeName, String exchangeClass, String routingKey, boolean isExclusive, boolean isAutoDelete, String queueName, boolean isDurable) {
        this(exchangeName, exchangeClass, routingKey, isExclusive, isAutoDelete, queueName, isDurable, null);
    }

    protected AMQTopic(String exchangeName, String exchangeClass, String routingKey, boolean isExclusive, boolean isAutoDelete, String queueName, boolean isDurable, String[] bindingKeys) {
        super(exchangeName, exchangeClass, routingKey == null ? "" : routingKey, isExclusive, isAutoDelete, queueName, isDurable, bindingKeys);
    }

    public static AMQTopic createDurableTopic(Topic topic, String subscriptionName, AMQConnection connection) throws JMSException {
        if (topic instanceof AMQDestination) {
            AMQDestination qpidTopic = (AMQDestination)topic;
            if (qpidTopic.getDestSyntax() == AMQDestination.DestSyntax.ADDR) {
                try {
                    AMQTopic t = new AMQTopic(qpidTopic.getAddress());
                    String queueName = AMQTopic.getDurableTopicQueueName(subscriptionName, connection);
                    t.getLink().setName(queueName);
                    t.getLink().getSubscriptionQueue().setAutoDelete(false);
                    t.getLink().setDurable(true);
                    t.setQueueName(queueName);
                    t.setAutoDelete(false);
                    t.setDurable(true);
                    return t;
                }
                catch (Exception e) {
                    throw JMSExceptionHelper.chainJMSException(new JMSException("Error creating durable topic"), e);
                }
            }
            return new AMQTopic(qpidTopic.getExchangeName(), qpidTopic.getExchangeClass(), qpidTopic.getRoutingKey(), false, AMQTopic.getDurableTopicQueueName(subscriptionName, connection), true);
        }
        throw new InvalidDestinationException("The destination object used is not from this provider or of type javax.jms.Topic");
    }

    public static String getDurableTopicQueueName(String subscriptionName, AMQConnection connection) throws JMSException {
        return connection.getClientID() + ":" + subscriptionName;
    }

    public String getTopicName() throws JMSException {
        if (this.getRoutingKey() != null) {
            return this.getRoutingKey();
        }
        if (this.getSubject() != null) {
            return this.getSubject();
        }
        return null;
    }

    @Override
    public String getExchangeName() {
        if (super.getExchangeName() == null && super.getAddressName() != null) {
            return super.getAddressName();
        }
        return super.getExchangeName();
    }

    @Override
    public String getRoutingKey() {
        if (super.getRoutingKey() != null) {
            return super.getRoutingKey();
        }
        if (this.getSubject() != null) {
            return this.getSubject();
        }
        this.setRoutingKey("");
        this.setSubject("");
        return super.getRoutingKey();
    }

    @Override
    public boolean isNameRequired() {
        return !this.isDurable();
    }

    @Override
    public boolean equals(Object o) {
        if (this.getDestSyntax() == AMQDestination.DestSyntax.ADDR) {
            return super.equals(o);
        }
        return o instanceof AMQTopic && ((AMQTopic)o).getExchangeName().equals(this.getExchangeName()) && ((AMQTopic)o).getRoutingKey().equals(this.getRoutingKey());
    }

    @Override
    public int hashCode() {
        if (this.getDestSyntax() == AMQDestination.DestSyntax.ADDR) {
            return super.hashCode();
        }
        return this.getExchangeName().hashCode() + this.getRoutingKey().hashCode();
    }
}

