/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import org.apache.qpid.AMQDisconnectedException;
import org.apache.qpid.client.AMQConnection;
import org.apache.qpid.client.AMQProtocolHandler;
import org.apache.qpid.client.failover.FailoverState;
import org.apache.qpid.client.state.AMQState;
import org.apache.qpid.client.state.AMQStateManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailoverHandler
implements Runnable {
    private static final Logger _logger = LoggerFactory.getLogger(FailoverHandler.class);
    private final AMQProtocolHandler _amqProtocolHandler;

    public FailoverHandler(AMQProtocolHandler amqProtocolHandler) {
        this._amqProtocolHandler = amqProtocolHandler;
    }

    @Override
    public void run() {
        AMQConnection connection = this._amqProtocolHandler.getConnection();
        this._amqProtocolHandler.failoverInProgress();
        AMQStateManager existingStateManager = this._amqProtocolHandler.getStateManager();
        this._amqProtocolHandler.setStateManager(new AMQStateManager());
        if (!connection.firePreFailover(false)) {
            _logger.info("Failover process veto-ed by client");
            this._amqProtocolHandler.setStateManager(existingStateManager);
            AMQDisconnectedException cause = new AMQDisconnectedException("Failover was vetoed by client", null);
            connection.closed((Throwable)cause);
            return;
        }
        _logger.info("Starting failover process");
        boolean failoverSucceeded = connection.attemptReconnection();
        if (!failoverSucceeded) {
            this._amqProtocolHandler.setStateManager(existingStateManager);
            connection.closed((Throwable)new AMQDisconnectedException("Server closed connection and no failover was successful", null));
        } else {
            existingStateManager.setProtocolSession(this._amqProtocolHandler.getProtocolSession());
            if (existingStateManager.getCurrentState() != AMQState.CONNECTION_OPEN) {
                existingStateManager.clearLastException();
                existingStateManager.changeState(AMQState.CONNECTION_OPEN);
            }
            this._amqProtocolHandler.setStateManager(existingStateManager);
            try {
                if (connection.firePreResubscribe()) {
                    _logger.info("Resubscribing on new connection");
                    connection.resubscribeSessions();
                } else {
                    _logger.info("Client vetoed automatic resubscription");
                }
                connection.fireFailoverComplete();
                this._amqProtocolHandler.setFailoverState(FailoverState.NOT_STARTED);
                _logger.info("Connection failover completed successfully");
            }
            catch (Exception e) {
                _logger.info("Failover process failed - exception being propagated by protocol handler");
                this._amqProtocolHandler.setFailoverState(FailoverState.FAILED);
                this._amqProtocolHandler.exception(e);
            }
        }
    }
}

