/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import org.apache.qpid.QpidException;
import org.apache.qpid.client.AMQConnection;
import org.apache.qpid.client.AMQConnectionURL;
import org.apache.qpid.client.CommonConnection;
import org.apache.qpid.client.util.JMSExceptionHelper;
import org.apache.qpid.jms.ConnectionURL;
import org.apache.qpid.jndi.ObjectFactory;
import org.apache.qpid.url.URLSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledConnectionFactory
implements ConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory,
Referenceable {
    public static final String JNDI_ADDRESS_MAX_POOL_SIZE = "maxPoolSize";
    public static final String JNDI_ADDRESS_CONNECTION_TIMEOUT = "connectionTimeout";
    private static final Logger LOGGER = LoggerFactory.getLogger(PooledConnectionFactory.class);
    private static final AtomicInteger POOL_ID = new AtomicInteger();
    private static final ScheduledExecutorService SCHEDULER = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){
        private ThreadGroup _group;
        {
            SecurityManager securityManager = System.getSecurityManager();
            this._group = securityManager == null ? Thread.currentThread().getThreadGroup() : securityManager.getThreadGroup();
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(this._group, runnable, PooledConnectionFactory.class.getSimpleName() + "-Reaper");
            if (!thread.isDaemon()) {
                thread.setDaemon(true);
            }
            return thread;
        }
    });
    private final AtomicInteger _maxPoolSize = new AtomicInteger(10);
    private final AtomicLong _connectionTimeout = new AtomicLong(30000L);
    private final AtomicReference<ConnectionURL> _connectionDetails = new AtomicReference();
    private final transient AtomicInteger _connectionInstanceId = new AtomicInteger();
    private final transient int _poolId = POOL_ID.incrementAndGet();
    private final transient byte[] _factoryId = new byte[16];
    private final transient Map<ConnectionDetailsIdentifier, List<ConnectionHolder>> _pool = Collections.synchronizedMap(new HashMap());
    private final transient Runnable _connectionReaper = new Runnable(){

        @Override
        public void run() {
            PooledConnectionFactory.this._reaperScheduled.set(false);
            if (PooledConnectionFactory.this.removeExpiredConnections()) {
                PooledConnectionFactory.this.scheduleReaper();
            }
        }
    };
    private final transient AtomicBoolean _reaperScheduled = new AtomicBoolean();

    public PooledConnectionFactory() {
        Random random = new Random();
        random.nextBytes(this._factoryId);
    }

    private void scheduleReaper() {
        if (this._reaperScheduled.compareAndSet(false, true)) {
            SCHEDULER.schedule(this._connectionReaper, this._connectionTimeout.get(), TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeExpiredConnections() {
        try {
            ArrayList<List<ConnectionHolder>> pooledConnections;
            boolean scheduleAgain = false;
            Map<ConnectionDetailsIdentifier, List<ConnectionHolder>> map = this._pool;
            synchronized (map) {
                pooledConnections = new ArrayList<List<ConnectionHolder>>(this._pool.values());
            }
            if (!pooledConnections.isEmpty()) {
                long now = System.currentTimeMillis();
                Iterator iterator = pooledConnections.iterator();
                while (iterator.hasNext()) {
                    List connections;
                    List list = connections = (List)iterator.next();
                    synchronized (list) {
                        this.removeExpiredConnections(connections, now);
                        scheduleAgain = scheduleAgain || !connections.isEmpty();
                    }
                }
            }
            return scheduleAgain;
        }
        catch (RuntimeException e) {
            LOGGER.warn("Error encountered in " + PooledConnectionFactory.class.getSimpleName() + " reaper", (Throwable)e);
            return true;
        }
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return this.getConnectionFromPool();
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        return this.getConnectionFromPool(userName, password);
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return this.getConnectionFromPool();
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        return this.getConnectionFromPool(userName, password);
    }

    public Connection createConnection() throws JMSException {
        return this.getConnectionFromPool();
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        return this.getConnectionFromPool(userName, password);
    }

    private CommonConnection getConnectionFromPool() throws JMSException {
        ConnectionURL connectionDetails = this.getConnectionURLOrError();
        ConnectionDetailsIdentifier identity = ConnectionDetailsIdentifier.newInstance(this._factoryId, connectionDetails.getURL(), connectionDetails.getUsername(), connectionDetails.getPassword());
        return this.getConnectionFromPool(connectionDetails, identity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommonConnection getConnectionFromPool(ConnectionURL connectionDetails, ConnectionDetailsIdentifier identity) throws JMSException {
        CommonConnection underlying = null;
        Map<ConnectionDetailsIdentifier, List<ConnectionHolder>> map = this._pool;
        synchronized (map) {
            List<ConnectionHolder> pooledConnections = this._pool.get(identity);
            if (pooledConnections != null) {
                List<ConnectionHolder> list = pooledConnections;
                synchronized (list) {
                    if (!pooledConnections.isEmpty()) {
                        ConnectionHolder holder = pooledConnections.remove(pooledConnections.size() - 1);
                        underlying = holder._connection;
                    }
                }
            }
        }
        try {
            if (underlying == null) {
                underlying = this.newConnectionInstance(connectionDetails);
            }
            return this.proxyConnection(underlying, identity);
        }
        catch (QpidException e) {
            throw JMSExceptionHelper.chainJMSException(new JMSException("Error creating connection: " + e.getMessage()), e);
        }
    }

    protected CommonConnection newConnectionInstance(ConnectionURL connectionDetails) throws QpidException {
        return new AMQConnection(connectionDetails);
    }

    private ConnectionURL getConnectionURLOrError() throws IllegalStateException {
        ConnectionURL connectionDetails = this._connectionDetails.get();
        if (connectionDetails == null) {
            throw new IllegalStateException("Cannot create a connection when the connection URL has not yet been set");
        }
        return connectionDetails;
    }

    private CommonConnection getConnectionFromPool(String user, String password) throws JMSException {
        ConnectionURL connectionDetails = this.getConnectionURLOrError();
        ConnectionDetailsIdentifier identity = ConnectionDetailsIdentifier.newInstance(this._factoryId, connectionDetails.getURL(), user, password);
        try {
            connectionDetails = new AMQConnectionURL(connectionDetails.getURL());
            connectionDetails.setUsername(user);
            connectionDetails.setPassword(password);
        }
        catch (URLSyntaxException e) {
            throw JMSExceptionHelper.chainJMSException(new JMSException("Error creating connection: " + e.getMessage()), e);
        }
        return this.getConnectionFromPool(connectionDetails, identity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void returnToPool(CommonConnection connection, ConnectionDetailsIdentifier identityHash) throws JMSException {
        if (!connection.isClosed()) {
            List<ConnectionHolder> connections;
            connection.stop();
            Object object = this._pool;
            synchronized (object) {
                connections = this._pool.get(identityHash);
                if (connections == null) {
                    connections = new ArrayList<ConnectionHolder>();
                    this._pool.put(identityHash, connections);
                    this.scheduleReaper();
                }
            }
            object = connections;
            synchronized (object) {
                if (connections.size() < this._maxPoolSize.get()) {
                    connections.add(new ConnectionHolder(connection, System.currentTimeMillis()));
                } else {
                    connection.close();
                }
            }
        }
    }

    private void removeExpiredConnections(List<ConnectionHolder> connections, long now) {
        long expiryTime = now - this._connectionTimeout.get();
        Iterator<ConnectionHolder> iter = connections.iterator();
        while (iter.hasNext()) {
            ConnectionHolder ch = iter.next();
            if (ch._lastUse >= expiryTime) continue;
            iter.remove();
            try {
                ch._connection.close();
            }
            catch (RuntimeException | JMSException e) {
                LOGGER.warn("Error when closing expired connection in pool", e);
            }
        }
    }

    public int getMaxPoolSize() {
        return this._maxPoolSize.get();
    }

    public long getConnectionTimeout() {
        return this._connectionTimeout.get();
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this._maxPoolSize.set(maxPoolSize);
    }

    public void setConnectionTimeout(long timeout) {
        this._connectionTimeout.set(timeout);
    }

    public synchronized ConnectionURL getConnectionURL() {
        return this._connectionDetails.get();
    }

    public synchronized String getConnectionURLString() {
        return this._connectionDetails.toString();
    }

    public final synchronized void setConnectionURLString(String url) throws URLSyntaxException {
        AMQConnectionURL connectionDetails = new AMQConnectionURL(url);
        if (!this._connectionDetails.compareAndSet(null, connectionDetails)) {
            throw new IllegalArgumentException("Cannot change factory URL after it has already been set");
        }
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference reference = new Reference(PooledConnectionFactory.class.getName(), new StringRefAddr("connectionURL", this._connectionDetails.get().getURL()), ObjectFactory.class.getName(), null);
        reference.add(new StringRefAddr(JNDI_ADDRESS_MAX_POOL_SIZE, String.valueOf(this.getMaxPoolSize())));
        reference.add(new StringRefAddr(JNDI_ADDRESS_CONNECTION_TIMEOUT, String.valueOf(this.getConnectionTimeout())));
        return reference;
    }

    private CommonConnection proxyConnection(CommonConnection underlying, ConnectionDetailsIdentifier identifier) throws JMSException {
        ConnectionInvocationHandler invocationHandler = new ConnectionInvocationHandler(underlying, identifier);
        return (CommonConnection)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{CommonConnection.class}, (InvocationHandler)invocationHandler);
    }

    private <X extends Session> X proxySession(X underlying, ConnectionInvocationHandler connectionHandler) {
        ArrayList<Class> interfaces = new ArrayList<Class>();
        interfaces.add(Session.class);
        if (underlying instanceof org.apache.qpid.jms.Session) {
            interfaces.add(org.apache.qpid.jms.Session.class);
        }
        if (underlying instanceof TopicSession) {
            interfaces.add(TopicSession.class);
        }
        if (underlying instanceof QueueSession) {
            interfaces.add(QueueSession.class);
        }
        return (X)((Session)Proxy.newProxyInstance(this.getClass().getClassLoader(), interfaces.toArray(new Class[interfaces.size()]), (InvocationHandler)new SessionInvocationHandler(this, underlying, connectionHandler)));
    }

    private class ConnectionHolder {
        private final CommonConnection _connection;
        private final long _lastUse;

        public ConnectionHolder(CommonConnection connection, long lastUse) {
            this._connection = connection;
            this._lastUse = lastUse;
        }
    }

    private static class ConnectionDetailsIdentifier {
        private final byte[] _urlHash;
        private final String _user;
        private final byte[] _userPasswordHash;

        private static ConnectionDetailsIdentifier newInstance(byte[] id, String url, String user, String password) {
            try {
                MessageDigest digest = MessageDigest.getInstance("SHA-256");
                digest.update(id);
                digest.update(url.getBytes(StandardCharsets.UTF_8));
                byte[] urlHash = digest.digest();
                digest.update(id);
                if (user != null) {
                    digest.update(user.getBytes(StandardCharsets.UTF_8));
                }
                if (password != null) {
                    digest.update(password.getBytes(StandardCharsets.UTF_8));
                }
                byte[] userPasswordHash = digest.digest();
                return new ConnectionDetailsIdentifier(urlHash, user == null ? "" : user, userPasswordHash);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("SHA-256 not found, however compliant Java implementations should always provide SHA-256", e);
            }
        }

        private ConnectionDetailsIdentifier(byte[] urlHash, String user, byte[] userPasswordHash) {
            this._urlHash = urlHash;
            this._user = user;
            this._userPasswordHash = userPasswordHash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConnectionDetailsIdentifier that = (ConnectionDetailsIdentifier)o;
            if (!Arrays.equals(this._urlHash, that._urlHash)) {
                return false;
            }
            if (!this._user.equals(that._user)) {
                return false;
            }
            return Arrays.equals(this._userPasswordHash, that._userPasswordHash);
        }

        public int hashCode() {
            int result = Arrays.hashCode(this._urlHash);
            result = 31 * result + this._user.hashCode();
            result = 31 * result + Arrays.hashCode(this._userPasswordHash);
            return result;
        }
    }

    private static class SessionInvocationHandler<X extends Session>
    implements InvocationHandler {
        private final X _underlying;
        private final ConnectionInvocationHandler _connectionHandler;
        final /* synthetic */ PooledConnectionFactory this$0;

        public SessionInvocationHandler(X underlying, ConnectionInvocationHandler connectionHandler) {
            this.this$0 = var1_1;
            this._underlying = underlying;
            this._connectionHandler = connectionHandler;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Method underlyingMethod = this._underlying.getClass().getMethod(method.getName(), method.getParameterTypes());
            try {
                Object returnVal = underlyingMethod.invoke(this._underlying, args);
                if (method.getName().equals("close") && method.getParameterTypes().length == 0) {
                    this._connectionHandler.removeSession((Session)proxy);
                }
                return returnVal;
            }
            catch (InvocationTargetException e) {
                this._connectionHandler._exceptionThrown = true;
                Throwable thrown = e.getCause();
                throw thrown == null ? e : thrown;
            }
        }
    }

    private class ConnectionInvocationHandler
    implements InvocationHandler,
    ExceptionListener {
        private final CommonConnection _underlyingConnection;
        private final ConnectionDetailsIdentifier _identityHash;
        private boolean _closed;
        private volatile boolean _exceptionThrown;
        private final List<Session> _openSessions = new ArrayList<Session>();
        private volatile ExceptionListener _exceptionListener;
        private final int _instanceId;

        public ConnectionInvocationHandler(CommonConnection underlying, ConnectionDetailsIdentifier identityHash) throws JMSException {
            this._underlyingConnection = underlying;
            this._underlyingConnection.setExceptionListener(this);
            this._identityHash = identityHash;
            this._instanceId = PooledConnectionFactory.this._connectionInstanceId.incrementAndGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (this._closed) {
                throw new IllegalStateException("Connection is closed");
            }
            Method underlyingMethod = this._underlyingConnection.getClass().getMethod(method.getName(), method.getParameterTypes());
            if (method.getName().equals("getExceptionListener")) {
                return this._exceptionListener;
            }
            if (method.getName().equals("setExceptionListener") && method.getParameterTypes().length == 1 && method.getParameterTypes()[0].equals(ExceptionListener.class)) {
                this._exceptionListener = (ExceptionListener)args[0];
                return null;
            }
            if (method.getName().equals("close") && method.getParameterTypes().length == 0) {
                this._closed = true;
                this._exceptionListener = null;
                ArrayList<Session> openSessions = new ArrayList<Session>(this._openSessions);
                for (Session session : openSessions) {
                    try {
                        session.close();
                    }
                    catch (Error | RuntimeException | JMSException e) {
                        this._exceptionThrown = true;
                        try {
                            this._underlyingConnection.close();
                        }
                        finally {
                            throw e;
                        }
                    }
                }
                this._openSessions.clear();
                if (!this._exceptionThrown) {
                    PooledConnectionFactory.this.returnToPool(this._underlyingConnection, this._identityHash);
                } else {
                    this._underlyingConnection.close();
                }
                return null;
            }
            if (method.getName().equals("toString") && method.getParameterTypes().length == 0) {
                try {
                    Object returnVal = underlyingMethod.invoke((Object)this._underlyingConnection, args);
                    return "[Pool:" + PooledConnectionFactory.this._poolId + "][conn:" + this._instanceId + "]: " + String.valueOf(returnVal);
                }
                catch (InvocationTargetException e) {
                    this._exceptionThrown = true;
                    Throwable thrown = e.getCause();
                    throw thrown == null ? e : thrown;
                }
            }
            try {
                Object returnVal = underlyingMethod.invoke((Object)this._underlyingConnection, args);
                if (returnVal instanceof Session) {
                    returnVal = PooledConnectionFactory.this.proxySession((Session)returnVal, this);
                    this._openSessions.add((Session)returnVal);
                }
                return returnVal;
            }
            catch (InvocationTargetException e) {
                this._exceptionThrown = true;
                Throwable thrown = e.getCause();
                throw thrown == null ? e : thrown;
            }
        }

        public void onException(JMSException exception) {
            this._exceptionThrown = true;
            ExceptionListener exceptionListener = this._exceptionListener;
            if (exceptionListener != null) {
                exceptionListener.onException(exception);
            }
        }

        public synchronized void removeSession(Session session) {
            this._openSessions.remove(session);
        }
    }
}

