/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.handler;

import org.apache.qpid.QpidException;
import org.apache.qpid.client.failover.ConnectionRedirectException;
import org.apache.qpid.client.protocol.AMQProtocolSession;
import org.apache.qpid.client.state.StateAwareMethodListener;
import org.apache.qpid.framing.ConnectionRedirectBody;
import org.apache.qpid.transport.ByteBufferSender;
import org.apache.qpid.transport.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionRedirectMethodHandler
implements StateAwareMethodListener<ConnectionRedirectBody> {
    private static final Logger _logger = LoggerFactory.getLogger(ConnectionRedirectMethodHandler.class);
    private static final int DEFAULT_REDIRECT_PORT = 5672;
    private static ConnectionRedirectMethodHandler _handler = new ConnectionRedirectMethodHandler();

    public static ConnectionRedirectMethodHandler getInstance() {
        return _handler;
    }

    private ConnectionRedirectMethodHandler() {
    }

    @Override
    public void methodReceived(AMQProtocolSession session, ConnectionRedirectBody method, int channelId) throws QpidException {
        int port;
        _logger.info("ConnectionRedirect frame received");
        String host = method.getHost().toString();
        int portIndex = host.indexOf(58);
        if (portIndex == -1) {
            port = 5672;
        } else {
            port = Integer.parseInt(host.substring(portIndex + 1));
            host = host.substring(0, portIndex);
        }
        session.notifyError((Exception)((Object)new ConnectionRedirectException(host, port)));
        ByteBufferSender sender = session.getSender();
        try {
            sender.close();
        }
        catch (TransportException e) {
            // empty catch block
        }
    }
}

