/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.nio.ByteBuffer;
import org.apache.qpid.QpidException;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyImpl;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.EncodableAMQDataBlock;
import org.apache.qpid.framing.EncodingUtils;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.ServerChannelMethodProcessor;
import org.apache.qpid.util.ByteBufferUtils;

public class BasicConsumeBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 60;
    public static final int METHOD_ID = 20;
    private final int _ticket;
    private final AMQShortString _queue;
    private final AMQShortString _consumerTag;
    private final byte _bitfield0;
    private final FieldTable _arguments;

    public BasicConsumeBody(int ticket, AMQShortString queue, AMQShortString consumerTag, boolean noLocal, boolean noAck, boolean exclusive, boolean nowait, FieldTable arguments) {
        this._ticket = ticket;
        this._queue = queue;
        this._consumerTag = consumerTag;
        byte bitfield0 = 0;
        if (noLocal) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        if (noAck) {
            bitfield0 = (byte)(bitfield0 | 2);
        }
        if (exclusive) {
            bitfield0 = (byte)(bitfield0 | 4);
        }
        if (nowait) {
            bitfield0 = (byte)(bitfield0 | 8);
        }
        this._bitfield0 = bitfield0;
        this._arguments = arguments;
    }

    @Override
    public int getClazz() {
        return 60;
    }

    @Override
    public int getMethod() {
        return 20;
    }

    public final int getTicket() {
        return this._ticket;
    }

    public final AMQShortString getQueue() {
        return this._queue;
    }

    public final AMQShortString getConsumerTag() {
        return this._consumerTag;
    }

    public final boolean getNoLocal() {
        return (this._bitfield0 & 1) != 0;
    }

    public final boolean getNoAck() {
        return (this._bitfield0 & 2) != 0;
    }

    public final boolean getExclusive() {
        return (this._bitfield0 & 4) != 0;
    }

    public final boolean getNowait() {
        return (this._bitfield0 & 8) != 0;
    }

    public final FieldTable getArguments() {
        return this._arguments;
    }

    @Override
    protected int getBodySize() {
        int size = 3;
        size += this.getSizeOf(this._queue);
        size += this.getSizeOf(this._consumerTag);
        return size += this.getSizeOf(this._arguments);
    }

    @Override
    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeUnsignedShort(buffer, this._ticket);
        this.writeAMQShortString(buffer, this._queue);
        this.writeAMQShortString(buffer, this._consumerTag);
        this.writeBitfield(buffer, this._bitfield0);
        this.writeFieldTable(buffer, this._arguments);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchBasicConsume(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[BasicConsumeBodyImpl: ");
        buf.append("ticket=");
        buf.append(this.getTicket());
        buf.append(", ");
        buf.append("queue=");
        buf.append(this.getQueue());
        buf.append(", ");
        buf.append("consumerTag=");
        buf.append(this.getConsumerTag());
        buf.append(", ");
        buf.append("noLocal=");
        buf.append(this.getNoLocal());
        buf.append(", ");
        buf.append("noAck=");
        buf.append(this.getNoAck());
        buf.append(", ");
        buf.append("exclusive=");
        buf.append(this.getExclusive());
        buf.append(", ");
        buf.append("nowait=");
        buf.append(this.getNowait());
        buf.append(", ");
        buf.append("arguments=");
        buf.append(this.getArguments());
        buf.append("]");
        return buf.toString();
    }

    public static void process(ByteBuffer buffer, ServerChannelMethodProcessor dispatcher) throws AMQFrameDecodingException {
        int ticket = ByteBufferUtils.getUnsignedShort(buffer);
        AMQShortString queue = AMQShortString.readAMQShortString(buffer);
        AMQShortString consumerTag = AMQShortString.readAMQShortString(buffer);
        byte bitfield = buffer.get();
        boolean noLocal = (bitfield & 1) == 1;
        boolean noAck = (bitfield & 2) == 2;
        boolean exclusive = (bitfield & 4) == 4;
        boolean nowait = (bitfield & 8) == 8;
        FieldTable arguments = EncodingUtils.readFieldTable(buffer);
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveBasicConsume(queue, consumerTag, noLocal, noAck, exclusive, nowait, arguments);
        }
        if (arguments != null) {
            arguments.clearEncodedForm();
        }
    }
}

