/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.messaging.address;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.qpid.client.AMQDestination;
import org.apache.qpid.client.messaging.address.Link;
import org.apache.qpid.client.messaging.address.Node;
import org.apache.qpid.configuration.Accessor;
import org.apache.qpid.messaging.Address;

public class AddressHelper {
    public static final String NODE = "node";
    public static final String LINK = "link";
    public static final String X_DECLARE = "x-declare";
    public static final String X_BINDINGS = "x-bindings";
    public static final String X_SUBSCRIBES = "x-subscribes";
    public static final String X_SUBSCRIBE = "x-subscribe";
    public static final String X_SEND_ENCRYPTED = "x-send-encrypted";
    public static final String X_ENCRYPTED_RECIPIENTS = "x-encrypted-recipients";
    public static final String CREATE = "create";
    public static final String ASSERT = "assert";
    public static final String DELETE = "delete";
    public static final String FILTER = "filter";
    public static final String NO_LOCAL = "no-local";
    public static final String DURABLE = "durable";
    public static final String EXCLUSIVE = "exclusive";
    public static final String AUTO_DELETE = "auto-delete";
    public static final String TYPE = "type";
    public static final String ALT_EXCHANGE = "alternate-exchange";
    public static final String BINDINGS = "bindings";
    public static final String BROWSE = "browse";
    public static final String MODE = "mode";
    public static final String CAPACITY = "capacity";
    public static final String CAPACITY_SOURCE = "source";
    public static final String CAPACITY_TARGET = "target";
    public static final String NAME = "name";
    public static final String EXCHANGE = "exchange";
    public static final String QUEUE = "queue";
    public static final String KEY = "key";
    public static final String ARGUMENTS = "arguments";
    public static final String RELIABILITY = "reliability";
    private Address _address;
    private Accessor _addressPropAccess;
    private Accessor _nodePropAccess;
    private Accessor _linkPropAccess;
    private Map _addressPropMap;
    private Map _nodePropMap;
    private Map _linkPropMap;
    private boolean _sendEncrypted;
    private String _encryptedRecipients;

    public AddressHelper(Address address) {
        this._address = address;
        this._addressPropMap = address.getOptions();
        this._addressPropAccess = new Accessor.MapAccessor(this._addressPropMap);
        Map map = this._nodePropMap = address.getOptions() == null || address.getOptions().get(NODE) == null ? null : (Map)address.getOptions().get(NODE);
        if (this._nodePropMap != null) {
            this._nodePropAccess = new Accessor.MapAccessor(this._nodePropMap);
        }
        Map map2 = this._linkPropMap = address.getOptions() == null || address.getOptions().get(LINK) == null ? null : (Map)address.getOptions().get(LINK);
        if (this._linkPropMap != null) {
            this._linkPropAccess = new Accessor.MapAccessor(this._linkPropMap);
        }
    }

    public String getCreate() {
        return this._addressPropAccess.getString(CREATE);
    }

    public String getAssert() {
        return this._addressPropAccess.getString(ASSERT);
    }

    public String getDelete() {
        return this._addressPropAccess.getString(DELETE);
    }

    public boolean isBrowseOnly() {
        String mode = this._addressPropAccess.getString(MODE);
        return mode != null && mode.equals(BROWSE);
    }

    public List<AMQDestination.Binding> getBindings(Map props) {
        List bindingList;
        List list = bindingList = props == null ? Collections.EMPTY_LIST : (List)props.get(X_BINDINGS);
        if (bindingList != null && !bindingList.isEmpty()) {
            ArrayList<AMQDestination.Binding> bindings = new ArrayList<AMQDestination.Binding>(bindingList.size());
            for (Map bindingMap : bindingList) {
                AMQDestination.Binding binding = new AMQDestination.Binding((String)bindingMap.get(EXCHANGE), (String)bindingMap.get(QUEUE), (String)bindingMap.get(KEY), bindingMap.get(ARGUMENTS) == null ? Collections.EMPTY_MAP : (Map)bindingMap.get(ARGUMENTS));
                bindings.add(binding);
            }
            return bindings;
        }
        return Collections.emptyList();
    }

    public Map getDeclareArgs(Map props) {
        if (props != null && props.get(X_DECLARE) != null) {
            return (Map)props.get(X_DECLARE);
        }
        return Collections.EMPTY_MAP;
    }

    public int getNodeType() {
        if (this._nodePropAccess == null || this._nodePropAccess.getString(TYPE) == null) {
            return 3;
        }
        if (this._nodePropAccess.getString(TYPE).equals(QUEUE)) {
            return 1;
        }
        if (this._nodePropAccess.getString(TYPE).equals("topic")) {
            return 2;
        }
        throw new IllegalArgumentException("unknown exchange type");
    }

    public Node getNode() {
        Node node = new Node(this._address.getName());
        if (this._nodePropAccess != null) {
            Map xDeclareMap = this.getDeclareArgs(this._nodePropMap);
            Accessor.MapAccessor xDeclareMapAccessor = new Accessor.MapAccessor(xDeclareMap);
            node.setDurable(this.getBooleanProperty(this._nodePropAccess, DURABLE, false));
            node.setAutoDelete(this.getBooleanProperty(xDeclareMapAccessor, AUTO_DELETE, false));
            node.setExclusive(this.getBooleanProperty(xDeclareMapAccessor, EXCLUSIVE, false));
            node.setAlternateExchange(xDeclareMapAccessor.getString(ALT_EXCHANGE));
            if (xDeclareMapAccessor.getString(TYPE) != null) {
                node.setExchangeType(xDeclareMapAccessor.getString(TYPE));
            }
            node.setBindings(this.getBindings(this._nodePropMap));
            if (!xDeclareMap.isEmpty() && xDeclareMap.containsKey(ARGUMENTS)) {
                node.setDeclareArgs((Map)xDeclareMap.get(ARGUMENTS));
            }
        }
        return node;
    }

    private boolean getBooleanProperty(Accessor access, String propName, boolean defaultValue) {
        Boolean result = access.getBoolean(propName);
        return result == null ? defaultValue : result;
    }

    public Link getLink() {
        Link link = new Link();
        link.setSubscription(new Link.Subscription());
        link.setSubscriptionQueue(new Link.SubscriptionQueue());
        if (this._linkPropAccess != null) {
            String localAddress;
            Long delay;
            link.setDurable(this.getBooleanProperty(this._linkPropAccess, DURABLE, false));
            link.setName(this._linkPropAccess.getString(NAME));
            String reliability = this._linkPropAccess.getString(RELIABILITY);
            if (reliability != null) {
                if (reliability.equalsIgnoreCase("unreliable")) {
                    link.setReliability(Link.Reliability.UNRELIABLE);
                } else if (reliability.equalsIgnoreCase("at-least-once")) {
                    link.setReliability(Link.Reliability.AT_LEAST_ONCE);
                } else {
                    throw new IllegalArgumentException("The reliability mode '" + reliability + "' is not yet supported");
                }
            }
            if ((delay = this._linkPropAccess.getLong("delay")) != null) {
                link.setDelay(delay);
            }
            if ((localAddress = this._linkPropAccess.getString("localAddress")) != null) {
                link.setLocalAddress(localAddress);
            }
            if (((Map)this._address.getOptions().get(LINK)).get(CAPACITY) instanceof Map) {
                Accessor.MapAccessor capacityProps = new Accessor.MapAccessor((Map)((Map)this._address.getOptions().get(LINK)).get(CAPACITY));
                Integer sourceCapacity = capacityProps.getInt(CAPACITY_SOURCE);
                link.setConsumerCapacity(sourceCapacity == null ? -1 : sourceCapacity);
                Integer targetCapacity = capacityProps.getInt(CAPACITY_TARGET);
                link.setProducerCapacity(targetCapacity == null ? -1 : targetCapacity);
            } else {
                int cap = this._linkPropAccess.getInt(CAPACITY) == null ? -1 : this._linkPropAccess.getInt(CAPACITY);
                link.setConsumerCapacity(cap);
                link.setProducerCapacity(cap);
            }
            link.setFilter(this._linkPropAccess.getString(FILTER));
            Map linkMap = (Map)this._address.getOptions().get(LINK);
            if (linkMap != null) {
                Map x_subscribe = null;
                if (linkMap.containsKey(X_SUBSCRIBE)) {
                    x_subscribe = (Map)((Map)this._address.getOptions().get(LINK)).get(X_SUBSCRIBE);
                } else if (linkMap.containsKey(X_SUBSCRIBES)) {
                    x_subscribe = (Map)((Map)this._address.getOptions().get(LINK)).get(X_SUBSCRIBES);
                }
                if (x_subscribe != null) {
                    if (x_subscribe.containsKey(ARGUMENTS)) {
                        link.getSubscription().setArgs((Map)x_subscribe.get(ARGUMENTS));
                    }
                    boolean exclusive = x_subscribe.containsKey(EXCLUSIVE) ? Boolean.parseBoolean((String)x_subscribe.get(EXCLUSIVE)) : false;
                    link.getSubscription().setExclusive(exclusive);
                }
            }
            link.setBindings(this.getBindings(linkMap));
            Map xDeclareMap = this.getDeclareArgs(linkMap);
            Link.SubscriptionQueue queue = link.getSubscriptionQueue();
            if (!xDeclareMap.isEmpty() && xDeclareMap.containsKey(ARGUMENTS)) {
                Accessor.MapAccessor xDeclareMapAccessor = new Accessor.MapAccessor(xDeclareMap);
                queue.setAutoDelete(this.getBooleanProperty(xDeclareMapAccessor, AUTO_DELETE, true));
                queue.setExclusive(this.getBooleanProperty(xDeclareMapAccessor, EXCLUSIVE, true));
                queue.setAlternateExchange(xDeclareMapAccessor.getString(ALT_EXCHANGE));
                queue.setDeclareArgs((Map)xDeclareMap.get(ARGUMENTS));
            }
        }
        return link;
    }

    public boolean getSendEncrypted() {
        return Boolean.TRUE.equals(this._addressPropAccess.getBoolean(X_SEND_ENCRYPTED));
    }

    public String getEncryptedRecipients() {
        return this._addressPropAccess.getString(X_ENCRYPTED_RECIPIENTS);
    }
}

