/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport.network.security.ssl;

import java.io.IOException;
import java.net.Socket;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import org.apache.qpid.transport.network.security.ssl.SSLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QpidClientX509KeyManager
extends X509ExtendedKeyManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(QpidClientX509KeyManager.class);
    private X509ExtendedKeyManager delegate;
    private String alias;

    public QpidClientX509KeyManager(String alias, String keyStorePath, String keyStoreType, String keyStorePassword, String keyManagerFactoryAlgorithmName) throws GeneralSecurityException, IOException {
        this.alias = alias;
        KeyStore ks = SSLUtil.getInitializedKeyStore(keyStorePath, keyStorePassword, keyStoreType);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(keyManagerFactoryAlgorithmName);
        kmf.init(ks, keyStorePassword.toCharArray());
        this.delegate = (X509ExtendedKeyManager)kmf.getKeyManagers()[0];
    }

    public QpidClientX509KeyManager(String alias, URL keyStoreUrl, String keyStoreType, String keyStorePassword, String keyManagerFactoryAlgorithmName) throws GeneralSecurityException, IOException {
        this.alias = alias;
        KeyStore ks = SSLUtil.getInitializedKeyStore(keyStoreUrl, keyStorePassword, keyStoreType);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(keyManagerFactoryAlgorithmName);
        kmf.init(ks, keyStorePassword.toCharArray());
        this.delegate = (X509ExtendedKeyManager)kmf.getKeyManagers()[0];
    }

    public QpidClientX509KeyManager(String alias, KeyStore ks, String keyStorePassword, String keyManagerFactoryAlgorithmName) throws GeneralSecurityException, IOException {
        this.alias = alias;
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(keyManagerFactoryAlgorithmName);
        kmf.init(ks, keyStorePassword.toCharArray());
        this.delegate = (X509ExtendedKeyManager)kmf.getKeyManagers()[0];
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        LOGGER.debug("chooseClientAlias:Returning alias {}", (Object)this.alias);
        return this.alias;
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return this.delegate.chooseServerAlias(keyType, issuers, socket);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        return this.delegate.getCertificateChain(alias);
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        LOGGER.debug("getClientAliases:Returning alias {}", (Object)this.alias);
        return new String[]{this.alias};
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return this.delegate.getPrivateKey(alias);
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.delegate.getServerAliases(keyType, issuers);
    }

    @Override
    public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
        LOGGER.debug("chooseEngineClientAlias:Returning alias {}", (Object)this.alias);
        return this.alias;
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        return this.delegate.chooseEngineServerAlias(keyType, issuers, engine);
    }
}

