/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.security.scram;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.apache.qpid.util.Base64;
import org.apache.qpid.util.Strings;

public abstract class AbstractScramSaslClient
implements SaslClient {
    private static final byte[] INT_1 = new byte[]{0, 0, 0, 1};
    private static final String GS2_HEADER = "n,,";
    private static final Charset ASCII = Charset.forName("ASCII");
    private final String _digestName;
    private final String _hmacName;
    private String _username;
    private final String _clientNonce;
    private String _serverNonce;
    private byte[] _salt;
    private int _iterationCount;
    private String _clientFirstMessageBare;
    private byte[] _serverSignature;
    public final String _mechanism;
    private final CallbackHandler _callbackHandler;
    private State _state = State.INITIAL;

    public AbstractScramSaslClient(CallbackHandler cbh, String mechanism, String digestName, String hmacName, String clientNonce) {
        this._callbackHandler = cbh;
        this._mechanism = mechanism;
        this._digestName = digestName;
        this._hmacName = hmacName;
        this._clientNonce = clientNonce;
    }

    @Override
    public String getMechanismName() {
        return this._mechanism;
    }

    @Override
    public boolean hasInitialResponse() {
        return true;
    }

    @Override
    public byte[] evaluateChallenge(byte[] challenge) throws SaslException {
        byte[] response;
        switch (this._state) {
            case INITIAL: {
                response = this.initialResponse();
                this._state = State.CLIENT_FIRST_SENT;
                break;
            }
            case CLIENT_FIRST_SENT: {
                response = this.calculateClientProof(challenge);
                this._state = State.CLIENT_PROOF_SENT;
                break;
            }
            case CLIENT_PROOF_SENT: {
                this.evaluateOutcome(challenge);
                response = new byte[]{};
                this._state = State.COMPLETE;
                break;
            }
            default: {
                throw new SaslException("No challenge expected in state " + (Object)((Object)this._state));
            }
        }
        return response;
    }

    private void evaluateOutcome(byte[] challenge) throws SaslException {
        byte[] serverSignature;
        String serverFinalMessage = new String(challenge, ASCII);
        String[] parts = serverFinalMessage.split(",");
        if (!parts[0].startsWith("v=")) {
            throw new SaslException("Server final message did not contain verifier");
        }
        try {
            serverSignature = Strings.decodeBase64(parts[0].substring(2));
        }
        catch (IllegalArgumentException e) {
            throw new SaslException("Server signature did not match");
        }
        if (!Arrays.equals(this._serverSignature, serverSignature)) {
            throw new SaslException("Server signature did not match");
        }
    }

    private byte[] calculateClientProof(byte[] challenge) throws SaslException {
        try {
            String serverFirstMessage = new String(challenge, ASCII);
            String[] parts = serverFirstMessage.split(",");
            if (parts.length < 3) {
                throw new SaslException("Server challenge '" + serverFirstMessage + "' cannot be parsed");
            }
            if (parts[0].startsWith("m=")) {
                throw new SaslException("Server requires mandatory extension which is not supported: " + parts[0]);
            }
            if (!parts[0].startsWith("r=")) {
                throw new SaslException("Server challenge '" + serverFirstMessage + "' cannot be parsed, cannot find nonce");
            }
            String nonce = parts[0].substring(2);
            if (!nonce.startsWith(this._clientNonce)) {
                throw new SaslException("Server challenge did not use correct client nonce");
            }
            this._serverNonce = nonce;
            if (!parts[1].startsWith("s=")) {
                throw new SaslException("Server challenge '" + serverFirstMessage + "' cannot be parsed, cannot find salt");
            }
            String base64Salt = parts[1].substring(2);
            this._salt = Strings.decodeBase64(base64Salt);
            if (!parts[2].startsWith("i=")) {
                throw new SaslException("Server challenge '" + serverFirstMessage + "' cannot be parsed, cannot find iteration count");
            }
            String iterCountString = parts[2].substring(2);
            this._iterationCount = Integer.parseInt(iterCountString);
            if (this._iterationCount <= 0) {
                throw new SaslException("Iteration count " + this._iterationCount + " is not a positive integer");
            }
            PasswordCallback passwordCallback = new PasswordCallback("Password", false);
            this._callbackHandler.handle(new Callback[]{passwordCallback});
            byte[] passwordBytes = this.saslPrep(new String(passwordCallback.getPassword())).getBytes("UTF-8");
            byte[] saltedPassword = this.generateSaltedPassword(passwordBytes);
            String clientFinalMessageWithoutProof = "c=" + Base64.encode(GS2_HEADER.getBytes(ASCII)) + ",r=" + this._serverNonce;
            String authMessage = this._clientFirstMessageBare + "," + serverFirstMessage + "," + clientFinalMessageWithoutProof;
            byte[] clientKey = this.computeHmac(saltedPassword, "Client Key");
            byte[] storedKey = MessageDigest.getInstance(this._digestName).digest(clientKey);
            byte[] clientSignature = this.computeHmac(storedKey, authMessage);
            byte[] clientProof = (byte[])clientKey.clone();
            for (int i = 0; i < clientProof.length; ++i) {
                int n = i;
                clientProof[n] = (byte)(clientProof[n] ^ clientSignature[i]);
            }
            byte[] serverKey = this.computeHmac(saltedPassword, "Server Key");
            this._serverSignature = this.computeHmac(serverKey, authMessage);
            String finalMessageWithProof = clientFinalMessageWithoutProof + ",p=" + Base64.encode(clientProof);
            return finalMessageWithProof.getBytes();
        }
        catch (UnsupportedEncodingException e) {
            throw new SaslException(e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new SaslException(e.getMessage(), e);
        }
        catch (UnsupportedCallbackException e) {
            throw new SaslException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new SaslException(e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SaslException(e.getMessage(), e);
        }
    }

    private byte[] computeHmac(byte[] key, String string) throws SaslException, UnsupportedEncodingException {
        Mac mac = this.createHmac(key);
        mac.update(string.getBytes(ASCII));
        return mac.doFinal();
    }

    private byte[] generateSaltedPassword(byte[] passwordBytes) throws SaslException {
        Mac mac = this.createHmac(passwordBytes);
        mac.update(this._salt);
        mac.update(INT_1);
        byte[] result = mac.doFinal();
        byte[] previous = null;
        for (int i = 1; i < this._iterationCount; ++i) {
            mac.update(previous != null ? previous : result);
            previous = mac.doFinal();
            for (int x = 0; x < result.length; ++x) {
                int n = x;
                result[n] = (byte)(result[n] ^ previous[x]);
            }
        }
        return result;
    }

    private Mac createHmac(byte[] keyBytes) throws SaslException {
        try {
            SecretKeySpec key = new SecretKeySpec(keyBytes, this._hmacName);
            Mac mac = Mac.getInstance(this._hmacName);
            mac.init(key);
            return mac;
        }
        catch (NoSuchAlgorithmException e) {
            throw new SaslException(e.getMessage(), e);
        }
        catch (InvalidKeyException e) {
            throw new SaslException(e.getMessage(), e);
        }
    }

    private byte[] initialResponse() throws SaslException {
        try {
            StringBuffer buf = new StringBuffer("n=");
            NameCallback nameCallback = new NameCallback("Username?");
            this._callbackHandler.handle(new Callback[]{nameCallback});
            this._username = nameCallback.getName();
            buf.append(this.escapeUsername(this.saslPrep(this._username)));
            buf.append(",r=");
            buf.append(this._clientNonce);
            this._clientFirstMessageBare = buf.toString();
            return (GS2_HEADER + this._clientFirstMessageBare).getBytes(ASCII);
        }
        catch (UnsupportedCallbackException e) {
            throw new SaslException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new SaslException(e.getMessage(), e);
        }
    }

    private String saslPrep(String name) throws SaslException {
        if (!ASCII.newEncoder().canEncode(name)) {
            throw new SaslException("Can only encode names and passwords which are restricted to ASCII characters");
        }
        return name;
    }

    private String escapeUsername(String name) {
        name = name.replace("=", "=3D");
        name = name.replace(",", "=2C");
        return name;
    }

    @Override
    public boolean isComplete() {
        return this._state == State.COMPLETE;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        throw new IllegalStateException("No security layer supported");
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        throw new IllegalStateException("No security layer supported");
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        return null;
    }

    @Override
    public void dispose() throws SaslException {
    }

    static enum State {
        INITIAL,
        CLIENT_FIRST_SENT,
        CLIENT_PROOF_SENT,
        COMPLETE;

    }
}

