/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.qpid.QpidException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyImpl;
import org.apache.qpid.framing.ClientChannelMethodProcessor;
import org.apache.qpid.framing.EncodableAMQDataBlock;
import org.apache.qpid.framing.EncodingUtils;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.ProtocolVersion;

public class ChannelOpenOkBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 20;
    public static final int METHOD_ID = 11;
    public static final ChannelOpenOkBody INSTANCE_0_8 = new ChannelOpenOkBody(true);
    public static final ChannelOpenOkBody INSTANCE_0_9 = new ChannelOpenOkBody(false);
    private final boolean _isAMQP08;

    public static ChannelOpenOkBody getInstance(ProtocolVersion protocolVersion, ByteBuffer input) throws IOException {
        ChannelOpenOkBody instance;
        boolean isAMQP08 = ProtocolVersion.v0_8.equals(protocolVersion);
        ChannelOpenOkBody channelOpenOkBody = instance = isAMQP08 ? INSTANCE_0_8 : INSTANCE_0_9;
        if (!isAMQP08) {
            EncodingUtils.readBytes(input);
        }
        return instance;
    }

    private ChannelOpenOkBody(boolean isAMQP08) {
        this._isAMQP08 = isAMQP08;
    }

    @Override
    public int getClazz() {
        return 20;
    }

    @Override
    public int getMethod() {
        return 11;
    }

    @Override
    protected int getBodySize() {
        return this._isAMQP08 ? 0 : 4;
    }

    @Override
    public void writeMethodPayload(ByteBuffer buffer) {
        if (!this._isAMQP08) {
            buffer.putInt(0);
        }
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchChannelOpenOk(this, channelId);
    }

    @Override
    public String toString() {
        return "[ChannelOpenOkBody]";
    }

    public static void process(ByteBuffer in, ProtocolVersion protocolVersion, ClientChannelMethodProcessor dispatcher) {
        if (!ProtocolVersion.v0_8.equals(protocolVersion)) {
            EncodingUtils.readBytes(in);
        }
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveChannelOpenOk();
        }
    }
}

