/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.util;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;

public class Base64 {
    private static final char PAD = '=';
    private static final char[] BASE64_ENCODE = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final int MASK_8BITS = 255;
    private static final int MASK_6BITS = 63;
    private static final int[] BASE64_DECODE = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};

    public static String encode(byte[] data) {
        int i;
        StringBuilder encoded = new StringBuilder(4 * ((data.length + 2) / 3));
        int triples = data.length / 3 * 3;
        for (i = 0; i < triples; i += 3) {
            int bits = (data[i] & 0xFF) << 16 | (data[i + 1] & 0xFF) << 8 | data[i + 2] & 0xFF;
            encoded.append(BASE64_ENCODE[bits >>> 18 & 0x3F]);
            encoded.append(BASE64_ENCODE[bits >>> 12 & 0x3F]);
            encoded.append(BASE64_ENCODE[bits >>> 6 & 0x3F]);
            encoded.append(BASE64_ENCODE[bits & 0x3F]);
        }
        if (i < data.length) {
            int remaining1 = data[i] & 0xFF;
            encoded.append(BASE64_ENCODE[remaining1 >> 2]);
            if (i == data.length - 1) {
                encoded.append(BASE64_ENCODE[remaining1 << 4 & 0x3F]);
                encoded.append('=');
                encoded.append('=');
            } else {
                int remaining2 = data[i + 1] & 0xFF;
                encoded.append(BASE64_ENCODE[remaining1 << 4 & 0x3F | remaining2 >> 4]);
                encoded.append(BASE64_ENCODE[remaining2 << 2 & 0x3F]);
                encoded.append('=');
            }
        }
        return encoded.toString();
    }

    public static byte[] decode(String data) {
        byte[] bytes = data.getBytes(StandardCharsets.ISO_8859_1);
        int decodeSize = 3 * ((bytes.length + 3) / 4) - ((bytes.length & 3) != 0 ? 4 - (bytes.length & 3) : 0);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(decodeSize);
        for (int i = 0; i < bytes.length; i += 4) {
            int b = 0;
            int byteCounter = 0;
            if (Base64.check(bytes, i, byteCounter)) {
                b = Base64.get(bytes, i, byteCounter) << 18;
                if (Base64.check(bytes, i, ++byteCounter)) {
                    b |= Base64.get(bytes, i, byteCounter) << 12;
                    if (Base64.check(bytes, i, ++byteCounter)) {
                        b |= Base64.get(bytes, i, byteCounter) << 6;
                        if (Base64.check(bytes, i, ++byteCounter)) {
                            b |= Base64.get(bytes, i, byteCounter);
                            ++byteCounter;
                        }
                    }
                }
            }
            if (byteCounter == 4) {
                buffer.write((byte)(b >> 16) & 0xFF);
                buffer.write((byte)(b >> 8) & 0xFF);
                buffer.write((byte)b & 0xFF);
                continue;
            }
            if (byteCounter == 3) {
                buffer.write((byte)(b >> 16) & 0xFF);
                buffer.write((byte)(b >> 8) & 0xFF);
                continue;
            }
            if (byteCounter == 2) {
                buffer.write((byte)(b >> 16) & 0xFF);
                continue;
            }
            throw new IllegalArgumentException("Malformed data");
        }
        return buffer.toByteArray();
    }

    private static int get(byte[] bytes, int index, int shift) {
        int i = index + shift;
        if (i >= 0 && i < bytes.length) {
            int b = bytes[i] & 0xFF;
            if (b == 61) {
                throw new IllegalArgumentException(String.format("Unexpected padding detected at position %d", i));
            }
            int d = BASE64_DECODE[b];
            if (d < 0) {
                throw new IllegalArgumentException(String.format("Unexpected character '%x' at position %d", b, i));
            }
            return d & 0xFF;
        }
        throw new IllegalArgumentException("Unexpected index");
    }

    private static boolean check(byte[] bytes, int index, int shift) {
        int i = index + shift;
        if (i < bytes.length) {
            int b = bytes[i] & 0xFF;
            if (b == 61) {
                if (shift == 0) {
                    throw new IllegalArgumentException(String.format("Unexpected padding detected at position %d", i));
                }
                if (shift == 2 && (i == bytes.length - 2 && bytes[i + 1] != 61 || i == bytes.length - 1 && bytes[i - 1] != 61)) {
                    throw new IllegalArgumentException("Missing padding");
                }
                if (shift != 2 && i < bytes.length - 1) {
                    throw new IllegalArgumentException(String.format("Unexpected padding detected at position %d", i));
                }
                return false;
            }
            if (BASE64_DECODE[b] < 0) {
                throw new IllegalArgumentException(String.format("Unexpected character '%x' at position %d", b, i));
            }
            return true;
        }
        return false;
    }
}

