/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.dtx;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Arrays;
import org.apache.qpid.AMQInvalidArgumentException;
import org.apache.qpid.transport.Xid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XidImpl
implements javax.transaction.xa.Xid {
    private static final Logger _logger = LoggerFactory.getLogger(XidImpl.class);
    private byte[] _branchQualifier;
    private int _formatID;
    private byte[] _globalTransactionID;

    public XidImpl() {
    }

    public XidImpl(javax.transaction.xa.Xid xid) {
        this._branchQualifier = xid.getBranchQualifier();
        this._formatID = xid.getFormatId();
        this._globalTransactionID = xid.getGlobalTransactionId();
    }

    public XidImpl(byte[] branchQualifier, int format, byte[] globalTransactionID) {
        this._branchQualifier = branchQualifier;
        this._formatID = format;
        this._globalTransactionID = globalTransactionID;
    }

    public XidImpl(String xid) throws AMQInvalidArgumentException {
        if (_logger.isDebugEnabled()) {
            _logger.debug("converting string " + xid + " into XidImpl");
        }
        try {
            DataInputStream input = new DataInputStream(new ByteArrayInputStream(xid.getBytes()));
            this._formatID = (int)input.readLong();
            byte g = input.readByte();
            byte b = input.readByte();
            this._globalTransactionID = new byte[g];
            this._branchQualifier = new byte[b];
            if (input.read(this._globalTransactionID, 0, g) != g) {
                throw new AMQInvalidArgumentException("Cannot convert the string " + xid + " into an Xid", null);
            }
            if (input.read(this._branchQualifier, 0, b) != b) {
                throw new AMQInvalidArgumentException("Cannot convert the string " + xid + " into an Xid", null);
            }
        }
        catch (IOException e) {
            throw new AMQInvalidArgumentException("cannot convert the string " + xid + " into an Xid", e);
        }
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this._globalTransactionID;
    }

    @Override
    public byte[] getBranchQualifier() {
        return this._branchQualifier;
    }

    @Override
    public int getFormatId() {
        return this._formatID;
    }

    public boolean equals(Object o) {
        XidImpl other;
        if (this == o) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass() && this._formatID == (other = (XidImpl)o).getFormatId() && this._branchQualifier.length == other.getBranchQualifier().length) {
            int i;
            for (i = 0; i < this._branchQualifier.length; ++i) {
                if (this._branchQualifier[i] == other.getBranchQualifier()[i]) continue;
                return false;
            }
            if (this._globalTransactionID.length == other.getGlobalTransactionId().length) {
                for (i = 0; i < this._globalTransactionID.length; ++i) {
                    if (this._globalTransactionID[i] == other.getGlobalTransactionId()[i]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int result = this._branchQualifier != null ? Arrays.hashCode(this._branchQualifier) : 0;
        result = 31 * result + this._formatID;
        result = 31 * result + (this._globalTransactionID != null ? Arrays.hashCode(this._globalTransactionID) : 0);
        return result;
    }

    public static Xid convert(javax.transaction.xa.Xid xid) {
        return new Xid(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
    }
}

