



/*
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */

/*
 * This file is auto-generated by Qpid Gentools v.0.1 - do not modify.
 * Supported AMQP version:
 *   0-9
 */
 
 
package org.apache.qpid.framing.amqp_0_9;

import java.util.HashMap;

import org.apache.mina.common.ByteBuffer;
import org.apache.qpid.framing.*;
import org.apache.qpid.AMQException;

public class MessageOpenBodyImpl extends AMQMethodBody_0_9 implements MessageOpenBody
{
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory()
    {
        public AMQMethodBody newInstance(ByteBuffer in, long size) throws AMQFrameDecodingException
        {
            return new MessageOpenBodyImpl(in);
        }
		
 
    };
    
	
    public static AMQMethodBodyInstanceFactory getFactory()
    {
        return FACTORY_INSTANCE;
    }

    public static final int CLASS_ID =  120; 
    
    public static final int METHOD_ID = 60; 
    

	
    // Fields declared in specification
    private final byte[] _reference; // [reference]

    
    // Constructor

    public MessageOpenBodyImpl(ByteBuffer buffer) throws AMQFrameDecodingException
    {
        _reference = readBytes( buffer );
	}
	
    public MessageOpenBodyImpl(
                                byte[] reference
                            )
    {
        _reference = reference;
    }
    
    public int getClazz() 
    { 
        return CLASS_ID; 
    }
    
    public int getMethod() 
    { 
        return METHOD_ID; 
    }

    
    public final byte[] getReference()
    {
        return _reference;
    }

    protected int getBodySize()
    {      
	    int size = 0;
        size += getSizeOf( _reference );
        return size;        
    }

    public void writeMethodPayload(ByteBuffer buffer)
    {
        writeBytes( buffer, _reference );
    }

    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException
	{
    return ((MethodDispatcher_0_9)dispatcher).dispatchMessageOpen(this, channelId);	

	    
	}
	
	
    public String toString()
    {
        StringBuilder buf = new StringBuilder("[MessageOpenBodyImpl: ");
        buf.append( "reference=" );
		buf.append(  getReference() == null  ? "null" : java.util.Arrays.toString( getReference() ) );
        buf.append("]");
        return buf.toString();
    }


}
