/*
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */

/*
 * This file is auto-generated by Qpid Gentools v.0.1 - do not modify.
 * Supported AMQP version:
 *   8-0
 */
 
package org.apache.qpid.framing.amqp_8_0;

import org.apache.qpid.framing.*;
import org.apache.qpid.protocol.AMQConstant;


import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.apache.mina.common.ByteBuffer;

import org.apache.qpid.framing.abstraction.ProtocolVersionMethodConverter;


public class MethodRegistry_8_0 extends MethodRegistry
{
	
    private static final Logger _log = LoggerFactory.getLogger(MethodRegistry.class);

	private ProtocolVersionMethodConverter _protocolVersionConverter = new MethodConverter_8_0();
	
	
	
	private final AMQMethodBodyInstanceFactory[][] _factories = new AMQMethodBodyInstanceFactory[121][];

	public MethodRegistry_8_0()
	{
	    this(new ProtocolVersion((byte)8,(byte)0));
    }
	
	public MethodRegistry_8_0(ProtocolVersion pv)
	{
        super(pv);	



		// Register method body instance factories for the Connection class.

        _factories[10] = new AMQMethodBodyInstanceFactory[62];
		
        _factories[10][10] = ConnectionStartBodyImpl.getFactory(); 
        _factories[10][11] = ConnectionStartOkBodyImpl.getFactory(); 
        _factories[10][20] = ConnectionSecureBodyImpl.getFactory(); 
        _factories[10][21] = ConnectionSecureOkBodyImpl.getFactory(); 
        _factories[10][30] = ConnectionTuneBodyImpl.getFactory(); 
        _factories[10][31] = ConnectionTuneOkBodyImpl.getFactory(); 
        _factories[10][40] = ConnectionOpenBodyImpl.getFactory(); 
        _factories[10][41] = ConnectionOpenOkBodyImpl.getFactory(); 
        _factories[10][50] = ConnectionRedirectBodyImpl.getFactory(); 
        _factories[10][60] = ConnectionCloseBodyImpl.getFactory(); 
        _factories[10][61] = ConnectionCloseOkBodyImpl.getFactory(); 
		



		// Register method body instance factories for the Channel class.

        _factories[20] = new AMQMethodBodyInstanceFactory[42];
		
        _factories[20][10] = ChannelOpenBodyImpl.getFactory(); 
        _factories[20][11] = ChannelOpenOkBodyImpl.getFactory(); 
        _factories[20][20] = ChannelFlowBodyImpl.getFactory(); 
        _factories[20][21] = ChannelFlowOkBodyImpl.getFactory(); 
        _factories[20][30] = ChannelAlertBodyImpl.getFactory(); 
        _factories[20][40] = ChannelCloseBodyImpl.getFactory(); 
        _factories[20][41] = ChannelCloseOkBodyImpl.getFactory(); 
		



		// Register method body instance factories for the Access class.

        _factories[30] = new AMQMethodBodyInstanceFactory[12];
		
        _factories[30][10] = AccessRequestBodyImpl.getFactory(); 
        _factories[30][11] = AccessRequestOkBodyImpl.getFactory(); 
		



		// Register method body instance factories for the Exchange class.

        _factories[40] = new AMQMethodBodyInstanceFactory[24];
		
        _factories[40][10] = ExchangeDeclareBodyImpl.getFactory(); 
        _factories[40][11] = ExchangeDeclareOkBodyImpl.getFactory(); 
        _factories[40][20] = ExchangeDeleteBodyImpl.getFactory(); 
        _factories[40][21] = ExchangeDeleteOkBodyImpl.getFactory(); 
        _factories[40][22] = ExchangeBoundBodyImpl.getFactory(); 
        _factories[40][23] = ExchangeBoundOkBodyImpl.getFactory(); 
		



		// Register method body instance factories for the Queue class.

        _factories[50] = new AMQMethodBodyInstanceFactory[42];
		
        _factories[50][10] = QueueDeclareBodyImpl.getFactory(); 
        _factories[50][11] = QueueDeclareOkBodyImpl.getFactory(); 
        _factories[50][20] = QueueBindBodyImpl.getFactory(); 
        _factories[50][21] = QueueBindOkBodyImpl.getFactory(); 
        _factories[50][30] = QueuePurgeBodyImpl.getFactory(); 
        _factories[50][31] = QueuePurgeOkBodyImpl.getFactory(); 
        _factories[50][40] = QueueDeleteBodyImpl.getFactory(); 
        _factories[50][41] = QueueDeleteOkBodyImpl.getFactory(); 
		



		// Register method body instance factories for the Basic class.

        _factories[60] = new AMQMethodBodyInstanceFactory[102];
		
        _factories[60][10] = BasicQosBodyImpl.getFactory(); 
        _factories[60][11] = BasicQosOkBodyImpl.getFactory(); 
        _factories[60][20] = BasicConsumeBodyImpl.getFactory(); 
        _factories[60][21] = BasicConsumeOkBodyImpl.getFactory(); 
        _factories[60][30] = BasicCancelBodyImpl.getFactory(); 
        _factories[60][31] = BasicCancelOkBodyImpl.getFactory(); 
        _factories[60][40] = BasicPublishBodyImpl.getFactory(); 
        _factories[60][50] = BasicReturnBodyImpl.getFactory(); 
        _factories[60][60] = BasicDeliverBodyImpl.getFactory(); 
        _factories[60][70] = BasicGetBodyImpl.getFactory(); 
        _factories[60][71] = BasicGetOkBodyImpl.getFactory(); 
        _factories[60][72] = BasicGetEmptyBodyImpl.getFactory(); 
        _factories[60][80] = BasicAckBodyImpl.getFactory(); 
        _factories[60][90] = BasicRejectBodyImpl.getFactory(); 
        _factories[60][100] = BasicRecoverBodyImpl.getFactory(); 
        _factories[60][101] = BasicRecoverOkBodyImpl.getFactory(); 
		



		// Register method body instance factories for the File class.

        _factories[70] = new AMQMethodBodyInstanceFactory[101];
		
        _factories[70][10] = FileQosBodyImpl.getFactory(); 
        _factories[70][11] = FileQosOkBodyImpl.getFactory(); 
        _factories[70][20] = FileConsumeBodyImpl.getFactory(); 
        _factories[70][21] = FileConsumeOkBodyImpl.getFactory(); 
        _factories[70][30] = FileCancelBodyImpl.getFactory(); 
        _factories[70][31] = FileCancelOkBodyImpl.getFactory(); 
        _factories[70][40] = FileOpenBodyImpl.getFactory(); 
        _factories[70][41] = FileOpenOkBodyImpl.getFactory(); 
        _factories[70][50] = FileStageBodyImpl.getFactory(); 
        _factories[70][60] = FilePublishBodyImpl.getFactory(); 
        _factories[70][70] = FileReturnBodyImpl.getFactory(); 
        _factories[70][80] = FileDeliverBodyImpl.getFactory(); 
        _factories[70][90] = FileAckBodyImpl.getFactory(); 
        _factories[70][100] = FileRejectBodyImpl.getFactory(); 
		



		// Register method body instance factories for the Stream class.

        _factories[80] = new AMQMethodBodyInstanceFactory[61];
		
        _factories[80][10] = StreamQosBodyImpl.getFactory(); 
        _factories[80][11] = StreamQosOkBodyImpl.getFactory(); 
        _factories[80][20] = StreamConsumeBodyImpl.getFactory(); 
        _factories[80][21] = StreamConsumeOkBodyImpl.getFactory(); 
        _factories[80][30] = StreamCancelBodyImpl.getFactory(); 
        _factories[80][31] = StreamCancelOkBodyImpl.getFactory(); 
        _factories[80][40] = StreamPublishBodyImpl.getFactory(); 
        _factories[80][50] = StreamReturnBodyImpl.getFactory(); 
        _factories[80][60] = StreamDeliverBodyImpl.getFactory(); 
		



		// Register method body instance factories for the Tx class.

        _factories[90] = new AMQMethodBodyInstanceFactory[32];
		
        _factories[90][10] = TxSelectBodyImpl.getFactory(); 
        _factories[90][11] = TxSelectOkBodyImpl.getFactory(); 
        _factories[90][20] = TxCommitBodyImpl.getFactory(); 
        _factories[90][21] = TxCommitOkBodyImpl.getFactory(); 
        _factories[90][30] = TxRollbackBodyImpl.getFactory(); 
        _factories[90][31] = TxRollbackOkBodyImpl.getFactory(); 
		



		// Register method body instance factories for the Dtx class.

        _factories[100] = new AMQMethodBodyInstanceFactory[22];
		
        _factories[100][10] = DtxSelectBodyImpl.getFactory(); 
        _factories[100][11] = DtxSelectOkBodyImpl.getFactory(); 
        _factories[100][20] = DtxStartBodyImpl.getFactory(); 
        _factories[100][21] = DtxStartOkBodyImpl.getFactory(); 
		



		// Register method body instance factories for the Tunnel class.

        _factories[110] = new AMQMethodBodyInstanceFactory[11];
		
        _factories[110][10] = TunnelRequestBodyImpl.getFactory(); 
		



		// Register method body instance factories for the Test class.

        _factories[120] = new AMQMethodBodyInstanceFactory[42];
		
        _factories[120][10] = TestIntegerBodyImpl.getFactory(); 
        _factories[120][11] = TestIntegerOkBodyImpl.getFactory(); 
        _factories[120][20] = TestStringBodyImpl.getFactory(); 
        _factories[120][21] = TestStringOkBodyImpl.getFactory(); 
        _factories[120][30] = TestTableBodyImpl.getFactory(); 
        _factories[120][31] = TestTableOkBodyImpl.getFactory(); 
        _factories[120][40] = TestContentBodyImpl.getFactory(); 
        _factories[120][41] = TestContentOkBodyImpl.getFactory(); 
		
		
		
	}


    public AMQMethodBody convertToBody(ByteBuffer in, long size)
        throws AMQFrameDecodingException
    {
	    int classId = in.getUnsignedShort();
		int methodId = in.getUnsignedShort();
	
        AMQMethodBodyInstanceFactory bodyFactory;
        try
        {
            bodyFactory = _factories[classId][methodId];
        }
        catch(NullPointerException e)
        {
            throw new AMQFrameDecodingException(AMQConstant.COMMAND_INVALID,
                "Class " + classId + " unknown in AMQP version 8-0"
                 + " (while trying to decode class " + classId + " method " + methodId + ".");
        }
        catch(IndexOutOfBoundsException e)
        {
            if(classId >= _factories.length)
            {
                throw new AMQFrameDecodingException(AMQConstant.COMMAND_INVALID,
                    "Class " + classId + " unknown in AMQP version 8-0"
                     + " (while trying to decode class " + classId + " method " + methodId + ".");

            }
            else
            {
                throw new AMQFrameDecodingException(AMQConstant.COMMAND_INVALID,
                    "Method " + methodId + " unknown in AMQP version 8-0"
                     + " (while trying to decode class " + classId + " method " + methodId + ".");

            }
        }


        if (bodyFactory == null)
        {
            throw new AMQFrameDecodingException(AMQConstant.COMMAND_INVALID,
                "Method " + methodId + " unknown in AMQP version 8-0"
                 + " (while trying to decode class " + classId + " method " + methodId + ".");
        }


        return bodyFactory.newInstance(in, size);


    }


    public int getMaxClassId()
	{
	    return 120;
	}
    
    public int getMaxMethodId(int classId)
	{
        return _factories[classId].length - 1;	
	}
	



		
    public ConnectionStartBody createConnectionStartBody(	
                                final short versionMajor,
                                final short versionMinor,
                                final FieldTable serverProperties,
                                final byte[] mechanisms,
                                final byte[] locales
	                        )
    {
	    return new ConnectionStartBodyImpl(
                                versionMajor,
                                versionMinor,
                                serverProperties,
                                mechanisms,
                                locales
		                    );
    }
    
    public ConnectionStartOkBody createConnectionStartOkBody(	
                                final FieldTable clientProperties,
                                final AMQShortString mechanism,
                                final byte[] response,
                                final AMQShortString locale
	                        )
    {
	    return new ConnectionStartOkBodyImpl(
                                clientProperties,
                                mechanism,
                                response,
                                locale
		                    );
    }
    
    public ConnectionSecureBody createConnectionSecureBody(	
                                final byte[] challenge
	                        )
    {
	    return new ConnectionSecureBodyImpl(
                                challenge
		                    );
    }
    
    public ConnectionSecureOkBody createConnectionSecureOkBody(	
                                final byte[] response
	                        )
    {
	    return new ConnectionSecureOkBodyImpl(
                                response
		                    );
    }
    
    public ConnectionTuneBody createConnectionTuneBody(	
                                final int channelMax,
                                final long frameMax,
                                final int heartbeat
	                        )
    {
	    return new ConnectionTuneBodyImpl(
                                channelMax,
                                frameMax,
                                heartbeat
		                    );
    }
    
    public ConnectionTuneOkBody createConnectionTuneOkBody(	
                                final int channelMax,
                                final long frameMax,
                                final int heartbeat
	                        )
    {
	    return new ConnectionTuneOkBodyImpl(
                                channelMax,
                                frameMax,
                                heartbeat
		                    );
    }
    
    public ConnectionOpenBody createConnectionOpenBody(	
                                final AMQShortString virtualHost,
                                final AMQShortString capabilities,
                                final boolean insist
	                        )
    {
	    return new ConnectionOpenBodyImpl(
                                virtualHost,
                                capabilities,
                                insist
		                    );
    }
    
    public ConnectionOpenOkBody createConnectionOpenOkBody(	
                                final AMQShortString knownHosts
	                        )
    {
	    return new ConnectionOpenOkBodyImpl(
                                knownHosts
		                    );
    }
    
    public ConnectionRedirectBody createConnectionRedirectBody(	
                                final AMQShortString host,
                                final AMQShortString knownHosts
	                        )
    {
	    return new ConnectionRedirectBodyImpl(
                                host,
                                knownHosts
		                    );
    }
    
    public ConnectionCloseBody createConnectionCloseBody(	
                                final int replyCode,
                                final AMQShortString replyText,
                                final int classId,
                                final int methodId
	                        )
    {
	    return new ConnectionCloseBodyImpl(
                                replyCode,
                                replyText,
                                classId,
                                methodId
		                    );
    }
    
    public ConnectionCloseOkBody createConnectionCloseOkBody(	
	                        )
    {
	    return new ConnectionCloseOkBodyImpl(
		                    );
    }
    
		

		
    public ChannelOpenBody createChannelOpenBody(	
                                final AMQShortString outOfBand
	                        )
    {
	    return new ChannelOpenBodyImpl(
                                outOfBand
		                    );
    }
    
    public ChannelOpenOkBody createChannelOpenOkBody(	
	                        )
    {
	    return new ChannelOpenOkBodyImpl(
		                    );
    }
    
    public ChannelFlowBody createChannelFlowBody(	
                                final boolean active
	                        )
    {
	    return new ChannelFlowBodyImpl(
                                active
		                    );
    }
    
    public ChannelFlowOkBody createChannelFlowOkBody(	
                                final boolean active
	                        )
    {
	    return new ChannelFlowOkBodyImpl(
                                active
		                    );
    }
    
    public ChannelAlertBody createChannelAlertBody(	
                                final int replyCode,
                                final AMQShortString replyText,
                                final FieldTable details
	                        )
    {
	    return new ChannelAlertBodyImpl(
                                replyCode,
                                replyText,
                                details
		                    );
    }
    
    public ChannelCloseBody createChannelCloseBody(	
                                final int replyCode,
                                final AMQShortString replyText,
                                final int classId,
                                final int methodId
	                        )
    {
	    return new ChannelCloseBodyImpl(
                                replyCode,
                                replyText,
                                classId,
                                methodId
		                    );
    }
    
    public ChannelCloseOkBody createChannelCloseOkBody(	
	                        )
    {
	    return new ChannelCloseOkBodyImpl(
		                    );
    }
    
		

		
    public AccessRequestBody createAccessRequestBody(	
                                final AMQShortString realm,
                                final boolean exclusive,
                                final boolean passive,
                                final boolean active,
                                final boolean write,
                                final boolean read
	                        )
    {
	    return new AccessRequestBodyImpl(
                                realm,
                                exclusive,
                                passive,
                                active,
                                write,
                                read
		                    );
    }
    
    public AccessRequestOkBody createAccessRequestOkBody(	
                                final int ticket
	                        )
    {
	    return new AccessRequestOkBodyImpl(
                                ticket
		                    );
    }
    
		

		
    public ExchangeDeclareBody createExchangeDeclareBody(	
                                final int ticket,
                                final AMQShortString exchange,
                                final AMQShortString type,
                                final boolean passive,
                                final boolean durable,
                                final boolean autoDelete,
                                final boolean internal,
                                final boolean nowait,
                                final FieldTable arguments
	                        )
    {
	    return new ExchangeDeclareBodyImpl(
                                ticket,
                                exchange,
                                type,
                                passive,
                                durable,
                                autoDelete,
                                internal,
                                nowait,
                                arguments
		                    );
    }
    
    public ExchangeDeclareOkBody createExchangeDeclareOkBody(	
	                        )
    {
	    return new ExchangeDeclareOkBodyImpl(
		                    );
    }
    
    public ExchangeDeleteBody createExchangeDeleteBody(	
                                final int ticket,
                                final AMQShortString exchange,
                                final boolean ifUnused,
                                final boolean nowait
	                        )
    {
	    return new ExchangeDeleteBodyImpl(
                                ticket,
                                exchange,
                                ifUnused,
                                nowait
		                    );
    }
    
    public ExchangeDeleteOkBody createExchangeDeleteOkBody(	
	                        )
    {
	    return new ExchangeDeleteOkBodyImpl(
		                    );
    }
    
    public ExchangeBoundBody createExchangeBoundBody(	
                                final AMQShortString exchange,
                                final AMQShortString routingKey,
                                final AMQShortString queue
	                        )
    {
	    return new ExchangeBoundBodyImpl(
                                exchange,
                                routingKey,
                                queue
		                    );
    }
    
    public ExchangeBoundOkBody createExchangeBoundOkBody(	
                                final int replyCode,
                                final AMQShortString replyText
	                        )
    {
	    return new ExchangeBoundOkBodyImpl(
                                replyCode,
                                replyText
		                    );
    }
    
		

		
    public QueueDeclareBody createQueueDeclareBody(	
                                final int ticket,
                                final AMQShortString queue,
                                final boolean passive,
                                final boolean durable,
                                final boolean exclusive,
                                final boolean autoDelete,
                                final boolean nowait,
                                final FieldTable arguments
	                        )
    {
	    return new QueueDeclareBodyImpl(
                                ticket,
                                queue,
                                passive,
                                durable,
                                exclusive,
                                autoDelete,
                                nowait,
                                arguments
		                    );
    }
    
    public QueueDeclareOkBody createQueueDeclareOkBody(	
                                final AMQShortString queue,
                                final long messageCount,
                                final long consumerCount
	                        )
    {
	    return new QueueDeclareOkBodyImpl(
                                queue,
                                messageCount,
                                consumerCount
		                    );
    }
    
    public QueueBindBody createQueueBindBody(	
                                final int ticket,
                                final AMQShortString queue,
                                final AMQShortString exchange,
                                final AMQShortString routingKey,
                                final boolean nowait,
                                final FieldTable arguments
	                        )
    {
	    return new QueueBindBodyImpl(
                                ticket,
                                queue,
                                exchange,
                                routingKey,
                                nowait,
                                arguments
		                    );
    }
    
    public QueueBindOkBody createQueueBindOkBody(	
	                        )
    {
	    return new QueueBindOkBodyImpl(
		                    );
    }
    
    public QueuePurgeBody createQueuePurgeBody(	
                                final int ticket,
                                final AMQShortString queue,
                                final boolean nowait
	                        )
    {
	    return new QueuePurgeBodyImpl(
                                ticket,
                                queue,
                                nowait
		                    );
    }
    
    public QueuePurgeOkBody createQueuePurgeOkBody(	
                                final long messageCount
	                        )
    {
	    return new QueuePurgeOkBodyImpl(
                                messageCount
		                    );
    }
    
    public QueueDeleteBody createQueueDeleteBody(	
                                final int ticket,
                                final AMQShortString queue,
                                final boolean ifUnused,
                                final boolean ifEmpty,
                                final boolean nowait
	                        )
    {
	    return new QueueDeleteBodyImpl(
                                ticket,
                                queue,
                                ifUnused,
                                ifEmpty,
                                nowait
		                    );
    }
    
    public QueueDeleteOkBody createQueueDeleteOkBody(	
                                final long messageCount
	                        )
    {
	    return new QueueDeleteOkBodyImpl(
                                messageCount
		                    );
    }
    
		

		
    public BasicQosBody createBasicQosBody(	
                                final long prefetchSize,
                                final int prefetchCount,
                                final boolean global
	                        )
    {
	    return new BasicQosBodyImpl(
                                prefetchSize,
                                prefetchCount,
                                global
		                    );
    }
    
    public BasicQosOkBody createBasicQosOkBody(	
	                        )
    {
	    return new BasicQosOkBodyImpl(
		                    );
    }
    
    public BasicConsumeBody createBasicConsumeBody(	
                                final int ticket,
                                final AMQShortString queue,
                                final AMQShortString consumerTag,
                                final boolean noLocal,
                                final boolean noAck,
                                final boolean exclusive,
                                final boolean nowait,
                                final FieldTable arguments
	                        )
    {
	    return new BasicConsumeBodyImpl(
                                ticket,
                                queue,
                                consumerTag,
                                noLocal,
                                noAck,
                                exclusive,
                                nowait,
                                arguments
		                    );
    }
    
    public BasicConsumeOkBody createBasicConsumeOkBody(	
                                final AMQShortString consumerTag
	                        )
    {
	    return new BasicConsumeOkBodyImpl(
                                consumerTag
		                    );
    }
    
    public BasicCancelBody createBasicCancelBody(	
                                final AMQShortString consumerTag,
                                final boolean nowait
	                        )
    {
	    return new BasicCancelBodyImpl(
                                consumerTag,
                                nowait
		                    );
    }
    
    public BasicCancelOkBody createBasicCancelOkBody(	
                                final AMQShortString consumerTag
	                        )
    {
	    return new BasicCancelOkBodyImpl(
                                consumerTag
		                    );
    }
    
    public BasicPublishBody createBasicPublishBody(	
                                final int ticket,
                                final AMQShortString exchange,
                                final AMQShortString routingKey,
                                final boolean mandatory,
                                final boolean immediate
	                        )
    {
	    return new BasicPublishBodyImpl(
                                ticket,
                                exchange,
                                routingKey,
                                mandatory,
                                immediate
		                    );
    }
    
    public BasicReturnBody createBasicReturnBody(	
                                final int replyCode,
                                final AMQShortString replyText,
                                final AMQShortString exchange,
                                final AMQShortString routingKey
	                        )
    {
	    return new BasicReturnBodyImpl(
                                replyCode,
                                replyText,
                                exchange,
                                routingKey
		                    );
    }
    
    public BasicDeliverBody createBasicDeliverBody(	
                                final AMQShortString consumerTag,
                                final long deliveryTag,
                                final boolean redelivered,
                                final AMQShortString exchange,
                                final AMQShortString routingKey
	                        )
    {
	    return new BasicDeliverBodyImpl(
                                consumerTag,
                                deliveryTag,
                                redelivered,
                                exchange,
                                routingKey
		                    );
    }
    
    public BasicGetBody createBasicGetBody(	
                                final int ticket,
                                final AMQShortString queue,
                                final boolean noAck
	                        )
    {
	    return new BasicGetBodyImpl(
                                ticket,
                                queue,
                                noAck
		                    );
    }
    
    public BasicGetOkBody createBasicGetOkBody(	
                                final long deliveryTag,
                                final boolean redelivered,
                                final AMQShortString exchange,
                                final AMQShortString routingKey,
                                final long messageCount
	                        )
    {
	    return new BasicGetOkBodyImpl(
                                deliveryTag,
                                redelivered,
                                exchange,
                                routingKey,
                                messageCount
		                    );
    }
    
    public BasicGetEmptyBody createBasicGetEmptyBody(	
                                final AMQShortString clusterId
	                        )
    {
	    return new BasicGetEmptyBodyImpl(
                                clusterId
		                    );
    }
    
    public BasicAckBody createBasicAckBody(	
                                final long deliveryTag,
                                final boolean multiple
	                        )
    {
	    return new BasicAckBodyImpl(
                                deliveryTag,
                                multiple
		                    );
    }
    
    public BasicRejectBody createBasicRejectBody(	
                                final long deliveryTag,
                                final boolean requeue
	                        )
    {
	    return new BasicRejectBodyImpl(
                                deliveryTag,
                                requeue
		                    );
    }
    
    public BasicRecoverBody createBasicRecoverBody(	
                                final boolean requeue
	                        )
    {
	    return new BasicRecoverBodyImpl(
                                requeue
		                    );
    }
    
    public BasicRecoverOkBody createBasicRecoverOkBody(	
	                        )
    {
	    return new BasicRecoverOkBodyImpl(
		                    );
    }
    
		

		
    public FileQosBody createFileQosBody(	
                                final long prefetchSize,
                                final int prefetchCount,
                                final boolean global
	                        )
    {
	    return new FileQosBodyImpl(
                                prefetchSize,
                                prefetchCount,
                                global
		                    );
    }
    
    public FileQosOkBody createFileQosOkBody(	
	                        )
    {
	    return new FileQosOkBodyImpl(
		                    );
    }
    
    public FileConsumeBody createFileConsumeBody(	
                                final int ticket,
                                final AMQShortString queue,
                                final AMQShortString consumerTag,
                                final boolean noLocal,
                                final boolean noAck,
                                final boolean exclusive,
                                final boolean nowait
	                        )
    {
	    return new FileConsumeBodyImpl(
                                ticket,
                                queue,
                                consumerTag,
                                noLocal,
                                noAck,
                                exclusive,
                                nowait
		                    );
    }
    
    public FileConsumeOkBody createFileConsumeOkBody(	
                                final AMQShortString consumerTag
	                        )
    {
	    return new FileConsumeOkBodyImpl(
                                consumerTag
		                    );
    }
    
    public FileCancelBody createFileCancelBody(	
                                final AMQShortString consumerTag,
                                final boolean nowait
	                        )
    {
	    return new FileCancelBodyImpl(
                                consumerTag,
                                nowait
		                    );
    }
    
    public FileCancelOkBody createFileCancelOkBody(	
                                final AMQShortString consumerTag
	                        )
    {
	    return new FileCancelOkBodyImpl(
                                consumerTag
		                    );
    }
    
    public FileOpenBody createFileOpenBody(	
                                final AMQShortString identifier,
                                final long contentSize
	                        )
    {
	    return new FileOpenBodyImpl(
                                identifier,
                                contentSize
		                    );
    }
    
    public FileOpenOkBody createFileOpenOkBody(	
                                final long stagedSize
	                        )
    {
	    return new FileOpenOkBodyImpl(
                                stagedSize
		                    );
    }
    
    public FileStageBody createFileStageBody(	
	                        )
    {
	    return new FileStageBodyImpl(
		                    );
    }
    
    public FilePublishBody createFilePublishBody(	
                                final int ticket,
                                final AMQShortString exchange,
                                final AMQShortString routingKey,
                                final boolean mandatory,
                                final boolean immediate,
                                final AMQShortString identifier
	                        )
    {
	    return new FilePublishBodyImpl(
                                ticket,
                                exchange,
                                routingKey,
                                mandatory,
                                immediate,
                                identifier
		                    );
    }
    
    public FileReturnBody createFileReturnBody(	
                                final int replyCode,
                                final AMQShortString replyText,
                                final AMQShortString exchange,
                                final AMQShortString routingKey
	                        )
    {
	    return new FileReturnBodyImpl(
                                replyCode,
                                replyText,
                                exchange,
                                routingKey
		                    );
    }
    
    public FileDeliverBody createFileDeliverBody(	
                                final AMQShortString consumerTag,
                                final long deliveryTag,
                                final boolean redelivered,
                                final AMQShortString exchange,
                                final AMQShortString routingKey,
                                final AMQShortString identifier
	                        )
    {
	    return new FileDeliverBodyImpl(
                                consumerTag,
                                deliveryTag,
                                redelivered,
                                exchange,
                                routingKey,
                                identifier
		                    );
    }
    
    public FileAckBody createFileAckBody(	
                                final long deliveryTag,
                                final boolean multiple
	                        )
    {
	    return new FileAckBodyImpl(
                                deliveryTag,
                                multiple
		                    );
    }
    
    public FileRejectBody createFileRejectBody(	
                                final long deliveryTag,
                                final boolean requeue
	                        )
    {
	    return new FileRejectBodyImpl(
                                deliveryTag,
                                requeue
		                    );
    }
    
		

		
    public StreamQosBody createStreamQosBody(	
                                final long prefetchSize,
                                final int prefetchCount,
                                final long consumeRate,
                                final boolean global
	                        )
    {
	    return new StreamQosBodyImpl(
                                prefetchSize,
                                prefetchCount,
                                consumeRate,
                                global
		                    );
    }
    
    public StreamQosOkBody createStreamQosOkBody(	
	                        )
    {
	    return new StreamQosOkBodyImpl(
		                    );
    }
    
    public StreamConsumeBody createStreamConsumeBody(	
                                final int ticket,
                                final AMQShortString queue,
                                final AMQShortString consumerTag,
                                final boolean noLocal,
                                final boolean exclusive,
                                final boolean nowait
	                        )
    {
	    return new StreamConsumeBodyImpl(
                                ticket,
                                queue,
                                consumerTag,
                                noLocal,
                                exclusive,
                                nowait
		                    );
    }
    
    public StreamConsumeOkBody createStreamConsumeOkBody(	
                                final AMQShortString consumerTag
	                        )
    {
	    return new StreamConsumeOkBodyImpl(
                                consumerTag
		                    );
    }
    
    public StreamCancelBody createStreamCancelBody(	
                                final AMQShortString consumerTag,
                                final boolean nowait
	                        )
    {
	    return new StreamCancelBodyImpl(
                                consumerTag,
                                nowait
		                    );
    }
    
    public StreamCancelOkBody createStreamCancelOkBody(	
                                final AMQShortString consumerTag
	                        )
    {
	    return new StreamCancelOkBodyImpl(
                                consumerTag
		                    );
    }
    
    public StreamPublishBody createStreamPublishBody(	
                                final int ticket,
                                final AMQShortString exchange,
                                final AMQShortString routingKey,
                                final boolean mandatory,
                                final boolean immediate
	                        )
    {
	    return new StreamPublishBodyImpl(
                                ticket,
                                exchange,
                                routingKey,
                                mandatory,
                                immediate
		                    );
    }
    
    public StreamReturnBody createStreamReturnBody(	
                                final int replyCode,
                                final AMQShortString replyText,
                                final AMQShortString exchange,
                                final AMQShortString routingKey
	                        )
    {
	    return new StreamReturnBodyImpl(
                                replyCode,
                                replyText,
                                exchange,
                                routingKey
		                    );
    }
    
    public StreamDeliverBody createStreamDeliverBody(	
                                final AMQShortString consumerTag,
                                final long deliveryTag,
                                final AMQShortString exchange,
                                final AMQShortString queue
	                        )
    {
	    return new StreamDeliverBodyImpl(
                                consumerTag,
                                deliveryTag,
                                exchange,
                                queue
		                    );
    }
    
		

		
    public TxSelectBody createTxSelectBody(	
	                        )
    {
	    return new TxSelectBodyImpl(
		                    );
    }
    
    public TxSelectOkBody createTxSelectOkBody(	
	                        )
    {
	    return new TxSelectOkBodyImpl(
		                    );
    }
    
    public TxCommitBody createTxCommitBody(	
	                        )
    {
	    return new TxCommitBodyImpl(
		                    );
    }
    
    public TxCommitOkBody createTxCommitOkBody(	
	                        )
    {
	    return new TxCommitOkBodyImpl(
		                    );
    }
    
    public TxRollbackBody createTxRollbackBody(	
	                        )
    {
	    return new TxRollbackBodyImpl(
		                    );
    }
    
    public TxRollbackOkBody createTxRollbackOkBody(	
	                        )
    {
	    return new TxRollbackOkBodyImpl(
		                    );
    }
    
		

		
    public DtxSelectBody createDtxSelectBody(	
	                        )
    {
	    return new DtxSelectBodyImpl(
		                    );
    }
    
    public DtxSelectOkBody createDtxSelectOkBody(	
	                        )
    {
	    return new DtxSelectOkBodyImpl(
		                    );
    }
    
    public DtxStartBody createDtxStartBody(	
                                final AMQShortString dtxIdentifier
	                        )
    {
	    return new DtxStartBodyImpl(
                                dtxIdentifier
		                    );
    }
    
    public DtxStartOkBody createDtxStartOkBody(	
	                        )
    {
	    return new DtxStartOkBodyImpl(
		                    );
    }
    
		

		
    public TunnelRequestBody createTunnelRequestBody(	
                                final FieldTable metaData
	                        )
    {
	    return new TunnelRequestBodyImpl(
                                metaData
		                    );
    }
    
		

		
    public TestIntegerBody createTestIntegerBody(	
                                final short integer1,
                                final int integer2,
                                final long integer3,
                                final long integer4,
                                final short operation
	                        )
    {
	    return new TestIntegerBodyImpl(
                                integer1,
                                integer2,
                                integer3,
                                integer4,
                                operation
		                    );
    }
    
    public TestIntegerOkBody createTestIntegerOkBody(	
                                final long result
	                        )
    {
	    return new TestIntegerOkBodyImpl(
                                result
		                    );
    }
    
    public TestStringBody createTestStringBody(	
                                final AMQShortString string1,
                                final byte[] string2,
                                final short operation
	                        )
    {
	    return new TestStringBodyImpl(
                                string1,
                                string2,
                                operation
		                    );
    }
    
    public TestStringOkBody createTestStringOkBody(	
                                final byte[] result
	                        )
    {
	    return new TestStringOkBodyImpl(
                                result
		                    );
    }
    
    public TestTableBody createTestTableBody(	
                                final FieldTable table,
                                final short integerOp,
                                final short stringOp
	                        )
    {
	    return new TestTableBodyImpl(
                                table,
                                integerOp,
                                stringOp
		                    );
    }
    
    public TestTableOkBody createTestTableOkBody(	
                                final long integerResult,
                                final byte[] stringResult
	                        )
    {
	    return new TestTableOkBodyImpl(
                                integerResult,
                                stringResult
		                    );
    }
    
    public TestContentBody createTestContentBody(	
	                        )
    {
	    return new TestContentBodyImpl(
		                    );
    }
    
    public TestContentOkBody createTestContentOkBody(	
                                final long contentChecksum
	                        )
    {
	    return new TestContentOkBodyImpl(
                                contentChecksum
		                    );
    }
    
		
		
	
    public ProtocolVersionMethodConverter getProtocolVersionMethodConverter()
    {
        return _protocolVersionConverter;
    }	

    
}
