/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio;

import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Set;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.ExceptionMonitor;
import org.apache.mina.common.IoConnectorConfig;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoService;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.support.AbstractIoFilterChain;
import org.apache.mina.common.support.DefaultConnectFuture;
import org.apache.mina.transport.socket.nio.MultiThreadSocketIoProcessor;
import org.apache.mina.transport.socket.nio.MultiThreadSocketSessionImpl;
import org.apache.mina.transport.socket.nio.SocketConnector;
import org.apache.mina.transport.socket.nio.SocketSessionImpl;
import org.apache.mina.util.NamePreservingRunnable;
import org.apache.mina.util.NewThreadExecutor;
import org.apache.mina.util.Queue;

public class MultiThreadSocketConnector
extends SocketConnector {
    private static volatile int nextId = 0;
    private final Object lock = new Object();
    private final int id = nextId++;
    private final String threadName = "SocketConnector-" + this.id;
    private final Queue connectQueue = new Queue();
    private final MultiThreadSocketIoProcessor[] ioProcessors;
    private final int processorCount;
    private final Executor executor;
    private Selector selector;
    private Worker worker;
    private int processorDistributor = 0;
    private int workerTimeout = 60;

    public MultiThreadSocketConnector() {
        this(1, (Executor)new NewThreadExecutor());
    }

    public MultiThreadSocketConnector(int processorCount, Executor executor) {
        if (processorCount < 1) {
            throw new IllegalArgumentException("Must have at least one processor");
        }
        this.executor = executor;
        this.processorCount = processorCount;
        this.ioProcessors = new MultiThreadSocketIoProcessor[processorCount];
        for (int i = 0; i < processorCount; ++i) {
            this.ioProcessors[i] = new MultiThreadSocketIoProcessor("SocketConnectorIoProcessor-" + this.id + "." + i, executor);
        }
    }

    public int getWorkerTimeout() {
        return this.workerTimeout;
    }

    public void setWorkerTimeout(int workerTimeout) {
        if (workerTimeout < 0) {
            throw new IllegalArgumentException("Must be >= 0");
        }
        this.workerTimeout = workerTimeout;
    }

    public ConnectFuture connect(SocketAddress address, IoHandler handler, IoServiceConfig config) {
        return this.connect(address, null, handler, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectFuture connect(SocketAddress address, SocketAddress localAddress, IoHandler handler, IoServiceConfig config) {
        if (address == null) {
            throw new NullPointerException("address");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        if (!(address instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unexpected address type: " + address.getClass());
        }
        if (localAddress != null && !(localAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unexpected local address type: " + localAddress.getClass());
        }
        if (config == null) {
            config = this.getDefaultConfig();
        }
        SocketChannel ch = null;
        boolean success = false;
        try {
            ch = SocketChannel.open();
            ch.socket().setReuseAddress(true);
            if (localAddress != null) {
                ch.socket().bind(localAddress);
            }
            ch.configureBlocking(false);
            if (ch.connect(address)) {
                DefaultConnectFuture future = new DefaultConnectFuture();
                this.newSession(ch, handler, config, (ConnectFuture)future);
                success = true;
                DefaultConnectFuture defaultConnectFuture = future;
                return defaultConnectFuture;
            }
            success = true;
        }
        catch (IOException e) {
            ConnectFuture connectFuture = DefaultConnectFuture.newFailedFuture((Throwable)e);
            return connectFuture;
        }
        finally {
            if (!success && ch != null) {
                try {
                    ch.close();
                }
                catch (IOException e) {
                    ExceptionMonitor.getInstance().exceptionCaught((Throwable)e);
                }
            }
        }
        ConnectionRequest request = new ConnectionRequest(ch, handler, config);
        Object object = this.lock;
        synchronized (object) {
            try {
                this.startupWorker();
            }
            catch (IOException e) {
                try {
                    ch.close();
                }
                catch (IOException e2) {
                    ExceptionMonitor.getInstance().exceptionCaught((Throwable)e2);
                }
                return DefaultConnectFuture.newFailedFuture((Throwable)e);
            }
        }
        object = this.connectQueue;
        synchronized (object) {
            this.connectQueue.push((Object)request);
        }
        this.selector.wakeup();
        return request;
    }

    private synchronized void startupWorker() throws IOException {
        if (this.worker == null) {
            this.selector = Selector.open();
            this.worker = new Worker();
            this.executor.execute((Runnable)new NamePreservingRunnable((Runnable)this.worker));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerNew() {
        if (this.connectQueue.isEmpty()) {
            return;
        }
        while (true) {
            ConnectionRequest req;
            Queue queue = this.connectQueue;
            synchronized (queue) {
                req = (ConnectionRequest)((Object)this.connectQueue.pop());
            }
            if (req == null) break;
            SocketChannel ch = req.channel;
            try {
                ch.register(this.selector, 8, (Object)req);
            }
            catch (IOException e) {
                req.setException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSessions(Set keys) {
        for (SelectionKey key : keys) {
            if (!key.isConnectable()) continue;
            SocketChannel ch = (SocketChannel)key.channel();
            ConnectionRequest entry = (ConnectionRequest)((Object)key.attachment());
            boolean success = false;
            try {
                ch.finishConnect();
                this.newSession(ch, entry.handler, entry.config, (ConnectFuture)entry);
                success = true;
            }
            catch (Throwable e) {
                entry.setException(e);
            }
            finally {
                key.cancel();
                if (success) continue;
                try {
                    ch.close();
                }
                catch (IOException e) {
                    ExceptionMonitor.getInstance().exceptionCaught((Throwable)e);
                }
            }
        }
        keys.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTimedOutSessions(Set keys) {
        long currentTime = System.currentTimeMillis();
        for (SelectionKey key : keys) {
            ConnectionRequest entry;
            if (!key.isValid() || currentTime < (entry = (ConnectionRequest)((Object)key.attachment())).deadline) continue;
            entry.setException(new ConnectException());
            try {
                key.channel().close();
            }
            catch (IOException e) {
                ExceptionMonitor.getInstance().exceptionCaught((Throwable)e);
            }
            finally {
                key.cancel();
            }
        }
    }

    private void newSession(SocketChannel ch, IoHandler handler, IoServiceConfig config, ConnectFuture connectFuture) throws IOException {
        MultiThreadSocketSessionImpl session = new MultiThreadSocketSessionImpl((IoService)this, this.nextProcessor(), this.getListeners(), config, ch, handler, ch.socket().getRemoteSocketAddress());
        try {
            this.getFilterChainBuilder().buildFilterChain(session.getFilterChain());
            config.getFilterChainBuilder().buildFilterChain(session.getFilterChain());
            config.getThreadModel().buildFilterChain(session.getFilterChain());
        }
        catch (Throwable e) {
            throw (IOException)new IOException("Failed to create a session.").initCause(e);
        }
        session.setAttribute(AbstractIoFilterChain.CONNECT_FUTURE, connectFuture);
        session.getIoProcessor().addNew((SocketSessionImpl)session);
    }

    private MultiThreadSocketIoProcessor nextProcessor() {
        return this.ioProcessors[this.processorDistributor++ % this.processorCount];
    }

    private class ConnectionRequest
    extends DefaultConnectFuture {
        private final SocketChannel channel;
        private final long deadline;
        private final IoHandler handler;
        private final IoServiceConfig config;

        private ConnectionRequest(SocketChannel channel, IoHandler handler, IoServiceConfig config) {
            this.channel = channel;
            long timeout = config instanceof IoConnectorConfig ? ((IoConnectorConfig)config).getConnectTimeoutMillis() : ((IoConnectorConfig)MultiThreadSocketConnector.this.getDefaultConfig()).getConnectTimeoutMillis();
            this.deadline = System.currentTimeMillis() + timeout;
            this.handler = handler;
            this.config = config;
        }
    }

    private class Worker
    implements Runnable {
        private long lastActive = System.currentTimeMillis();

        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Thread.currentThread().setName(MultiThreadSocketConnector.this.threadName);
            block12: while (true) {
                try {
                    while (true) {
                        int nKeys = MultiThreadSocketConnector.this.selector.select(1000L);
                        MultiThreadSocketConnector.this.registerNew();
                        if (nKeys > 0) {
                            MultiThreadSocketConnector.this.processSessions(MultiThreadSocketConnector.this.selector.selectedKeys());
                        }
                        MultiThreadSocketConnector.this.processTimedOutSessions(MultiThreadSocketConnector.this.selector.keys());
                        if (MultiThreadSocketConnector.this.selector.keys().isEmpty()) {
                            if (System.currentTimeMillis() - this.lastActive <= (long)MultiThreadSocketConnector.this.workerTimeout * 1000L) continue;
                            Object object = MultiThreadSocketConnector.this.lock;
                            synchronized (object) {
                                if (MultiThreadSocketConnector.this.selector.keys().isEmpty() && MultiThreadSocketConnector.this.connectQueue.isEmpty()) {
                                    MultiThreadSocketConnector.this.worker = null;
                                    try {
                                        MultiThreadSocketConnector.this.selector.close();
                                    }
                                    catch (IOException e) {
                                        ExceptionMonitor.getInstance().exceptionCaught((Throwable)e);
                                    }
                                    finally {
                                        MultiThreadSocketConnector.this.selector = null;
                                    }
                                    break block12;
                                }
                                continue block12;
                            }
                        }
                        this.lastActive = System.currentTimeMillis();
                    }
                }
                catch (IOException e) {
                    ExceptionMonitor.getInstance().exceptionCaught((Throwable)e);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        ExceptionMonitor.getInstance().exceptionCaught((Throwable)e1);
                    }
                    continue;
                }
                break;
            }
        }
    }
}

