/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio;

import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoService;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.IoSessionConfig;
import org.apache.mina.common.RuntimeIOException;
import org.apache.mina.common.TransportType;
import org.apache.mina.common.support.BaseIoSessionConfig;
import org.apache.mina.common.support.IoServiceListenerSupport;
import org.apache.mina.transport.socket.nio.MultiThreadSocketFilterChain;
import org.apache.mina.transport.socket.nio.MultiThreadSocketIoProcessor;
import org.apache.mina.transport.socket.nio.SocketIoProcessor;
import org.apache.mina.transport.socket.nio.SocketSessionConfig;
import org.apache.mina.transport.socket.nio.SocketSessionConfigImpl;
import org.apache.mina.transport.socket.nio.SocketSessionImpl;
import org.apache.mina.util.Queue;

class MultiThreadSocketSessionImpl
extends SocketSessionImpl {
    private final IoService manager;
    private final IoServiceConfig serviceConfig;
    private final SocketSessionConfig config = new SessionConfigImpl();
    private final MultiThreadSocketIoProcessor ioProcessor;
    private final MultiThreadSocketFilterChain filterChain;
    private final SocketChannel ch;
    private final Queue writeRequestQueue;
    private final IoHandler handler;
    private final SocketAddress remoteAddress;
    private final SocketAddress localAddress;
    private final SocketAddress serviceAddress;
    private final IoServiceListenerSupport serviceListeners;
    private SelectionKey readKey;
    private SelectionKey writeKey;
    private int readBufferSize;
    private CountDownLatch registeredReadyLatch = new CountDownLatch(2);
    private AtomicBoolean created = new AtomicBoolean(false);

    MultiThreadSocketSessionImpl(IoService manager, SocketIoProcessor ioProcessor, IoServiceListenerSupport listeners, IoServiceConfig serviceConfig, SocketChannel ch, IoHandler defaultHandler, SocketAddress serviceAddress) {
        super(manager, ioProcessor, listeners, serviceConfig, ch, defaultHandler, serviceAddress);
        this.manager = manager;
        this.serviceListeners = listeners;
        this.ioProcessor = (MultiThreadSocketIoProcessor)ioProcessor;
        this.filterChain = new MultiThreadSocketFilterChain((IoSession)this);
        this.ch = ch;
        this.writeRequestQueue = new Queue();
        this.handler = defaultHandler;
        this.remoteAddress = ch.socket().getRemoteSocketAddress();
        this.localAddress = ch.socket().getLocalSocketAddress();
        this.serviceAddress = serviceAddress;
        this.serviceConfig = serviceConfig;
        IoSessionConfig sessionConfig = serviceConfig.getSessionConfig();
        if (sessionConfig instanceof SocketSessionConfig) {
            SocketSessionConfig cfg = (SocketSessionConfig)sessionConfig;
            this.config.setKeepAlive(cfg.isKeepAlive());
            this.config.setOobInline(cfg.isOobInline());
            this.config.setReceiveBufferSize(cfg.getReceiveBufferSize());
            this.readBufferSize = cfg.getReceiveBufferSize();
            this.config.setReuseAddress(cfg.isReuseAddress());
            this.config.setSendBufferSize(cfg.getSendBufferSize());
            this.config.setSoLinger(cfg.getSoLinger());
            this.config.setTcpNoDelay(cfg.isTcpNoDelay());
            if (this.config.getTrafficClass() != cfg.getTrafficClass()) {
                this.config.setTrafficClass(cfg.getTrafficClass());
            }
        }
    }

    void awaitRegistration() throws InterruptedException {
        this.registeredReadyLatch.countDown();
        this.registeredReadyLatch.await();
    }

    boolean created() throws InterruptedException {
        return this.created.get();
    }

    void doneCreation() {
        this.created.getAndSet(true);
    }

    public IoService getService() {
        return this.manager;
    }

    public IoServiceConfig getServiceConfig() {
        return this.serviceConfig;
    }

    public IoSessionConfig getConfig() {
        return this.config;
    }

    SocketIoProcessor getIoProcessor() {
        return this.ioProcessor;
    }

    public IoFilterChain getFilterChain() {
        return this.filterChain;
    }

    SocketChannel getChannel() {
        return this.ch;
    }

    IoServiceListenerSupport getServiceListeners() {
        return this.serviceListeners;
    }

    SelectionKey getSelectionKey() {
        return this.readKey;
    }

    SelectionKey getReadSelectionKey() {
        return this.readKey;
    }

    SelectionKey getWriteSelectionKey() {
        return this.writeKey;
    }

    void setSelectionKey(SelectionKey key) {
        this.readKey = key;
    }

    void setWriteSelectionKey(SelectionKey key) {
        this.writeKey = key;
    }

    public IoHandler getHandler() {
        return this.handler;
    }

    protected void close0() {
        this.filterChain.fireFilterClose((IoSession)this);
    }

    Queue getWriteRequestQueue() {
        return this.writeRequestQueue;
    }

    public int getScheduledWriteMessages() {
        return this.getScheduledWriteRequests();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getScheduledWriteRequests() {
        Queue queue = this.writeRequestQueue;
        synchronized (queue) {
            return this.writeRequestQueue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getScheduledWriteBytes() {
        Queue queue = this.writeRequestQueue;
        synchronized (queue) {
            return this.writeRequestQueue.byteSize();
        }
    }

    protected void write0(IoFilter.WriteRequest writeRequest) {
        this.filterChain.fireFilterWrite((IoSession)this, writeRequest);
    }

    public TransportType getTransportType() {
        return TransportType.SOCKET;
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public SocketAddress getServiceAddress() {
        return this.serviceAddress;
    }

    protected void updateTrafficMask() {
        this.ioProcessor.updateTrafficMask(this);
    }

    int getReadBufferSize() {
        return this.readBufferSize;
    }

    private class SessionConfigImpl
    extends BaseIoSessionConfig
    implements SocketSessionConfig {
        private SessionConfigImpl() {
        }

        public boolean isKeepAlive() {
            try {
                return MultiThreadSocketSessionImpl.this.ch.socket().getKeepAlive();
            }
            catch (SocketException e) {
                throw new RuntimeIOException((Throwable)e);
            }
        }

        public void setKeepAlive(boolean on) {
            try {
                MultiThreadSocketSessionImpl.this.ch.socket().setKeepAlive(on);
            }
            catch (SocketException e) {
                throw new RuntimeIOException((Throwable)e);
            }
        }

        public boolean isOobInline() {
            try {
                return MultiThreadSocketSessionImpl.this.ch.socket().getOOBInline();
            }
            catch (SocketException e) {
                throw new RuntimeIOException((Throwable)e);
            }
        }

        public void setOobInline(boolean on) {
            try {
                MultiThreadSocketSessionImpl.this.ch.socket().setOOBInline(on);
            }
            catch (SocketException e) {
                throw new RuntimeIOException((Throwable)e);
            }
        }

        public boolean isReuseAddress() {
            try {
                return MultiThreadSocketSessionImpl.this.ch.socket().getReuseAddress();
            }
            catch (SocketException e) {
                throw new RuntimeIOException((Throwable)e);
            }
        }

        public void setReuseAddress(boolean on) {
            try {
                MultiThreadSocketSessionImpl.this.ch.socket().setReuseAddress(on);
            }
            catch (SocketException e) {
                throw new RuntimeIOException((Throwable)e);
            }
        }

        public int getSoLinger() {
            try {
                return MultiThreadSocketSessionImpl.this.ch.socket().getSoLinger();
            }
            catch (SocketException e) {
                throw new RuntimeIOException((Throwable)e);
            }
        }

        public void setSoLinger(int linger) {
            try {
                if (linger < 0) {
                    MultiThreadSocketSessionImpl.this.ch.socket().setSoLinger(false, 0);
                } else {
                    MultiThreadSocketSessionImpl.this.ch.socket().setSoLinger(true, linger);
                }
            }
            catch (SocketException e) {
                throw new RuntimeIOException((Throwable)e);
            }
        }

        public boolean isTcpNoDelay() {
            try {
                return MultiThreadSocketSessionImpl.this.ch.socket().getTcpNoDelay();
            }
            catch (SocketException e) {
                throw new RuntimeIOException((Throwable)e);
            }
        }

        public void setTcpNoDelay(boolean on) {
            try {
                MultiThreadSocketSessionImpl.this.ch.socket().setTcpNoDelay(on);
            }
            catch (SocketException e) {
                throw new RuntimeIOException((Throwable)e);
            }
        }

        public int getTrafficClass() {
            block3: {
                if (SocketSessionConfigImpl.isGetTrafficClassAvailable()) {
                    try {
                        return MultiThreadSocketSessionImpl.this.ch.socket().getTrafficClass();
                    }
                    catch (SocketException e) {
                        if (!SocketSessionConfigImpl.isSetTrafficClassAvailable()) break block3;
                        throw new RuntimeIOException((Throwable)e);
                    }
                }
            }
            return 0;
        }

        public void setTrafficClass(int tc) {
            if (SocketSessionConfigImpl.isSetTrafficClassAvailable()) {
                try {
                    MultiThreadSocketSessionImpl.this.ch.socket().setTrafficClass(tc);
                }
                catch (SocketException e) {
                    throw new RuntimeIOException((Throwable)e);
                }
            }
        }

        public int getSendBufferSize() {
            try {
                return MultiThreadSocketSessionImpl.this.ch.socket().getSendBufferSize();
            }
            catch (SocketException e) {
                throw new RuntimeIOException((Throwable)e);
            }
        }

        public void setSendBufferSize(int size) {
            if (SocketSessionConfigImpl.isSetSendBufferSizeAvailable()) {
                try {
                    MultiThreadSocketSessionImpl.this.ch.socket().setSendBufferSize(size);
                }
                catch (SocketException e) {
                    throw new RuntimeIOException((Throwable)e);
                }
            }
        }

        public int getReceiveBufferSize() {
            try {
                return MultiThreadSocketSessionImpl.this.ch.socket().getReceiveBufferSize();
            }
            catch (SocketException e) {
                throw new RuntimeIOException((Throwable)e);
            }
        }

        public void setReceiveBufferSize(int size) {
            if (SocketSessionConfigImpl.isSetReceiveBufferSizeAvailable()) {
                try {
                    MultiThreadSocketSessionImpl.this.ch.socket().setReceiveBufferSize(size);
                    MultiThreadSocketSessionImpl.this.readBufferSize = size;
                }
                catch (SocketException e) {
                    throw new RuntimeIOException((Throwable)e);
                }
            }
        }
    }
}

